/*
 * Decompiled with CFR 0.152.
 */
package com.code_intelligence.jazzer.driver;

import com.code_intelligence.jazzer.driver.OptParser;
import com.code_intelligence.jazzer.utils.Log;
import java.util.Collections;
import java.util.List;
import java.util.Set;
import java.util.stream.Collectors;
import java.util.stream.Stream;

public final class Opt {
    public static final String autofuzz;
    public static final List<String> autofuzzIgnore;
    public static final String coverageDump;
    public static final String coverageReport;
    public static final List<String> customHookIncludes;
    public static final List<String> customHookExcludes;
    public static final List<String> customHooks;
    public static final List<String> disabledHooks;
    public static final String dumpClassesDir;
    public static final boolean hooks;
    public static final String idSyncFile;
    public static final List<String> instrumentationIncludes;
    public static final List<String> instrumentationExcludes;
    public static final Set<Long> ignore;
    public static final long keepGoing;
    public static final String reproducerPath;
    public static final String targetClass;
    public static final String targetMethod;
    public static final List<String> trace;
    public static final List<String> targetArgs;
    public static final boolean dedup;
    public static final boolean conditionalHooks;
    static final boolean mergeInner;
    private static final boolean help;
    private static final boolean version;

    static {
        OptParser.ignoreSetting("instrument");
        OptParser.ignoreSetting("valueprofile");
        OptParser.stringListSetting("cp", "The class path to use for fuzzing (native launcher only)");
        OptParser.stringListSetting("jvm_args", "Arguments to pass to the JVM (separator can be escaped with '\\', native launcher only)");
        OptParser.stringListSetting("additional_jvm_args", "Additional arguments to pass to the JVM (separator can be escaped with '\\', native launcher only)");
        OptParser.stringSetting("agent_path", null, "Custom path to jazzer_agent_deploy.jar (native launcher only)");
        OptParser.boolSetting("asan", false, "Allow fuzzing of native libraries compiled with '-fsanitize=address'");
        OptParser.boolSetting("ubsan", false, "Allow fuzzing of native libraries compiled with '-fsanitize=undefined'");
        OptParser.boolSetting("native", false, "Allow fuzzing of native libraries compiled with '-fsanitize=fuzzer' (implied by --asan and --ubsan)");
        autofuzz = OptParser.stringSetting("autofuzz", "", "Fully qualified reference (optionally with a Javadoc-style signature) to a method on the class path to be fuzzed with automatically generated arguments (examples: java.lang.System.out::println, java.lang.String::new(byte[]))");
        autofuzzIgnore = OptParser.stringListSetting("autofuzz_ignore", ',', "Fully qualified names of exception classes to ignore during fuzzing");
        coverageDump = OptParser.stringSetting("coverage_dump", "", "Path to write a JaCoCo .exec file to when the fuzzer exits (if non-empty)");
        coverageReport = OptParser.stringSetting("coverage_report", "", "Path to write a human-readable coverage report to when the fuzzer exits (if non-empty)");
        customHookIncludes = OptParser.stringListSetting("custom_hook_includes", "Glob patterns matching names of classes to instrument with hooks (custom and built-in)");
        customHookExcludes = OptParser.stringListSetting("custom_hook_excludes", "Glob patterns matching names of classes that should not be instrumented with hooks (custom and built-in)");
        customHooks = OptParser.stringListSetting("custom_hooks", "Names of classes to load custom hooks from");
        disabledHooks = OptParser.stringListSetting("disabled_hooks", "Names of classes from which hooks (custom or built-in) should not be loaded from");
        dumpClassesDir = OptParser.stringSetting("dump_classes_dir", "", "Directory to dump instrumented .class files into (if non-empty)");
        hooks = OptParser.boolSetting("hooks", true, "Apply fuzzing instrumentation (use 'trace' for finer-grained control)");
        idSyncFile = OptParser.stringSetting("id_sync_file", null, null);
        instrumentationIncludes = OptParser.stringListSetting("instrumentation_includes", "Glob patterns matching names of classes to instrument for fuzzing");
        instrumentationExcludes = OptParser.stringListSetting("instrumentation_excludes", "Glob patterns matching names of classes that should not be instrumented for fuzzing");
        ignore = Collections.unmodifiableSet(OptParser.stringListSetting("ignore", ',', "Hex strings representing deduplication tokens of findings that should be ignored").stream().map(token -> Long.parseUnsignedLong(token, 16)).collect(Collectors.toSet()));
        keepGoing = OptParser.uint64Setting("keep_going", 1L, "Number of distinct findings after which the fuzzer should stop");
        reproducerPath = OptParser.stringSetting("reproducer_path", ".", "Directory in which stand-alone Java reproducers are stored for each finding");
        targetClass = OptParser.stringSetting("target_class", "", "Fully qualified name of the fuzz target class (required unless --autofuzz is specified)");
        targetMethod = OptParser.stringSetting("target_method", "", null);
        trace = OptParser.stringListSetting("trace", "Types of instrumentation to apply: cmp, cov, div, gep (disabled by default), indir, native");
        targetArgs = autofuzz.isEmpty() ? OptParser.stringListSetting("target_args", ' ', "Arguments to pass to the fuzz target's fuzzerInitialize method") : Collections.unmodifiableList(Stream.concat(Stream.of(autofuzz), autofuzzIgnore.stream()).collect(Collectors.toList()));
        dedup = OptParser.boolSetting("dedup", hooks, "Compute and print a deduplication token for every finding");
        conditionalHooks = OptParser.boolSetting("internal.conditional_hooks", false, null);
        mergeInner = OptParser.boolSetting("internal.merge_inner", false, null);
        help = OptParser.boolSetting("help", false, "Show this list of all available arguments");
        version = OptParser.boolSetting("version", false, "Print version information");
        OptParser.failOnUnknownArgument();
        if (help) {
            Log.println(OptParser.getHelpText());
            System.exit(0);
        }
        if (version) {
            Log.println("Jazzer v0.15.0");
            System.exit(0);
        }
        if (!targetClass.isEmpty() && !autofuzz.isEmpty()) {
            Log.error("--target_class and --autofuzz cannot be specified together");
            System.exit(1);
        }
        if (!OptParser.stringListSetting("target_args", ' ', null).isEmpty() && !autofuzz.isEmpty()) {
            Log.error("--target_args and --autofuzz cannot be specified together");
            System.exit(1);
        }
        if (autofuzz.isEmpty() && !autofuzzIgnore.isEmpty()) {
            Log.error("--autofuzz_ignore requires --autofuzz");
            System.exit(1);
        }
        if (!(ignore.isEmpty() && keepGoing <= 1L || dedup)) {
            Log.error("--nodedup is not supported with --ignore or --keep_going");
            System.exit(1);
        }
    }
}

