/*
 * Decompiled with CFR 0.152.
 */
package com.code_intelligence.jazzer.driver;

import com.code_intelligence.jazzer.utils.Log;
import java.io.File;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.TreeMap;
import java.util.stream.Collectors;
import java.util.stream.Stream;

final class OptParser {
    private static final String[] HELP_HEADER = new String[]{"A coverage-guided, in-process fuzzer for the JVM", "", "Usage:", String.format("  java -cp jazzer.jar[%cclasspath_entries] com.code_intelligence.jazzer.Jazzer --target_class=<target class> [args...]", Character.valueOf(File.separatorChar)), String.format("  java -cp jazzer.jar[%cclasspath_entries] com.code_intelligence.jazzer.Jazzer --autofuzz=<method reference> [args...]", Character.valueOf(File.separatorChar)), "", "In addition to the options listed below, Jazzer also accepts all", "libFuzzer options described at:", "  https://llvm.org/docs/LibFuzzer.html#options", "", "Options:"};
    private static final String OPTIONS_PREFIX = "jazzer.";
    private static final Map<String, OptDetails> knownArgs = new TreeMap<String, OptDetails>();

    OptParser() {
    }

    static String getHelpText() {
        return Stream.concat(Arrays.stream(HELP_HEADER), knownArgs.values().stream().filter(Objects::nonNull).map(OptDetails::toString)).collect(Collectors.joining("\n\n"));
    }

    static void ignoreSetting(String name) {
        knownArgs.put(name, null);
    }

    static String stringSetting(String name, String defaultValue, String description2) {
        knownArgs.put(name, OptDetails.create(name, "string", defaultValue, description2));
        return System.getProperty(OPTIONS_PREFIX + name, defaultValue);
    }

    static List<String> stringListSetting(String name, String description2) {
        return OptParser.stringListSetting(name, File.pathSeparatorChar, description2);
    }

    static List<String> stringListSetting(String name, char separator, String description2) {
        knownArgs.put(name, OptDetails.create(name, String.format("list separated by '%c'", Character.valueOf(separator)), "", description2));
        String value = System.getProperty(OPTIONS_PREFIX + name);
        if (value == null || value.isEmpty()) {
            return Collections.emptyList();
        }
        return OptParser.splitOnUnescapedSeparator(value, separator);
    }

    static boolean boolSetting(String name, boolean defaultValue, String description2) {
        knownArgs.put(name, OptDetails.create(name, "boolean", Boolean.toString(defaultValue), description2));
        String value = System.getProperty(OPTIONS_PREFIX + name);
        if (value == null) {
            return defaultValue;
        }
        return Boolean.parseBoolean(value);
    }

    static long uint64Setting(String name, long defaultValue, String description2) {
        knownArgs.put(name, OptDetails.create(name, "uint64", Long.toUnsignedString(defaultValue), description2));
        String value = System.getProperty(OPTIONS_PREFIX + name);
        if (value == null) {
            return defaultValue;
        }
        return Long.parseUnsignedLong(value, 10);
    }

    static void failOnUnknownArgument() {
        System.getProperties().keySet().stream().map(key -> (String)key).filter(key -> key.startsWith(OPTIONS_PREFIX)).map(key -> key.substring(OPTIONS_PREFIX.length())).filter(key -> !key.startsWith("internal.")).filter(key -> !knownArgs.containsKey(key)).findFirst().ifPresent(unknownArg -> {
            Log.error(String.format("Unknown argument '--%1$s' or property 'jazzer.%1$s' (list all available arguments with --help)", unknownArg));
            System.exit(1);
        });
    }

    static List<String> splitOnUnescapedSeparator(String value, char separator) {
        if (separator == '\\') {
            throw new IllegalArgumentException("separator '\\' is not supported");
        }
        ArrayList<String> tokens = new ArrayList<String>();
        StringBuilder currentToken = new StringBuilder();
        boolean inEscapeState = false;
        for (int pos = 0; pos < value.length(); ++pos) {
            char c = value.charAt(pos);
            if (inEscapeState) {
                currentToken.append(c);
                inEscapeState = false;
                continue;
            }
            if (c == '\\') {
                inEscapeState = true;
                continue;
            }
            if (c == separator) {
                if (currentToken.length() > 0) {
                    tokens.add(currentToken.toString());
                }
                currentToken.setLength(0);
                continue;
            }
            currentToken.append(c);
        }
        if (currentToken.length() > 0) {
            tokens.add(currentToken.toString());
        }
        return Collections.unmodifiableList(tokens);
    }

    private static final class OptDetails {
        final String name;
        final String type;
        final String defaultValue;
        final String description;

        private OptDetails(String name, String type2, String defaultValue, String description2) {
            this.name = name;
            this.type = type2;
            this.defaultValue = defaultValue;
            this.description = description2;
        }

        static OptDetails create(String name, String type2, String defaultValue, String description2) {
            if (description2 == null) {
                return null;
            }
            return new OptDetails(OptDetails.checkNotNullOrEmpty(name, "name"), OptDetails.checkNotNullOrEmpty(type2, "type"), defaultValue, OptDetails.checkNotNullOrEmpty(description2, "description"));
        }

        public String toString() {
            return String.format("--%s (%s, default: \"%s\")%n     %s", this.name, this.type, this.defaultValue, this.description);
        }

        private static String checkNotNullOrEmpty(String arg, String name) {
            if (arg == null) {
                throw new NullPointerException(name + " must not be null");
            }
            if (arg.isEmpty()) {
                throw new NullPointerException(name + " must not be empty");
            }
            return arg;
        }
    }
}

