/*
 * Decompiled with CFR 0.152.
 */
package com.code_intelligence.jazzer.third_party.com.github.fmeum.rules_jni;

import com.code_intelligence.jazzer.third_party.com.github.fmeum.rules_jni.CoverageHelper;
import com.code_intelligence.jazzer.third_party.com.github.fmeum.rules_jni.NativeLibraryInfo;
import com.code_intelligence.jazzer.third_party.com.github.fmeum.rules_jni.OsCpuUtils;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.net.URL;
import java.nio.file.FileVisitOption;
import java.nio.file.Files;
import java.nio.file.Path;
import java.nio.file.StandardCopyOption;
import java.nio.file.attribute.FileAttribute;
import java.util.Comparator;
import java.util.HashMap;
import java.util.Map;
import java.util.stream.Stream;

public final class RulesJni {
    private static final Map<String, NativeLibraryInfo> LOADED_LIBS = new HashMap<String, NativeLibraryInfo>();
    private static Path tempDir;

    private RulesJni() {
    }

    public static void loadLibrary(String name, Class<?> inSamePackageAs) {
        URL libraryResource = inSamePackageAs.getResource(RulesJni.libraryRelativePath(name));
        RulesJni.failOnNullResource(libraryResource, name);
        RulesJni.loadLibrary(name, libraryResource);
    }

    public static void loadLibrary(String name, String absolutePathToPackage) {
        if (absolutePathToPackage == null) {
            throw new NullPointerException("absolutePathToPackage must not be null");
        }
        URL libraryResource = RulesJni.class.getResource(absolutePathToPackage + "/" + RulesJni.libraryRelativePath(name));
        RulesJni.failOnNullResource(libraryResource, name);
        RulesJni.loadLibrary(name, libraryResource);
    }

    public static Path extractLibrary(String name, Class<?> inSamePackageAs) throws IOException {
        URL libraryResource = inSamePackageAs.getResource(RulesJni.libraryRelativePath(name));
        RulesJni.failOnNullResource(libraryResource, name);
        return RulesJni.extractLibrary(RulesJni.libraryBasename(name), libraryResource);
    }

    public static Path extractLibrary(String name, String absolutePathToPackage) throws IOException {
        if (absolutePathToPackage == null) {
            throw new NullPointerException("absolutePathToPackage must not be null");
        }
        URL libraryResource = RulesJni.class.getResource(absolutePathToPackage + "/" + RulesJni.libraryRelativePath(name));
        RulesJni.failOnNullResource(libraryResource, name);
        return RulesJni.extractLibrary(RulesJni.libraryBasename(name), libraryResource);
    }

    private static synchronized void loadLibrary(String name, URL libraryResource) {
        Path tempFile;
        String basename = RulesJni.libraryBasename(name);
        if (LOADED_LIBS.containsKey(basename)) {
            if (!libraryResource.toString().equals(RulesJni.LOADED_LIBS.get((Object)basename).canonicalPath)) {
                throw new UnsatisfiedLinkError(String.format("Cannot load two native libraries with same basename ('%s') from different paths\nFirst library: %s\nSecond library: %s\n", basename, RulesJni.LOADED_LIBS.get((Object)basename).canonicalPath, libraryResource));
            }
            return;
        }
        try {
            tempFile = RulesJni.extractLibrary(basename, libraryResource);
        }
        catch (IOException e) {
            throw new UnsatisfiedLinkError(e.getMessage());
        }
        System.load(tempFile.toAbsolutePath().toString());
        LOADED_LIBS.put(basename, new NativeLibraryInfo(libraryResource.toString(), tempFile.toFile()));
        CoverageHelper.initCoverage(basename);
    }

    private static Path extractLibrary(String basename, URL libraryResource) throws IOException {
        Path tempDir = RulesJni.getOrCreateTempDir();
        String mappedName = System.mapLibraryName(basename);
        int lastDot = mappedName.lastIndexOf(46);
        Path tempFile = Files.createTempFile(tempDir, mappedName.substring(0, lastDot) + "_", mappedName.substring(lastDot), new FileAttribute[0]);
        try (InputStream in = libraryResource.openStream();){
            Files.copy(in, tempFile, StandardCopyOption.REPLACE_EXISTING);
        }
        return tempFile;
    }

    private static Path getOrCreateTempDir() throws IOException {
        if (tempDir == null) {
            tempDir = Files.createTempDirectory("rules_jni.", new FileAttribute[0]);
        }
        return tempDir;
    }

    private static String libraryBasename(String name) {
        return name.substring(name.lastIndexOf(47) + 1);
    }

    private static String libraryRelativePath(String name) {
        if (name == null) {
            throw new NullPointerException("name must not be null");
        }
        String basename = RulesJni.libraryBasename(name);
        String path = name.substring(0, name.length() - basename.length());
        return String.format("%s%s_%s_%s/%s", path, basename, OsCpuUtils.CANONICAL_OS, OsCpuUtils.CANONICAL_CPU, System.mapLibraryName(basename));
    }

    private static void failOnNullResource(URL resource, String name) {
        if (resource == null) {
            throw new UnsatisfiedLinkError(String.format("Failed to find native library '%s' for OS '%s' (\"%s\") and CPU '%s' (\"%s\")", name, OsCpuUtils.CANONICAL_OS, OsCpuUtils.VERBOSE_OS, OsCpuUtils.CANONICAL_CPU, OsCpuUtils.VERBOSE_CPU));
        }
    }

    private static void atExit() {
        boolean skipCleanup = Boolean.parseBoolean(System.getenv("RULES_JNI_SKIP_CLEANUP"));
        if (skipCleanup) {
            System.err.println("[rules_jni] Not cleaning up temporary directory as requested: " + tempDir);
        }
        CoverageHelper.collectNativeLibrariesCoverage(LOADED_LIBS);
        if (!skipCleanup) {
            try (Stream<Path> tempFiles = Files.walk(tempDir, new FileVisitOption[0]);){
                tempFiles.sorted(Comparator.reverseOrder()).map(Path::toFile).forEach(File::delete);
            }
            catch (IOException iOException) {
                // empty catch block
            }
        }
    }

    static {
        Runtime.getRuntime().addShutdownHook(new Thread(RulesJni::atExit));
    }
}

