/*
 * Decompiled with CFR 0.152.
 */
package com.code_intelligence.jazzer.third_party.kotlin.reflect.jvm.internal.impl.descriptors.runtime.structure;

import com.code_intelligence.jazzer.third_party.kotlin.collections.ArraysKt;
import com.code_intelligence.jazzer.third_party.kotlin.collections.CollectionsKt;
import com.code_intelligence.jazzer.third_party.kotlin.jvm.internal.Intrinsics;
import com.code_intelligence.jazzer.third_party.kotlin.reflect.jvm.internal.impl.descriptors.runtime.structure.ReflectJavaType;
import com.code_intelligence.jazzer.third_party.kotlin.reflect.jvm.internal.impl.load.java.structure.JavaAnnotation;
import com.code_intelligence.jazzer.third_party.kotlin.reflect.jvm.internal.impl.load.java.structure.JavaWildcardType;
import java.lang.reflect.Type;
import java.lang.reflect.WildcardType;
import java.util.Collection;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public final class ReflectJavaWildcardType
extends ReflectJavaType
implements JavaWildcardType {
    @NotNull
    private final WildcardType reflectType;
    @NotNull
    private final Collection<JavaAnnotation> annotations;
    private final boolean isDeprecatedInJavaDoc;

    public ReflectJavaWildcardType(@NotNull WildcardType reflectType) {
        Intrinsics.checkNotNullParameter(reflectType, "reflectType");
        this.reflectType = reflectType;
        this.annotations = CollectionsKt.emptyList();
    }

    @Override
    @NotNull
    protected WildcardType getReflectType() {
        return this.reflectType;
    }

    @Override
    @Nullable
    public ReflectJavaType getBound() {
        ReflectJavaType reflectJavaType;
        Type[] upperBounds2 = this.getReflectType().getUpperBounds();
        Type[] lowerBounds = this.getReflectType().getLowerBounds();
        if (upperBounds2.length > 1 || lowerBounds.length > 1) {
            throw new UnsupportedOperationException("Wildcard types with many bounds are not yet supported: " + this.getReflectType());
        }
        if (lowerBounds.length == 1) {
            Intrinsics.checkNotNullExpressionValue(lowerBounds, "lowerBounds");
            Type type2 = ArraysKt.single(lowerBounds);
            Intrinsics.checkNotNullExpressionValue(type2, "lowerBounds.single()");
            reflectJavaType = ReflectJavaType.Factory.create(type2);
        } else if (upperBounds2.length == 1) {
            Intrinsics.checkNotNullExpressionValue(upperBounds2, "upperBounds");
            Type ub = ArraysKt.single(upperBounds2);
            boolean bl = false;
            if (!Intrinsics.areEqual(ub, Object.class)) {
                Intrinsics.checkNotNullExpressionValue(ub, "ub");
                reflectJavaType = ReflectJavaType.Factory.create(ub);
            } else {
                reflectJavaType = null;
            }
        } else {
            reflectJavaType = null;
        }
        return reflectJavaType;
    }

    @Override
    public boolean isExtends() {
        Type[] typeArray = this.getReflectType().getUpperBounds();
        Intrinsics.checkNotNullExpressionValue(typeArray, "reflectType.upperBounds");
        return !Intrinsics.areEqual(ArraysKt.firstOrNull((Object[])typeArray), Object.class);
    }

    @Override
    @NotNull
    public Collection<JavaAnnotation> getAnnotations() {
        return this.annotations;
    }

    @Override
    public boolean isDeprecatedInJavaDoc() {
        return this.isDeprecatedInJavaDoc;
    }
}

