/*
 * Decompiled with CFR 0.152.
 */
package com.code_intelligence.jazzer.third_party.kotlin.reflect.jvm.internal.impl.types;

import com.code_intelligence.jazzer.third_party.kotlin.jvm.internal.Intrinsics;
import com.code_intelligence.jazzer.third_party.kotlin.reflect.jvm.internal.impl.descriptors.ClassifierDescriptor;
import com.code_intelligence.jazzer.third_party.kotlin.reflect.jvm.internal.impl.descriptors.DeclarationDescriptor;
import com.code_intelligence.jazzer.third_party.kotlin.reflect.jvm.internal.impl.descriptors.ModuleDescriptor;
import com.code_intelligence.jazzer.third_party.kotlin.reflect.jvm.internal.impl.descriptors.PackageFragmentDescriptor;
import com.code_intelligence.jazzer.third_party.kotlin.reflect.jvm.internal.impl.resolve.DescriptorUtils;
import com.code_intelligence.jazzer.third_party.kotlin.reflect.jvm.internal.impl.types.TypeConstructor;
import com.code_intelligence.jazzer.third_party.kotlin.reflect.jvm.internal.impl.types.error.ErrorUtils;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public abstract class ClassifierBasedTypeConstructor
implements TypeConstructor {
    private int hashCode;

    @Override
    @NotNull
    public abstract ClassifierDescriptor getDeclarationDescriptor();

    public int hashCode() {
        int computedHashCode;
        int n;
        int cachedHashCode = this.hashCode;
        if (cachedHashCode != 0) {
            return cachedHashCode;
        }
        ClassifierDescriptor descriptor2 = this.getDeclarationDescriptor();
        int it = n = (computedHashCode = this.hasMeaningfulFqName(descriptor2) ? DescriptorUtils.getFqName(descriptor2).hashCode() : System.identityHashCode(this));
        boolean bl = false;
        this.hashCode = it;
        return n;
    }

    public boolean equals(@Nullable Object other) {
        if (this == other) {
            return true;
        }
        if (!(other instanceof TypeConstructor)) {
            return false;
        }
        if (other.hashCode() != this.hashCode()) {
            return false;
        }
        if (((TypeConstructor)other).getParameters().size() != this.getParameters().size()) {
            return false;
        }
        ClassifierDescriptor myDescriptor = this.getDeclarationDescriptor();
        ClassifierDescriptor classifierDescriptor = ((TypeConstructor)other).getDeclarationDescriptor();
        if (classifierDescriptor == null) {
            return false;
        }
        ClassifierDescriptor otherDescriptor = classifierDescriptor;
        if (!this.hasMeaningfulFqName(myDescriptor) || !this.hasMeaningfulFqName(otherDescriptor)) {
            return false;
        }
        return this.isSameClassifier(otherDescriptor);
    }

    protected abstract boolean isSameClassifier(@NotNull ClassifierDescriptor var1);

    protected final boolean areFqNamesEqual(@NotNull ClassifierDescriptor first, @NotNull ClassifierDescriptor second) {
        Intrinsics.checkNotNullParameter(first, "first");
        Intrinsics.checkNotNullParameter(second, "second");
        if (!Intrinsics.areEqual(first.getName(), second.getName())) {
            return false;
        }
        DeclarationDescriptor a = first.getContainingDeclaration();
        for (DeclarationDescriptor b = second.getContainingDeclaration(); a != null && b != null; a = a.getContainingDeclaration(), b = b.getContainingDeclaration()) {
            if (a instanceof ModuleDescriptor) {
                return b instanceof ModuleDescriptor;
            }
            if (b instanceof ModuleDescriptor) {
                return false;
            }
            if (a instanceof PackageFragmentDescriptor) {
                return b instanceof PackageFragmentDescriptor && Intrinsics.areEqual(((PackageFragmentDescriptor)a).getFqName(), ((PackageFragmentDescriptor)b).getFqName());
            }
            if (b instanceof PackageFragmentDescriptor) {
                return false;
            }
            if (Intrinsics.areEqual(a.getName(), b.getName())) continue;
            return false;
        }
        return true;
    }

    private final boolean hasMeaningfulFqName(ClassifierDescriptor descriptor2) {
        return !ErrorUtils.isError(descriptor2) && !DescriptorUtils.isLocal(descriptor2);
    }
}

