/*
 * Decompiled with CFR 0.152.
 */
package com.code_intelligence.jazzer.third_party.nonapi.io.github.classgraph.classloaderhandler;

import com.code_intelligence.jazzer.third_party.nonapi.io.github.classgraph.classloaderhandler.ClassLoaderHandler;
import com.code_intelligence.jazzer.third_party.nonapi.io.github.classgraph.classpath.ClassLoaderOrder;
import com.code_intelligence.jazzer.third_party.nonapi.io.github.classgraph.classpath.ClasspathOrder;
import com.code_intelligence.jazzer.third_party.nonapi.io.github.classgraph.reflection.ReflectionUtils;
import com.code_intelligence.jazzer.third_party.nonapi.io.github.classgraph.scanspec.ScanSpec;
import com.code_intelligence.jazzer.third_party.nonapi.io.github.classgraph.utils.LogNode;
import java.net.URL;

class JPMSClassLoaderHandler
implements ClassLoaderHandler {
    private JPMSClassLoaderHandler() {
    }

    public static boolean canHandle(Class<?> classLoaderClass, LogNode log) {
        return "jdk.internal.loader.ClassLoaders$AppClassLoader".equals(classLoaderClass.getName()) || "jdk.internal.loader.BuiltinClassLoader".equals(classLoaderClass.getName());
    }

    public static void findClassLoaderOrder(ClassLoader classLoader, ClassLoaderOrder classLoaderOrder, LogNode log) {
        classLoaderOrder.delegateTo(classLoader.getParent(), true, log);
        classLoaderOrder.add(classLoader, log);
    }

    public static void findClasspathOrder(ClassLoader classLoader, ClasspathOrder classpathOrder, ScanSpec scanSpec, LogNode log) {
        Object ucpVal = ReflectionUtils.getFieldVal(false, (Object)classLoader, "ucp");
        if (ucpVal != null) {
            URL[] urls = (URL[])ReflectionUtils.invokeMethod(false, ucpVal, "getURLs");
            classpathOrder.addClasspathEntryObject(urls, classLoader, scanSpec, log);
        }
    }
}

