/*
 * Decompiled with CFR 0.152.
 */
package com.code_intelligence.jazzer.third_party.org.jacoco.core.analysis;

import com.code_intelligence.jazzer.third_party.org.jacoco.core.analysis.IBundleCoverage;
import com.code_intelligence.jazzer.third_party.org.jacoco.core.analysis.IClassCoverage;
import com.code_intelligence.jazzer.third_party.org.jacoco.core.analysis.ICoverageVisitor;
import com.code_intelligence.jazzer.third_party.org.jacoco.core.analysis.ISourceFileCoverage;
import com.code_intelligence.jazzer.third_party.org.jacoco.core.internal.analysis.BundleCoverageImpl;
import com.code_intelligence.jazzer.third_party.org.jacoco.core.internal.analysis.SourceFileCoverageImpl;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.Map;

public class CoverageBuilder
implements ICoverageVisitor {
    private final Map<String, IClassCoverage> classes = new HashMap<String, IClassCoverage>();
    private final Map<String, ISourceFileCoverage> sourcefiles = new HashMap<String, ISourceFileCoverage>();

    public Collection<IClassCoverage> getClasses() {
        return Collections.unmodifiableCollection(this.classes.values());
    }

    public Collection<ISourceFileCoverage> getSourceFiles() {
        return Collections.unmodifiableCollection(this.sourcefiles.values());
    }

    public IBundleCoverage getBundle(String name) {
        return new BundleCoverageImpl(name, this.classes.values(), this.sourcefiles.values());
    }

    public Collection<IClassCoverage> getNoMatchClasses() {
        ArrayList<IClassCoverage> result2 = new ArrayList<IClassCoverage>();
        for (IClassCoverage c : this.classes.values()) {
            if (!c.isNoMatch()) continue;
            result2.add(c);
        }
        return result2;
    }

    @Override
    public void visitCoverage(IClassCoverage coverage) {
        String name = coverage.getName();
        IClassCoverage dup = this.classes.put(name, coverage);
        if (dup != null) {
            if (dup.getId() != coverage.getId()) {
                throw new IllegalStateException("Can't add different class with same name: " + name);
            }
        } else {
            String source = coverage.getSourceFileName();
            if (source != null) {
                SourceFileCoverageImpl sourceFile = this.getSourceFile(source, coverage.getPackageName());
                sourceFile.increment(coverage);
            }
        }
    }

    private SourceFileCoverageImpl getSourceFile(String filename, String packagename) {
        String key = packagename + '/' + filename;
        SourceFileCoverageImpl sourcefile = (SourceFileCoverageImpl)this.sourcefiles.get(key);
        if (sourcefile == null) {
            sourcefile = new SourceFileCoverageImpl(filename, packagename);
            this.sourcefiles.put(key, sourcefile);
        }
        return sourcefile;
    }
}

