/*
 * Decompiled with CFR 0.152.
 */
package com.code_intelligence.jazzer.third_party.org.jacoco.core.internal.analysis.filter;

import com.code_intelligence.jazzer.third_party.org.jacoco.core.internal.analysis.filter.AbstractMatcher;
import com.code_intelligence.jazzer.third_party.org.jacoco.core.internal.analysis.filter.IFilter;
import com.code_intelligence.jazzer.third_party.org.jacoco.core.internal.analysis.filter.IFilterContext;
import com.code_intelligence.jazzer.third_party.org.jacoco.core.internal.analysis.filter.IFilterOutput;
import com.code_intelligence.jazzer.third_party.org.objectweb.asm.Handle;
import com.code_intelligence.jazzer.third_party.org.objectweb.asm.tree.InvokeDynamicInsnNode;
import com.code_intelligence.jazzer.third_party.org.objectweb.asm.tree.MethodNode;

public final class RecordsFilter
implements IFilter {
    @Override
    public void filter(MethodNode methodNode, IFilterContext context, IFilterOutput output) {
        if (!"java/lang/Record".equals(context.getSuperClassName())) {
            return;
        }
        Matcher matcher = new Matcher();
        if (matcher.isEquals(methodNode) || matcher.isHashCode(methodNode) || matcher.isToString(methodNode)) {
            output.ignore(methodNode.instructions.getFirst(), methodNode.instructions.getLast());
        }
    }

    private static class Matcher
    extends AbstractMatcher {
        private Matcher() {
        }

        boolean isToString(MethodNode m) {
            if (!"toString".equals(m.name) || !"()Ljava/lang/String;".equals(m.desc)) {
                return false;
            }
            this.firstIsALoad0(m);
            this.nextIsInvokeDynamic("toString");
            this.nextIs(176);
            return this.cursor != null;
        }

        boolean isHashCode(MethodNode m) {
            if (!"hashCode".equals(m.name) || !"()I".equals(m.desc)) {
                return false;
            }
            this.firstIsALoad0(m);
            this.nextIsInvokeDynamic("hashCode");
            this.nextIs(172);
            return this.cursor != null;
        }

        boolean isEquals(MethodNode m) {
            if (!"equals".equals(m.name) || !"(Ljava/lang/Object;)Z".equals(m.desc)) {
                return false;
            }
            this.firstIsALoad0(m);
            this.nextIs(25);
            this.nextIsInvokeDynamic("equals");
            this.nextIs(172);
            return this.cursor != null;
        }

        private void nextIsInvokeDynamic(String name) {
            this.nextIs(186);
            if (this.cursor == null) {
                return;
            }
            InvokeDynamicInsnNode i = (InvokeDynamicInsnNode)this.cursor;
            Handle bsm = i.bsm;
            if (name.equals(i.name) && "java/lang/runtime/ObjectMethods".equals(bsm.getOwner()) && "bootstrap".equals(bsm.getName())) {
                return;
            }
            this.cursor = null;
        }
    }
}

