/*
 * Decompiled with CFR 0.152.
 */
package com.code_intelligence.jazzer.agent;

import com.code_intelligence.jazzer.agent.AgentUtils;
import com.code_intelligence.jazzer.runtime.Constants;
import com.code_intelligence.jazzer.third_party.net.bytebuddy.agent.ByteBuddyAgent;
import java.lang.instrument.Instrumentation;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.util.concurrent.atomic.AtomicBoolean;

public class AgentInstaller {
    private static final AtomicBoolean hasBeenInstalled = new AtomicBoolean();

    public static void install(boolean enableAgent) {
        if (!hasBeenInstalled.compareAndSet(false, true)) {
            return;
        }
        if (Constants.IS_ANDROID) {
            return;
        }
        Instrumentation instrumentation = ByteBuddyAgent.install();
        instrumentation.appendToBootstrapClassLoaderSearch(AgentUtils.extractBootstrapJar());
        if (!enableAgent) {
            return;
        }
        try {
            Class<?> agent = Class.forName("com.code_intelligence.jazzer.agent.Agent");
            Method install = agent.getMethod("install", Instrumentation.class);
            install.invoke(null, instrumentation);
        }
        catch (ClassNotFoundException | IllegalAccessException | NoSuchMethodException | InvocationTargetException e) {
            throw new IllegalStateException("Failed to run Agent.install", e);
        }
    }
}

