/*
 * Decompiled with CFR 0.152.
 */
package com.code_intelligence.jazzer.driver;

import com.code_intelligence.jazzer.driver.LifecycleMethodsInvoker;
import com.code_intelligence.jazzer.driver.Opt;
import com.code_intelligence.jazzer.driver.ReflectionUtils;
import com.code_intelligence.jazzer.utils.Log;
import java.lang.reflect.InvocationTargetException;
import java.util.Optional;
import java.util.stream.Stream;

final class LibFuzzerLifecycleMethodsInvoker
implements LifecycleMethodsInvoker {
    private static final String FUZZER_INITIALIZE = "fuzzerInitialize";
    private static final String FUZZER_TEAR_DOWN = "fuzzerTearDown";
    private final Optional<LifecycleMethodsInvoker.ThrowingRunnable> fuzzerInitialize;
    private final Optional<LifecycleMethodsInvoker.ThrowingRunnable> fuzzerTearDown;

    private LibFuzzerLifecycleMethodsInvoker(Optional<LifecycleMethodsInvoker.ThrowingRunnable> fuzzerInitialize, Optional<LifecycleMethodsInvoker.ThrowingRunnable> fuzzerTearDown) {
        this.fuzzerInitialize = fuzzerInitialize;
        this.fuzzerTearDown = fuzzerTearDown;
    }

    static LifecycleMethodsInvoker of(Class<?> clazz) {
        Optional<LifecycleMethodsInvoker.ThrowingRunnable> fuzzerInitialize = Stream.of(ReflectionUtils.targetPublicStaticMethod(clazz, FUZZER_INITIALIZE, String[].class).map(init -> () -> init.invoke(null, new Object[]{Opt.targetArgs.get().toArray(new String[0])})), ReflectionUtils.targetPublicStaticMethod(clazz, FUZZER_INITIALIZE, new Class[0]).map(init -> () -> init.invoke(null, new Object[0]))).filter(Optional::isPresent).map(Optional::get).findFirst();
        Optional<LifecycleMethodsInvoker.ThrowingRunnable> fuzzerTearDown = ReflectionUtils.targetPublicStaticMethod(clazz, FUZZER_TEAR_DOWN, new Class[0]).map(tearDown -> () -> tearDown.invoke(null, new Object[0]));
        return new LibFuzzerLifecycleMethodsInvoker(fuzzerInitialize, fuzzerTearDown);
    }

    @Override
    public void beforeFirstExecution() throws Throwable {
        if (this.fuzzerInitialize.isPresent()) {
            try {
                this.fuzzerInitialize.get().run();
            }
            catch (InvocationTargetException e) {
                throw e.getCause();
            }
        }
    }

    @Override
    public void beforeEachExecution() {
    }

    @Override
    public void afterEachExecution() {
    }

    @Override
    public void afterLastExecution() throws Throwable {
        if (this.fuzzerTearDown.isPresent()) {
            Log.info("calling fuzzerTearDown function");
            try {
                this.fuzzerTearDown.get().run();
            }
            catch (InvocationTargetException e) {
                throw e.getCause();
            }
        }
    }

    @Override
    public Object getTestClassInstance() {
        return null;
    }
}

