/*
 * Decompiled with CFR 0.152.
 */
package com.code_intelligence.jazzer.mutation.engine;

import com.code_intelligence.jazzer.mutation.api.PseudoRandom;
import com.code_intelligence.jazzer.mutation.support.Preconditions;
import com.code_intelligence.jazzer.mutation.support.RandomSupport;
import java.util.List;
import java.util.SplittableRandom;
import java.util.function.Supplier;

public final class SeededPseudoRandom
implements PseudoRandom {
    private final SplittableRandom random;

    public SeededPseudoRandom(long seed) {
        this.random = new SplittableRandom(seed);
    }

    @Override
    public boolean choice() {
        return this.random.nextBoolean();
    }

    @Override
    public boolean trueInOneOutOf(int inverseFrequencyTrue) {
        Preconditions.require(inverseFrequencyTrue >= 2);
        return this.indexIn(inverseFrequencyTrue) == 0;
    }

    @Override
    public <T> T pickIn(T[] array) {
        return array[this.indexIn(array.length)];
    }

    @Override
    public <T> T pickIn(List<T> list) {
        return list.get(this.indexIn(list.size()));
    }

    @Override
    public <T> int indexIn(T[] array) {
        return this.indexIn(array.length);
    }

    @Override
    public <T> int indexIn(List<T> list) {
        return this.indexIn(list.size());
    }

    @Override
    public int indexIn(int range) {
        Preconditions.require(range >= 1);
        return this.random.nextInt(range);
    }

    @Override
    public <T> int otherIndexIn(T[] array, int currentIndex) {
        return this.otherIndexIn(array.length, currentIndex);
    }

    @Override
    public int otherIndexIn(int range, int currentIndex) {
        int otherIndex = currentIndex + this.closedRange(1, range - 1);
        if (otherIndex < range) {
            return otherIndex;
        }
        return otherIndex - range;
    }

    @Override
    public int closedRange(int lowerInclusive, int upperInclusive) {
        int r;
        Preconditions.require(lowerInclusive <= upperInclusive);
        int range = upperInclusive - lowerInclusive + 1;
        if (range > 0) {
            return lowerInclusive + this.random.nextInt(range);
        }
        while ((r = this.random.nextInt()) < lowerInclusive) {
        }
        return r;
    }

    @Override
    public long closedRange(long lowerInclusive, long upperInclusive) {
        long r;
        Preconditions.require(lowerInclusive <= upperInclusive);
        if (upperInclusive < Long.MAX_VALUE) {
            return this.random.nextLong(lowerInclusive, upperInclusive + 1L);
        }
        if (lowerInclusive > 0L) {
            return lowerInclusive + this.random.nextLong(upperInclusive + 1L - lowerInclusive);
        }
        while ((r = this.random.nextLong()) < lowerInclusive) {
        }
        return r;
    }

    @Override
    public float closedRange(float lowerInclusive, float upperInclusive) {
        Preconditions.require(lowerInclusive <= upperInclusive);
        if (lowerInclusive == upperInclusive) {
            Preconditions.require(Double.isFinite(lowerInclusive));
            return lowerInclusive;
        }
        if (lowerInclusive == Float.NEGATIVE_INFINITY && upperInclusive == -3.4028235E38f) {
            return -3.4028235E38f;
        }
        if (lowerInclusive == Float.MAX_VALUE && upperInclusive == Float.POSITIVE_INFINITY) {
            return Float.MAX_VALUE;
        }
        float limitedLower = lowerInclusive == Float.NEGATIVE_INFINITY ? -3.4028235E38f : lowerInclusive;
        float limitedUpper = upperInclusive == Float.POSITIVE_INFINITY ? Float.MAX_VALUE : upperInclusive;
        return (float)this.random.nextDouble(limitedLower, Math.nextUp((double)limitedUpper));
    }

    @Override
    public double closedRange(double lowerInclusive, double upperInclusive) {
        boolean couldExtendRange;
        double limitedUpper;
        Preconditions.require(lowerInclusive <= upperInclusive);
        if (lowerInclusive == upperInclusive) {
            Preconditions.require(Double.isFinite(lowerInclusive));
            return lowerInclusive;
        }
        if (lowerInclusive == Double.NEGATIVE_INFINITY && upperInclusive == -1.7976931348623157E308) {
            return -1.7976931348623157E308;
        }
        if (lowerInclusive == Double.MAX_VALUE && upperInclusive == Double.POSITIVE_INFINITY) {
            return Double.MAX_VALUE;
        }
        double limitedLower = lowerInclusive == Double.NEGATIVE_INFINITY ? -1.7976931348623157E308 : lowerInclusive;
        double d = limitedUpper = upperInclusive == Double.POSITIVE_INFINITY ? Double.MAX_VALUE : upperInclusive;
        if (limitedLower == limitedUpper) {
            return limitedLower;
        }
        double nextUpper = limitedUpper == Double.MAX_VALUE ? limitedUpper : Math.nextUp(limitedUpper);
        boolean bl = couldExtendRange = nextUpper != limitedUpper;
        if (Double.isFinite(nextUpper - limitedLower) && couldExtendRange) {
            double result = this.random.nextDouble(limitedLower, nextUpper);
            if (result > limitedUpper) {
                result = limitedUpper;
            }
            return result;
        }
        double n = this.random.nextDouble(0.0, Math.nextUp(1.0));
        return limitedLower * (1.0 - n) + limitedUpper * n;
    }

    @Override
    public void bytes(byte[] bytes) {
        RandomSupport.nextBytes(this.random, bytes);
    }

    private int closedRangeBiasedTowardsSmall(int upperInclusive) {
        double r;
        double h;
        double v;
        double u;
        double x;
        double k;
        if (upperInclusive == 0) {
            return 0;
        }
        Preconditions.require(upperInclusive > 0);
        double kd = upperInclusive;
        double hxm = SeededPseudoRandom.zipf_h(kd + 0.5);
        double h0x5 = -0.6666666666666666;
        double elogv_q = 1.0;
        double hx0_minus_hxm = -1.6666666666666665 - hxm;
        double s = 0.46153846153846123;
        while ((k = Math.floor((x = SeededPseudoRandom.zipf_hinv(u = hxm + (v = this.random.nextDouble()) * hx0_minus_hxm)) + 0.5)) > kd || !(k - x <= 0.46153846153846123) && !(u >= (h = SeededPseudoRandom.zipf_h(k + 0.5)) - (r = SeededPseudoRandom.zipf_pow_negative_q(1.0 + k)))) {
        }
        return (int)k;
    }

    @Override
    public int sizeInClosedRange(int lowerInclusive, int upperInclusive, boolean elementsHaveFixedSize) {
        if (elementsHaveFixedSize) {
            return this.closedRange(lowerInclusive, upperInclusive);
        }
        return lowerInclusive + this.closedRangeBiasedTowardsSmall(upperInclusive - lowerInclusive);
    }

    private static double zipf_h(double x) {
        return -1.0 / (x + 1.0);
    }

    private static double zipf_hinv(double x) {
        return -1.0 + -1.0 / x;
    }

    private static double zipf_pow_negative_q(double x) {
        return 1.0 / (x * x);
    }

    @Override
    public <T> T pickValue(T value, T otherValue, Supplier<T> supplier, int inverseSupplierFrequency) {
        if (this.trueInOneOutOf(inverseSupplierFrequency)) {
            return supplier.get();
        }
        if (this.choice()) {
            return value;
        }
        return otherValue;
    }

    @Override
    public long nextLong() {
        return this.random.nextLong();
    }
}

