/*
 * Decompiled with CFR 0.152.
 */
package com.code_intelligence.jazzer.mutation.support;

import java.util.AbstractMap;
import java.util.List;
import java.util.NoSuchElementException;
import java.util.Optional;
import java.util.function.IntFunction;
import java.util.stream.Collectors;
import java.util.stream.Stream;

public final class StreamSupport {
    private StreamSupport() {
    }

    public static boolean[] toBooleanArray(Stream<Boolean> stream) {
        List list = stream.collect(Collectors.toList());
        boolean[] array = new boolean[list.size()];
        for (int i = 0; i < list.size(); ++i) {
            array[i] = (Boolean)list.get(i);
        }
        return array;
    }

    public static <T> Optional<T> findFirstPresent(Stream<Optional<T>> stream) {
        return stream.filter(Optional::isPresent).map(Optional::get).findFirst();
    }

    public static <T> Optional<T[]> toArrayOrEmpty(Stream<Optional<T>> stream, IntFunction<T[]> newArray) {
        try {
            return Optional.of(stream.map(Optional::get).toArray(newArray));
        }
        catch (NoSuchElementException e) {
            return Optional.empty();
        }
    }

    public static <T> Stream<T> getOrEmpty(Optional<T> optional) {
        return optional.isPresent() ? Stream.of(optional.get()) : Stream.empty();
    }

    public static <K, V> AbstractMap.SimpleEntry<K, V> entry(K key, V value) {
        return new AbstractMap.SimpleEntry<K, V>(key, value);
    }
}

