/*
 * Decompiled with CFR 0.152.
 */
package com.code_intelligence.jazzer.third_party.org.jacoco.core.internal;

import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.FilterInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.lang.reflect.InvocationTargetException;
import java.util.jar.JarInputStream;
import java.util.jar.JarOutputStream;

public final class Pack200Streams {
    public static InputStream unpack(InputStream input) throws IOException {
        ByteArrayOutputStream buffer = new ByteArrayOutputStream();
        JarOutputStream jar = new JarOutputStream(buffer);
        try {
            Object unpacker = Class.forName("java.util.jar.Pack200").getMethod("newUnpacker", new Class[0]).invoke(null, new Object[0]);
            Class.forName("java.util.jar.Pack200$Unpacker").getMethod("unpack", InputStream.class, JarOutputStream.class).invoke(unpacker, new NoCloseInput(input), jar);
        }
        catch (ClassNotFoundException e) {
            throw Pack200Streams.newIOException(e);
        }
        catch (NoSuchMethodException e) {
            throw Pack200Streams.newIOException(e);
        }
        catch (IllegalAccessException e) {
            throw Pack200Streams.newIOException(e);
        }
        catch (InvocationTargetException e) {
            throw Pack200Streams.newIOException(e.getCause());
        }
        jar.finish();
        return new ByteArrayInputStream(buffer.toByteArray());
    }

    public static void pack(byte[] source, OutputStream output) throws IOException {
        JarInputStream jar = new JarInputStream(new ByteArrayInputStream(source));
        try {
            Object packer = Class.forName("java.util.jar.Pack200").getMethod("newPacker", new Class[0]).invoke(null, new Object[0]);
            Class.forName("java.util.jar.Pack200$Packer").getMethod("pack", JarInputStream.class, OutputStream.class).invoke(packer, jar, output);
        }
        catch (ClassNotFoundException e) {
            throw Pack200Streams.newIOException(e);
        }
        catch (NoSuchMethodException e) {
            throw Pack200Streams.newIOException(e);
        }
        catch (IllegalAccessException e) {
            throw Pack200Streams.newIOException(e);
        }
        catch (InvocationTargetException e) {
            throw Pack200Streams.newIOException(e.getCause());
        }
    }

    private static IOException newIOException(Throwable cause) {
        IOException exception = new IOException();
        exception.initCause(cause);
        return exception;
    }

    private Pack200Streams() {
    }

    private static class NoCloseInput
    extends FilterInputStream {
        protected NoCloseInput(InputStream in) {
            super(in);
        }

        @Override
        public void close() throws IOException {
        }
    }
}

