/*
 * Decompiled with CFR 0.152.
 */
package com.code_intelligence.jazzer.third_party.org.jacoco.core.internal.analysis.filter;

import com.code_intelligence.jazzer.third_party.org.jacoco.core.internal.analysis.filter.AbstractMatcher;
import com.code_intelligence.jazzer.third_party.org.jacoco.core.internal.analysis.filter.IFilter;
import com.code_intelligence.jazzer.third_party.org.jacoco.core.internal.analysis.filter.IFilterContext;
import com.code_intelligence.jazzer.third_party.org.jacoco.core.internal.analysis.filter.IFilterOutput;
import com.code_intelligence.jazzer.third_party.org.objectweb.asm.tree.AbstractInsnNode;
import com.code_intelligence.jazzer.third_party.org.objectweb.asm.tree.JumpInsnNode;
import com.code_intelligence.jazzer.third_party.org.objectweb.asm.tree.LabelNode;
import com.code_intelligence.jazzer.third_party.org.objectweb.asm.tree.LookupSwitchInsnNode;
import com.code_intelligence.jazzer.third_party.org.objectweb.asm.tree.MethodNode;
import com.code_intelligence.jazzer.third_party.org.objectweb.asm.tree.TableSwitchInsnNode;
import java.util.HashSet;
import java.util.List;

public final class KotlinWhenFilter
implements IFilter {
    private static final String EXCEPTION = "com/code_intelligence/jazzer/third_party/kotlin/NoWhenBranchMatchedException";

    @Override
    public void filter(MethodNode methodNode, IFilterContext context, IFilterOutput output) {
        Matcher matcher = new Matcher();
        for (AbstractInsnNode i : methodNode.instructions) {
            matcher.match(i, output);
        }
    }

    private static LabelNode getDefaultLabel(AbstractInsnNode i) {
        switch (i.getOpcode()) {
            case 171: {
                return ((LookupSwitchInsnNode)i).dflt;
            }
            case 170: {
                return ((TableSwitchInsnNode)i).dflt;
            }
        }
        return null;
    }

    private static void ignoreDefaultBranch(AbstractInsnNode switchNode, IFilterOutput output) {
        List<LabelNode> labels = switchNode.getOpcode() == 171 ? ((LookupSwitchInsnNode)switchNode).labels : ((TableSwitchInsnNode)switchNode).labels;
        HashSet<AbstractInsnNode> newTargets = new HashSet<AbstractInsnNode>();
        for (LabelNode label : labels) {
            newTargets.add(AbstractMatcher.skipNonOpcodes(label));
        }
        output.replaceBranches(switchNode, newTargets);
    }

    private static class Matcher
    extends AbstractMatcher {
        private Matcher() {
        }

        void match(AbstractInsnNode start, IFilterOutput output) {
            if (start.getType() != 8) {
                return;
            }
            this.cursor = start;
            this.nextIsType(187, KotlinWhenFilter.EXCEPTION);
            this.nextIs(89);
            this.nextIsInvoke(183, KotlinWhenFilter.EXCEPTION, "<init>", "()V");
            this.nextIs(191);
            for (AbstractInsnNode i = this.cursor; i != null; i = i.getPrevious()) {
                if (i.getOpcode() == 153 && ((JumpInsnNode)i).label == start) {
                    output.ignore(i, i);
                    output.ignore(start, this.cursor);
                    return;
                }
                if (KotlinWhenFilter.getDefaultLabel(i) != start) continue;
                KotlinWhenFilter.ignoreDefaultBranch(i, output);
                output.ignore(start, this.cursor);
                return;
            }
        }
    }
}

