/*
 * Decompiled with CFR 0.152.
 */
package com.code_intelligence.jazzer.autofuzz;

import com.code_intelligence.jazzer.api.AutofuzzConstructionException;
import com.code_intelligence.jazzer.api.AutofuzzInvocationException;
import com.code_intelligence.jazzer.api.Consumer1;
import com.code_intelligence.jazzer.api.Consumer2;
import com.code_intelligence.jazzer.api.Consumer3;
import com.code_intelligence.jazzer.api.Consumer4;
import com.code_intelligence.jazzer.api.Consumer5;
import com.code_intelligence.jazzer.api.Function1;
import com.code_intelligence.jazzer.api.Function2;
import com.code_intelligence.jazzer.api.Function3;
import com.code_intelligence.jazzer.api.Function4;
import com.code_intelligence.jazzer.api.Function5;
import com.code_intelligence.jazzer.api.FuzzedDataProvider;
import com.code_intelligence.jazzer.autofuzz.AccessibleObjectLookup;
import com.code_intelligence.jazzer.autofuzz.AutofuzzCodegenVisitor;
import com.code_intelligence.jazzer.autofuzz.AutofuzzError;
import com.code_intelligence.jazzer.autofuzz.YourAverageJavaClass;
import com.code_intelligence.jazzer.runtime.HardToCatchError;
import com.code_intelligence.jazzer.third_party.io.github.classgraph.ClassGraph;
import com.code_intelligence.jazzer.third_party.io.github.classgraph.ClassInfoList;
import com.code_intelligence.jazzer.third_party.io.github.classgraph.ScanResult;
import com.code_intelligence.jazzer.third_party.net.jodah.typetools.TypeResolver;
import com.code_intelligence.jazzer.utils.Utils;
import java.io.ByteArrayInputStream;
import java.io.InputStream;
import java.lang.reflect.Array;
import java.lang.reflect.Constructor;
import java.lang.reflect.Executable;
import java.lang.reflect.GenericArrayType;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.lang.reflect.Modifier;
import java.lang.reflect.ParameterizedType;
import java.lang.reflect.Type;
import java.lang.reflect.TypeVariable;
import java.lang.reflect.WildcardType;
import java.util.Arrays;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.WeakHashMap;
import java.util.stream.Collectors;
import java.util.stream.IntStream;

public class Meta {
    public static final boolean IS_DEBUG = Meta.isDebug();
    private static final Meta PUBLIC_LOOKUP_INSTANCE = new Meta(null);
    private static final boolean IS_TEST = Meta.isTest();
    private static final WeakHashMap<Class<?>, List<Class<?>>> implementingClassesCache = new WeakHashMap();
    private static final WeakHashMap<Class<?>, List<Class<?>>> nestedBuilderClassesCache = new WeakHashMap();
    private static final WeakHashMap<Class<?>, List<Method>> originalObjectCreationMethodsCache = new WeakHashMap();
    private static final WeakHashMap<Class<?>, List<Method>> cascadingBuilderMethodsCache = new WeakHashMap();
    private final AccessibleObjectLookup lookup;

    public Meta(Class<?> referenceClass) {
        this.lookup = new AccessibleObjectLookup(referenceClass);
    }

    public static <T1> void autofuzz(FuzzedDataProvider data, Consumer1<T1> func) {
        Class<?>[] types = TypeResolver.resolveRawArguments(Consumer1.class, func.getClass());
        func.accept(PUBLIC_LOOKUP_INSTANCE.consumeChecked(data, types, 0));
    }

    public static <T1, T2> void autofuzz(FuzzedDataProvider data, Consumer2<T1, T2> func) {
        Class<?>[] types = TypeResolver.resolveRawArguments(Consumer2.class, func.getClass());
        func.accept(PUBLIC_LOOKUP_INSTANCE.consumeChecked(data, types, 0), PUBLIC_LOOKUP_INSTANCE.consumeChecked(data, types, 1));
    }

    public static <T1, T2, T3> void autofuzz(FuzzedDataProvider data, Consumer3<T1, T2, T3> func) {
        Class<?>[] types = TypeResolver.resolveRawArguments(Consumer3.class, func.getClass());
        func.accept(PUBLIC_LOOKUP_INSTANCE.consumeChecked(data, types, 0), PUBLIC_LOOKUP_INSTANCE.consumeChecked(data, types, 1), PUBLIC_LOOKUP_INSTANCE.consumeChecked(data, types, 2));
    }

    public static <T1, T2, T3, T4> void autofuzz(FuzzedDataProvider data, Consumer4<T1, T2, T3, T4> func) {
        Class<?>[] types = TypeResolver.resolveRawArguments(Consumer4.class, func.getClass());
        func.accept(PUBLIC_LOOKUP_INSTANCE.consumeChecked(data, types, 0), PUBLIC_LOOKUP_INSTANCE.consumeChecked(data, types, 1), PUBLIC_LOOKUP_INSTANCE.consumeChecked(data, types, 2), PUBLIC_LOOKUP_INSTANCE.consumeChecked(data, types, 3));
    }

    public static <T1, T2, T3, T4, T5> void autofuzz(FuzzedDataProvider data, Consumer5<T1, T2, T3, T4, T5> func) {
        Class<?>[] types = TypeResolver.resolveRawArguments(Consumer5.class, func.getClass());
        func.accept(PUBLIC_LOOKUP_INSTANCE.consumeChecked(data, types, 0), PUBLIC_LOOKUP_INSTANCE.consumeChecked(data, types, 1), PUBLIC_LOOKUP_INSTANCE.consumeChecked(data, types, 2), PUBLIC_LOOKUP_INSTANCE.consumeChecked(data, types, 3), PUBLIC_LOOKUP_INSTANCE.consumeChecked(data, types, 4));
    }

    public static <T1, R> R autofuzz(FuzzedDataProvider data, Function1<T1, R> func) {
        Class<?>[] types = TypeResolver.resolveRawArguments(Function1.class, func.getClass());
        return (R)func.apply(PUBLIC_LOOKUP_INSTANCE.consumeChecked(data, types, 0));
    }

    public static <T1, T2, R> R autofuzz(FuzzedDataProvider data, Function2<T1, T2, R> func) {
        Class<?>[] types = TypeResolver.resolveRawArguments(Function2.class, func.getClass());
        return (R)func.apply(PUBLIC_LOOKUP_INSTANCE.consumeChecked(data, types, 0), PUBLIC_LOOKUP_INSTANCE.consumeChecked(data, types, 1));
    }

    public static <T1, T2, T3, R> R autofuzz(FuzzedDataProvider data, Function3<T1, T2, T3, R> func) {
        Class<?>[] types = TypeResolver.resolveRawArguments(Function3.class, func.getClass());
        return (R)func.apply(PUBLIC_LOOKUP_INSTANCE.consumeChecked(data, types, 0), PUBLIC_LOOKUP_INSTANCE.consumeChecked(data, types, 1), PUBLIC_LOOKUP_INSTANCE.consumeChecked(data, types, 2));
    }

    public static <T1, T2, T3, T4, R> R autofuzz(FuzzedDataProvider data, Function4<T1, T2, T3, T4, R> func) {
        Class<?>[] types = TypeResolver.resolveRawArguments(Function4.class, func.getClass());
        return (R)func.apply(PUBLIC_LOOKUP_INSTANCE.consumeChecked(data, types, 0), PUBLIC_LOOKUP_INSTANCE.consumeChecked(data, types, 1), PUBLIC_LOOKUP_INSTANCE.consumeChecked(data, types, 2), PUBLIC_LOOKUP_INSTANCE.consumeChecked(data, types, 3));
    }

    public static <T1, T2, T3, T4, T5, R> R autofuzz(FuzzedDataProvider data, Function5<T1, T2, T3, T4, T5, R> func) {
        Class<?>[] types = TypeResolver.resolveRawArguments(Function5.class, func.getClass());
        return (R)func.apply(PUBLIC_LOOKUP_INSTANCE.consumeChecked(data, types, 0), PUBLIC_LOOKUP_INSTANCE.consumeChecked(data, types, 1), PUBLIC_LOOKUP_INSTANCE.consumeChecked(data, types, 2), PUBLIC_LOOKUP_INSTANCE.consumeChecked(data, types, 3), PUBLIC_LOOKUP_INSTANCE.consumeChecked(data, types, 4));
    }

    public static Object consume(FuzzedDataProvider data, Class<?> type) {
        return PUBLIC_LOOKUP_INSTANCE.consume(data, type, null);
    }

    static void rescanClasspath() {
        implementingClassesCache.clear();
    }

    private static boolean isTest() {
        String value = System.getenv("JAZZER_AUTOFUZZ_TESTING");
        return value != null && !value.isEmpty();
    }

    private static boolean isDebug() {
        String value = System.getenv("JAZZER_AUTOFUZZ_DEBUG");
        return value != null && !value.isEmpty();
    }

    private static int consumeArrayLength(FuzzedDataProvider data, int sizeOfElement) {
        int bytesToSpend = data.remainingBytes() / 2;
        return bytesToSpend / Math.max(sizeOfElement, 1);
    }

    private static String deepToString(Object obj) {
        if (obj == null) {
            return "null";
        }
        if (obj.getClass().isArray()) {
            return String.format("(%s[]) %s", obj.getClass().getComponentType().getName(), Arrays.deepToString((Object[])obj));
        }
        return obj.toString();
    }

    private static String getDebugSummary(Executable executable, Object thisObject, Object[] arguments) {
        return String.format("%nMethod: %s::%s%s%nthis: %s%nArguments: %s", executable.getDeclaringClass().getName(), executable.getName(), Utils.getReadableDescriptor(executable), thisObject, Arrays.stream(arguments).map(Meta::deepToString).collect(Collectors.joining(", ")));
    }

    static Class<?> getRawType(Type genericType) {
        if (genericType instanceof Class) {
            return (Class)genericType;
        }
        if (genericType instanceof ParameterizedType) {
            return Meta.getRawType(((ParameterizedType)genericType).getRawType());
        }
        if (genericType instanceof WildcardType) {
            return Object.class;
        }
        if (genericType instanceof TypeVariable) {
            throw new AutofuzzError("Did not expect genericType to be a TypeVariable: " + genericType);
        }
        if (genericType instanceof GenericArrayType) {
            return Array.newInstance(Meta.getRawType(((GenericArrayType)genericType).getGenericComponentType()), 0).getClass();
        }
        throw new AutofuzzError("Got unexpected class implementing Type: " + genericType);
    }

    public Object autofuzz(FuzzedDataProvider data, Method method) {
        return this.autofuzz(data, method, null);
    }

    public Object consumeNonStatic(FuzzedDataProvider data, Class<?> type) {
        return this.consume(data, type, null);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    Object autofuzz(FuzzedDataProvider data, Method method, AutofuzzCodegenVisitor visitor) {
        Object result;
        if (Modifier.isStatic(method.getModifiers())) {
            if (visitor != null) {
                visitor.pushGroup(String.format("%s.", method.getDeclaringClass().getCanonicalName()), "", "");
            }
            try {
                result = this.autofuzz(data, method, null, visitor);
            }
            finally {
                if (visitor != null) {
                    visitor.popGroup();
                }
            }
        }
        if (visitor != null) {
            visitor.pushGroup("(", ").", "");
        }
        try {
            Object thisObject = this.consume(data, method.getDeclaringClass(), visitor);
            if (thisObject == null) {
                throw new AutofuzzConstructionException();
            }
            result = this.autofuzz(data, method, thisObject, visitor);
        }
        finally {
            if (visitor != null) {
                visitor.popGroup();
            }
        }
        return result;
    }

    public Object autofuzz(FuzzedDataProvider data, Method method, Object thisObject) {
        return this.autofuzz(data, method, thisObject, null);
    }

    Object autofuzz(FuzzedDataProvider data, Method method, Object thisObject, AutofuzzCodegenVisitor visitor) {
        if (visitor != null) {
            visitor.pushGroup(String.format("%s(", method.getName()), ", ", ")");
        }
        Object[] arguments = this.consumeArguments(data, method, visitor);
        if (visitor != null) {
            visitor.popGroup();
        }
        try {
            return method.invoke(thisObject, arguments);
        }
        catch (IllegalAccessException | IllegalArgumentException | NullPointerException e) {
            throw new AutofuzzError(Meta.getDebugSummary(method, thisObject, arguments), e);
        }
        catch (InvocationTargetException e) {
            if (e.getCause() instanceof HardToCatchError) {
                throw new AutofuzzInvocationException();
            }
            throw new AutofuzzInvocationException(e.getCause());
        }
    }

    Object autofuzzForConsume(FuzzedDataProvider data, Constructor<?> constructor, AutofuzzCodegenVisitor visitor) {
        try {
            return this.autofuzz(data, constructor, visitor);
        }
        catch (AutofuzzConstructionException e) {
            throw e;
        }
        catch (AutofuzzInvocationException e) {
            throw new AutofuzzConstructionException(e.getCause());
        }
        catch (Throwable t) {
            throw new AutofuzzConstructionException(t);
        }
    }

    Object autofuzzForConsume(FuzzedDataProvider data, Method method, Object thisObject, AutofuzzCodegenVisitor visitor) {
        try {
            return this.autofuzz(data, method, thisObject, visitor);
        }
        catch (AutofuzzConstructionException e) {
            throw e;
        }
        catch (AutofuzzInvocationException e) {
            throw new AutofuzzConstructionException(e.getCause());
        }
        catch (Throwable t) {
            throw new AutofuzzConstructionException(t);
        }
    }

    public <R> R autofuzz(FuzzedDataProvider data, Constructor<R> constructor) {
        return this.autofuzz(data, constructor, null);
    }

    <R> R autofuzz(FuzzedDataProvider data, Constructor<R> constructor, AutofuzzCodegenVisitor visitor) {
        if (visitor != null) {
            visitor.pushGroup(String.format("new %s(", constructor.getDeclaringClass().getCanonicalName()), ", ", ")");
        }
        Object[] arguments = this.consumeArguments(data, constructor, visitor);
        if (visitor != null) {
            visitor.popGroup();
        }
        try {
            return constructor.newInstance(arguments);
        }
        catch (IllegalAccessException | IllegalArgumentException | InstantiationException e) {
            throw new AutofuzzError(Meta.getDebugSummary(constructor, null, arguments), e);
        }
        catch (InvocationTargetException e) {
            if (e.getCause() instanceof HardToCatchError) {
                throw new AutofuzzInvocationException();
            }
            throw new AutofuzzInvocationException(e.getCause());
        }
    }

    Object consume(FuzzedDataProvider data, Type genericType, AutofuzzCodegenVisitor visitor) {
        Class<?> type = Meta.getRawType(genericType);
        if (type == Byte.TYPE || type == Byte.class) {
            byte result = data.consumeByte();
            if (visitor != null) {
                visitor.pushElement(String.format("(byte) %s", result));
            }
            return result;
        }
        if (type == Short.TYPE || type == Short.class) {
            short result = data.consumeShort();
            if (visitor != null) {
                visitor.pushElement(String.format("(short) %s", result));
            }
            return result;
        }
        if (type == Integer.TYPE || type == Integer.class) {
            int result = data.consumeInt();
            if (visitor != null) {
                visitor.pushElement(Integer.toString(result));
            }
            return result;
        }
        if (type == Long.TYPE || type == Long.class) {
            long result = data.consumeLong();
            if (visitor != null) {
                visitor.pushElement(String.format("%sL", result));
            }
            return result;
        }
        if (type == Float.TYPE || type == Float.class) {
            float result = data.consumeFloat();
            if (visitor != null) {
                visitor.pushElement(String.format("%sF", Float.valueOf(result)));
            }
            return Float.valueOf(result);
        }
        if (type == Double.TYPE || type == Double.class) {
            double result = data.consumeDouble();
            if (visitor != null) {
                visitor.pushElement(Double.toString(result));
            }
            return result;
        }
        if (type == Boolean.TYPE || type == Boolean.class) {
            boolean result = data.consumeBoolean();
            if (visitor != null) {
                visitor.pushElement(Boolean.toString(result));
            }
            return result;
        }
        if (type == Character.TYPE || type == Character.class) {
            char result = data.consumeChar();
            if (visitor != null) {
                visitor.addCharLiteral(result);
            }
            return Character.valueOf(result);
        }
        if (!type.isPrimitive() && data.consumeByte() == 0) {
            if (visitor != null) {
                if (type == Object.class) {
                    visitor.pushElement("null");
                } else {
                    visitor.pushElement(String.format("(%s) null", type.getCanonicalName()));
                }
            }
            return null;
        }
        if (type == String.class || type == CharSequence.class) {
            String result = data.consumeString(Meta.consumeArrayLength(data, 1));
            if (visitor != null) {
                visitor.addStringLiteral(result);
            }
            return result;
        }
        if (type.isArray()) {
            if (type == byte[].class) {
                byte[] result = data.consumeBytes(Meta.consumeArrayLength(data, 1));
                if (visitor != null) {
                    visitor.pushElement(IntStream.range(0, result.length).mapToObj(i -> "(byte) " + result[i]).collect(Collectors.joining(", ", "new byte[]{", "}")));
                }
                return result;
            }
            if (type == int[].class) {
                int[] result = data.consumeInts(Meta.consumeArrayLength(data, 4));
                if (visitor != null) {
                    visitor.pushElement(Arrays.stream(result).mapToObj(String::valueOf).collect(Collectors.joining(", ", "new int[]{", "}")));
                }
                return result;
            }
            if (type == short[].class) {
                short[] result = data.consumeShorts(Meta.consumeArrayLength(data, 2));
                if (visitor != null) {
                    visitor.pushElement(IntStream.range(0, result.length).mapToObj(i -> "(short) " + result[i]).collect(Collectors.joining(", ", "new short[]{", "}")));
                }
                return result;
            }
            if (type == long[].class) {
                long[] result = data.consumeLongs(Meta.consumeArrayLength(data, 8));
                if (visitor != null) {
                    visitor.pushElement(Arrays.stream(result).mapToObj(e -> e + "L").collect(Collectors.joining(", ", "new long[]{", "}")));
                }
                return result;
            }
            if (type == boolean[].class) {
                boolean[] result = data.consumeBooleans(Meta.consumeArrayLength(data, 1));
                if (visitor != null) {
                    visitor.pushElement(Arrays.toString(result).replace(']', '}').replace("[", "new boolean[]{"));
                }
                return result;
            }
            if (visitor != null) {
                visitor.pushGroup(String.format("new %s[]{", type.getComponentType().getName()), ", ", "}");
            }
            int remainingBytesBeforeFirstElementCreation = data.remainingBytes();
            Object firstElement = this.consume(data, type.getComponentType(), visitor);
            int remainingBytesAfterFirstElementCreation = data.remainingBytes();
            int sizeOfElementEstimate = remainingBytesBeforeFirstElementCreation - remainingBytesAfterFirstElementCreation;
            Object array = Array.newInstance(type.getComponentType(), Meta.consumeArrayLength(data, sizeOfElementEstimate));
            for (int i2 = 0; i2 < Array.getLength(array); ++i2) {
                if (i2 == 0) {
                    Array.set(array, i2, firstElement);
                    continue;
                }
                Array.set(array, i2, this.consume(data, type.getComponentType(), visitor));
            }
            if (visitor != null) {
                if (Array.getLength(array) == 0) {
                    visitor.popElement();
                }
                visitor.popGroup();
            }
            return array;
        }
        if (type == ByteArrayInputStream.class || type == InputStream.class) {
            byte[] array = data.consumeBytes(Meta.consumeArrayLength(data, 1));
            if (visitor != null) {
                visitor.pushElement(IntStream.range(0, array.length).mapToObj(i -> "(byte) " + array[i]).collect(Collectors.joining(", ", "new java.io.ByteArrayInputStream(new byte[]{", "})")));
            }
            return new ByteArrayInputStream(array);
        }
        if (type == Map.class) {
            ParameterizedType mapType = (ParameterizedType)genericType;
            if (mapType.getActualTypeArguments().length != 2) {
                throw new AutofuzzError("Expected Map generic type to have two type parameters: " + mapType);
            }
            Type keyType = mapType.getActualTypeArguments()[0];
            Type valueType = mapType.getActualTypeArguments()[1];
            if (visitor != null) {
                visitor.pushGroup(String.format("java.util.stream.Stream.<java.util.AbstractMap.SimpleEntry<%s, %s>>of(", keyType.getTypeName(), valueType.getTypeName()), ", ", ").collect(java.util.HashMap::new, (map, e) -> map.put(e.getKey(), e.getValue()), java.util.HashMap::putAll)");
            }
            int remainingBytesBeforeFirstEntryCreation = data.remainingBytes();
            if (visitor != null) {
                visitor.pushGroup("new java.util.AbstractMap.SimpleEntry<>(", ", ", ")");
            }
            Object firstKey = this.consume(data, keyType, visitor);
            Object firstValue = this.consume(data, valueType, visitor);
            if (visitor != null) {
                visitor.popGroup();
            }
            int remainingBytesAfterFirstEntryCreation = data.remainingBytes();
            int sizeOfElementEstimate = remainingBytesBeforeFirstEntryCreation - remainingBytesAfterFirstEntryCreation;
            int mapSize = Meta.consumeArrayLength(data, sizeOfElementEstimate);
            HashMap<Object, Object> map = new HashMap<Object, Object>(mapSize);
            for (int i3 = 0; i3 < mapSize; ++i3) {
                if (i3 == 0) {
                    map.put(firstKey, firstValue);
                    continue;
                }
                if (visitor != null) {
                    visitor.pushGroup("new java.util.AbstractMap.SimpleEntry<>(", ", ", ")");
                }
                map.put(this.consume(data, keyType, visitor), this.consume(data, valueType, visitor));
                if (visitor == null) continue;
                visitor.popGroup();
            }
            if (visitor != null) {
                if (mapSize == 0) {
                    visitor.popElement();
                }
                visitor.popGroup();
            }
            return map;
        }
        if (type.isEnum()) {
            Enum enumValue = (Enum)data.pickValue((Object[])type.getEnumConstants());
            if (visitor != null) {
                visitor.pushElement(String.format("%s.%s", type.getName(), enumValue.name()));
            }
            return enumValue;
        }
        if (type == Class.class) {
            if (visitor != null) {
                visitor.pushElement(String.format("%s.class", YourAverageJavaClass.class.getName()));
            }
            return YourAverageJavaClass.class;
        }
        if (type == Method.class) {
            if (visitor != null) {
                throw new AutofuzzError("codegen has not been implemented for Method.class");
            }
            return data.pickValue((Object[])this.lookup.getAccessibleMethods(YourAverageJavaClass.class));
        }
        if (type == Constructor.class) {
            if (visitor != null) {
                throw new AutofuzzError("codegen has not been implemented for Constructor.class");
            }
            return data.pickValue((Object[])this.lookup.getAccessibleConstructors(YourAverageJavaClass.class));
        }
        if (type.isInterface() || Modifier.isAbstract(type.getModifiers())) {
            List<Class<?>> implementingClasses = implementingClassesCache.get(type);
            if (implementingClasses == null) {
                ClassGraph classGraph = new ClassGraph().enableClassInfo().ignoreClassVisibility().ignoreMethodVisibility().enableInterClassDependencies().rejectPackages("jaz");
                if (!IS_TEST) {
                    classGraph.rejectPackages("com.code_intelligence.jazzer");
                }
                try (ScanResult result = classGraph.scan();){
                    ClassInfoList children = type.isInterface() ? result.getClassesImplementing(type) : result.getSubclasses(type);
                    implementingClasses = children.getStandardClasses().filter(info -> !Modifier.isAbstract(info.getModifiers())).filter(info -> this.lookup.isAccessible(info, info.getModifiers())).filter(info -> info.getName() != null).loadClasses();
                    implementingClassesCache.put(type, implementingClasses);
                }
            }
            if (implementingClasses.isEmpty()) {
                if (IS_DEBUG) {
                    throw new AutofuzzConstructionException(String.format("Could not find classes implementing %s on the classpath", type.getName()));
                }
                throw new AutofuzzConstructionException();
            }
            if (visitor != null && Modifier.isPublic(type.getModifiers())) {
                visitor.pushGroup(String.format("(%s) ", type.getCanonicalName()), "", "");
            }
            Object result = this.consume(data, (Type)data.pickValue(implementingClasses), visitor);
            if (visitor != null && Modifier.isPublic(type.getModifiers())) {
                visitor.popGroup();
            }
            return result;
        }
        Object[] constructors = this.lookup.getAccessibleConstructors(type);
        if (constructors.length > 0) {
            boolean applySetters;
            Constructor constructor = (Constructor)data.pickValue(constructors);
            boolean bl = applySetters = constructor.getParameterCount() == 0;
            if (visitor != null && applySetters) {
                String uniqueVariableName = visitor.uniqueVariableName();
                visitor.pushGroup(String.format("((java.util.function.Supplier<%1$s>) (() -> {%1$s %2$s = ", type.getCanonicalName(), uniqueVariableName), String.format("; %s.", uniqueVariableName), String.format("; return %s;})).get()", uniqueVariableName));
            }
            Object obj = this.autofuzzForConsume(data, constructor, visitor);
            if (applySetters) {
                List<Method> potentialSetters = this.getPotentialSetters(type);
                if (!potentialSetters.isEmpty()) {
                    List pickedSetters = data.pickValues(potentialSetters, data.consumeInt(0, potentialSetters.size()));
                    for (Method setter : pickedSetters) {
                        this.autofuzzForConsume(data, setter, obj, visitor);
                    }
                }
                if (visitor != null) {
                    visitor.popGroup();
                }
            }
            return obj;
        }
        List<Class<?>> nestedBuilderClasses = this.getNestedBuilderClasses(type);
        if (!nestedBuilderClasses.isEmpty()) {
            Class pickedBuilder = (Class)data.pickValue(nestedBuilderClasses);
            List<Method> cascadingBuilderMethods = this.getCascadingBuilderMethods(pickedBuilder);
            List<Method> originalObjectCreationMethods = this.getOriginalObjectCreationMethods(pickedBuilder);
            int pickedMethodsNumber = data.consumeInt(0, cascadingBuilderMethods.size());
            List pickedMethods = data.pickValues(cascadingBuilderMethods, pickedMethodsNumber);
            Method builderMethod = (Method)data.pickValue(originalObjectCreationMethods);
            if (visitor != null) {
                visitor.pushGroup("", ".", "");
            }
            Object builderObj = this.autofuzzForConsume(data, (Constructor)data.pickValue((Object[])this.lookup.getAccessibleConstructors(pickedBuilder)), visitor);
            for (Method method : pickedMethods) {
                builderObj = this.autofuzzForConsume(data, method, builderObj, visitor);
            }
            try {
                Object obj = this.autofuzzForConsume(data, builderMethod, builderObj, visitor);
                if (visitor != null) {
                    visitor.popGroup();
                }
                return obj;
            }
            catch (Exception e2) {
                throw new AutofuzzConstructionException((Throwable)e2);
            }
        }
        if (IS_DEBUG) {
            String summary = String.format("Failed to generate instance of %s:%nAccessible constructors: %s%nNested subclasses: %s%n", type.getName(), Arrays.stream(this.lookup.getAccessibleConstructors(type)).map(Utils::getReadableDescriptor).collect(Collectors.joining(", ")), Arrays.stream(this.lookup.getAccessibleClasses(type)).map(Class::getName).collect(Collectors.joining(", ")));
            throw new AutofuzzConstructionException(summary);
        }
        throw new AutofuzzConstructionException();
    }

    private List<Class<?>> getNestedBuilderClasses(Class<?> type) {
        List<Class<Object>> nestedBuilderClasses = nestedBuilderClassesCache.get(type);
        if (nestedBuilderClasses == null) {
            nestedBuilderClasses = Arrays.stream(this.lookup.getAccessibleClasses(type)).filter(cls -> cls.getName().endsWith("Builder")).filter(cls -> !this.getOriginalObjectCreationMethods((Class<?>)cls).isEmpty()).collect(Collectors.toList());
            nestedBuilderClassesCache.put(type, nestedBuilderClasses);
        }
        return nestedBuilderClasses;
    }

    private List<Method> getOriginalObjectCreationMethods(Class<?> builder) {
        List<Method> originalObjectCreationMethods = originalObjectCreationMethodsCache.get(builder);
        if (originalObjectCreationMethods == null) {
            originalObjectCreationMethods = Arrays.stream(this.lookup.getAccessibleMethods(builder)).filter(m -> m.getReturnType() == builder.getEnclosingClass()).collect(Collectors.toList());
            originalObjectCreationMethodsCache.put(builder, originalObjectCreationMethods);
        }
        return originalObjectCreationMethods;
    }

    private List<Method> getCascadingBuilderMethods(Class<?> builder) {
        List<Method> cascadingBuilderMethods = cascadingBuilderMethodsCache.get(builder);
        if (cascadingBuilderMethods == null) {
            cascadingBuilderMethods = Arrays.stream(this.lookup.getAccessibleMethods(builder)).filter(m -> m.getReturnType() == builder).collect(Collectors.toList());
            cascadingBuilderMethodsCache.put(builder, cascadingBuilderMethods);
        }
        return cascadingBuilderMethods;
    }

    private List<Method> getPotentialSetters(Class<?> type) {
        return Arrays.stream(this.lookup.getAccessibleMethods(type)).filter(method -> Void.TYPE.equals(method.getReturnType())).filter(method -> method.getParameterCount() == 1).filter(method -> method.getName().startsWith("set")).collect(Collectors.toList());
    }

    public Object[] consumeArguments(FuzzedDataProvider data, Executable executable, AutofuzzCodegenVisitor visitor) {
        try {
            Object[] result = Arrays.stream(executable.getGenericParameterTypes()).map(type -> this.consume(data, (Type)type, visitor)).toArray();
            return result;
        }
        catch (AutofuzzConstructionException e) {
            throw e;
        }
        catch (AutofuzzInvocationException e) {
            throw new AutofuzzConstructionException(e.getCause());
        }
        catch (Throwable t) {
            throw new AutofuzzConstructionException(t);
        }
    }

    private Object consumeChecked(FuzzedDataProvider data, Class<?>[] types, int i) {
        Object result;
        if (types[i] == TypeResolver.Unknown.class) {
            throw new AutofuzzError("Failed to determine type of argument " + (i + 1));
        }
        try {
            result = this.consumeNonStatic(data, types[i]);
        }
        catch (AutofuzzConstructionException e) {
            throw e;
        }
        catch (AutofuzzInvocationException e) {
            throw new AutofuzzConstructionException(e.getCause());
        }
        catch (Throwable t) {
            throw new AutofuzzConstructionException(t);
        }
        if (result != null && !types[i].isAssignableFrom(result.getClass())) {
            throw new AutofuzzError("consume returned " + result.getClass() + ", but need " + types[i]);
        }
        return result;
    }
}

