/*
 * Decompiled with CFR 0.152.
 */
package com.code_intelligence.jazzer.driver;

import com.code_intelligence.jazzer.api.FuzzedDataProvider;
import com.code_intelligence.jazzer.third_party.com.github.fmeum.rules_jni.RulesJni;
import com.code_intelligence.jazzer.utils.UnsafeProvider;
import sun.misc.Unsafe;

public class FuzzedDataProviderImpl
implements FuzzedDataProvider,
AutoCloseable {
    private final byte[] javaData;
    private long originalDataPtr;
    private int originalRemainingBytes;
    private long dataPtr;
    private int remainingBytes;
    private static final Unsafe UNSAFE;
    private static final long BYTE_ARRAY_OFFSET;

    private static native void nativeInit();

    private FuzzedDataProviderImpl(long dataPtr, int remainingBytes, byte[] javaData) {
        this.javaData = javaData;
        this.originalDataPtr = dataPtr;
        this.dataPtr = dataPtr;
        this.originalRemainingBytes = remainingBytes;
        this.remainingBytes = remainingBytes;
    }

    public static FuzzedDataProviderImpl withJavaData(byte[] data) {
        return new FuzzedDataProviderImpl(FuzzedDataProviderImpl.allocateNativeCopy(data), data.length, data);
    }

    public static FuzzedDataProviderImpl withNativeData() {
        return new FuzzedDataProviderImpl(0L, 0, null);
    }

    public void setNativeData(long dataPtr, int dataLength) {
        this.originalDataPtr = dataPtr;
        this.dataPtr = dataPtr;
        this.originalRemainingBytes = dataLength;
        this.remainingBytes = dataLength;
    }

    public byte[] getJavaData() {
        return this.javaData;
    }

    public void reset() {
        this.dataPtr = this.originalDataPtr;
        this.remainingBytes = this.originalRemainingBytes;
    }

    @Override
    public void close() {
        if (this.originalDataPtr == 0L) {
            return;
        }
        if (this.javaData != null) {
            UNSAFE.freeMemory(this.originalDataPtr);
        }
        this.originalDataPtr = 0L;
        this.originalRemainingBytes = 0;
        this.dataPtr = 0L;
        this.remainingBytes = 0;
    }

    private static long allocateNativeCopy(byte[] data) {
        long nativeCopy = UNSAFE.allocateMemory(data.length);
        UNSAFE.copyMemory(data, BYTE_ARRAY_OFFSET, null, nativeCopy, data.length);
        return nativeCopy;
    }

    public native boolean consumeBoolean();

    public native boolean[] consumeBooleans(int var1);

    public native byte consumeByte();

    public byte consumeByte(byte min, byte max) {
        if (min > max) {
            throw new IllegalArgumentException(String.format("min must be <= max (got min: %d, max: %d)", min, max));
        }
        return this.consumeByteUnchecked(min, max);
    }

    public native short consumeShort();

    public short consumeShort(short min, short max) {
        if (min > max) {
            throw new IllegalArgumentException(String.format("min must be <= max (got min: %d, max: %d)", min, max));
        }
        return this.consumeShortUnchecked(min, max);
    }

    public native short[] consumeShorts(int var1);

    public native int consumeInt();

    public int consumeInt(int min, int max) {
        if (min > max) {
            throw new IllegalArgumentException(String.format("min must be <= max (got min: %d, max: %d)", min, max));
        }
        return this.consumeIntUnchecked(min, max);
    }

    public native int[] consumeInts(int var1);

    public native long consumeLong();

    public long consumeLong(long min, long max) {
        if (min > max) {
            throw new IllegalArgumentException(String.format("min must be <= max (got min: %d, max: %d)", min, max));
        }
        return this.consumeLongUnchecked(min, max);
    }

    public native long[] consumeLongs(int var1);

    public native float consumeFloat();

    public native float consumeRegularFloat();

    public float consumeRegularFloat(float min, float max) {
        if (!Float.isFinite(min)) {
            throw new IllegalArgumentException("min must be a regular float");
        }
        if (!Float.isFinite(max)) {
            throw new IllegalArgumentException("max must be a regular float");
        }
        if (min > max) {
            throw new IllegalArgumentException(String.format("min must be <= max (got min: %f, max: %f)", Float.valueOf(min), Float.valueOf(max)));
        }
        return this.consumeRegularFloatUnchecked(min, max);
    }

    public native float consumeProbabilityFloat();

    public native double consumeDouble();

    public double consumeRegularDouble(double min, double max) {
        if (!Double.isFinite(min)) {
            throw new IllegalArgumentException("min must be a regular double");
        }
        if (!Double.isFinite(max)) {
            throw new IllegalArgumentException("max must be a regular double");
        }
        if (min > max) {
            throw new IllegalArgumentException(String.format("min must be <= max (got min: %f, max: %f)", min, max));
        }
        return this.consumeRegularDoubleUnchecked(min, max);
    }

    public native double consumeRegularDouble();

    public native double consumeProbabilityDouble();

    public native char consumeChar();

    public char consumeChar(char min, char max) {
        if (min > max) {
            throw new IllegalArgumentException(String.format("min must be <= max (got min: %c, max: %c)", Character.valueOf(min), Character.valueOf(max)));
        }
        return this.consumeCharUnchecked(min, max);
    }

    public native char consumeCharNoSurrogates();

    public native String consumeAsciiString(int var1);

    public native String consumeString(int var1);

    public native String consumeRemainingAsAsciiString();

    public native String consumeRemainingAsString();

    public native byte[] consumeBytes(int var1);

    public native byte[] consumeRemainingAsBytes();

    public native int remainingBytes();

    private native byte consumeByteUnchecked(byte var1, byte var2);

    private native short consumeShortUnchecked(short var1, short var2);

    private native char consumeCharUnchecked(char var1, char var2);

    private native int consumeIntUnchecked(int var1, int var2);

    private native long consumeLongUnchecked(long var1, long var3);

    private native float consumeRegularFloatUnchecked(float var1, float var2);

    private native double consumeRegularDoubleUnchecked(double var1, double var3);

    static {
        RulesJni.loadLibrary("jazzer_fuzzed_data_provider", "/com/code_intelligence/jazzer/driver");
        FuzzedDataProviderImpl.nativeInit();
        UNSAFE = UnsafeProvider.getUnsafe();
        BYTE_ARRAY_OFFSET = UNSAFE.arrayBaseOffset(byte[].class);
    }
}

