/*
 * Decompiled with CFR 0.152.
 */
package com.code_intelligence.jazzer.driver;

import com.code_intelligence.jazzer.agent.AgentInstaller;
import com.code_intelligence.jazzer.driver.Opt;
import com.code_intelligence.jazzer.utils.Log;
import com.code_intelligence.jazzer.utils.ZipUtils;
import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.net.URL;
import java.net.URLClassLoader;
import java.util.ArrayList;
import java.util.Enumeration;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import java.util.jar.JarEntry;
import java.util.jar.JarFile;
import java.util.zip.ZipOutputStream;

public class OfflineInstrumentor {
    /*
     * WARNING - void declaration
     */
    public static boolean instrumentJars(List<String> jarLists) {
        AgentInstaller.install(Opt.hooks.get());
        File dumpClassesDir = new File(Opt.dumpClassesDir.get());
        if (dumpClassesDir.exists()) {
            void var4_6;
            String[] stringArray = dumpClassesDir.list();
            int n = stringArray.length;
            boolean bl = false;
            while (var4_6 < n) {
                String fn = stringArray[var4_6];
                new File(Opt.dumpClassesDir.get(), fn).delete();
                ++var4_6;
            }
        }
        List<Object> errorMessages = new ArrayList();
        for (String string : jarLists) {
            String outputBaseName = string;
            if (outputBaseName.contains(File.separator)) {
                outputBaseName = outputBaseName.substring(outputBaseName.lastIndexOf(File.separator) + 1, outputBaseName.length());
            }
            if (outputBaseName.contains(".jar")) {
                outputBaseName = outputBaseName.substring(0, outputBaseName.lastIndexOf(".jar"));
            }
            Log.info("Instrumenting jar file: " + string);
            try {
                errorMessages = OfflineInstrumentor.createInstrumentedClasses(string);
            }
            catch (IOException e) {
                errorMessages.add("Failed to instrument jar: " + string + ". Please ensure the file at this location is a jar file. Error Message: " + e);
                continue;
            }
            try {
                OfflineInstrumentor.createInstrumentedJar(string, Opt.dumpClassesDir.get() + File.separator + outputBaseName, outputBaseName + ".instrumented.jar");
            }
            catch (Exception e) {
                errorMessages.add("Failed to instrument jar: " + string + ". Error: " + e);
            }
        }
        for (String string : errorMessages) {
            Log.error(string);
        }
        return errorMessages.isEmpty();
    }

    private static List<String> createInstrumentedClasses(String jarPath) throws IOException {
        ArrayList<String> errorMessages = new ArrayList<String>();
        ArrayList<String> allClasses = new ArrayList<String>();
        try (JarFile jarFile = new JarFile(jarPath);){
            Enumeration<JarEntry> allEntries = jarFile.entries();
            while (allEntries.hasMoreElements()) {
                JarEntry entry = allEntries.nextElement();
                if (entry.isDirectory()) continue;
                String name = entry.getName();
                if (!name.endsWith(".class")) {
                    Log.info("Skipping instrumenting file: " + name);
                    continue;
                }
                String className = name.substring(0, name.lastIndexOf(".class"));
                className = className.replace('/', '.');
                allClasses.add(className);
                Log.info("Found class: " + className);
            }
        }
        if (allClasses.size() == 0) {
            errorMessages.add("Classes is empty for jar: " + jarPath);
            return errorMessages;
        }
        File file = new File(jarPath);
        URL url = file.toURI().toURL();
        URL[] urls = new URL[]{url};
        URLClassLoader cl = new URLClassLoader(urls);
        for (String className : allClasses) {
            try {
                cl.loadClass(className);
            }
            catch (UnsupportedClassVersionError ucve) {
                Log.warn(ucve.toString());
            }
            catch (Throwable e) {
                errorMessages.add("Failed to instrument class: " + className + ". Error: " + e);
            }
        }
        return errorMessages;
    }

    private static void createInstrumentedJar(String originalJarPath, String instrumentedClassesDir, String outputZip) throws IOException {
        try (ZipOutputStream zos = new ZipOutputStream(new FileOutputStream(outputZip));){
            HashSet<String> dirFilesToSkip = new HashSet<String>();
            dirFilesToSkip.add(".original.class");
            dirFilesToSkip.add(".failed.class");
            Set<String> filesMerged = ZipUtils.mergeDirectoryToZip(instrumentedClassesDir, zos, dirFilesToSkip);
            ZipUtils.mergeZipToZip(originalJarPath, zos, filesMerged);
        }
    }
}

