/*
 * Decompiled with CFR 0.152.
 */
package com.code_intelligence.jazzer.instrumentor;

import com.code_intelligence.jazzer.third_party.kotlin.Metadata;
import com.code_intelligence.jazzer.third_party.kotlin.collections.ArraysKt;
import com.code_intelligence.jazzer.third_party.kotlin.jvm.internal.Intrinsics;
import com.code_intelligence.jazzer.third_party.kotlin.jvm.internal.SourceDebugExtension;
import com.code_intelligence.jazzer.third_party.kotlin.ranges.IntRange;
import com.code_intelligence.jazzer.third_party.kotlin.text.StringsKt;
import com.code_intelligence.jazzer.third_party.org.objectweb.asm.Type;
import java.lang.reflect.Constructor;
import java.lang.reflect.Executable;
import java.lang.reflect.Method;
import java.util.ArrayList;
import java.util.List;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={1, 9, 0}, k=2, xi=48, d1={"\u0000(\n\u0000\n\u0002\u0010\u000e\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0006\n\u0002\u0010 \n\u0002\b\u0004\n\u0002\u0010\u000b\n\u0002\u0010\f\n\u0000\u001a\u0010\u0010\u0007\u001a\u00020\u00012\u0006\u0010\b\u001a\u00020\u0001H\u0000\u001a\u0010\u0010\t\u001a\u00020\u00012\u0006\u0010\n\u001a\u00020\u0001H\u0002\u001a\u0016\u0010\u000b\u001a\b\u0012\u0004\u0012\u00020\u00010\f2\u0006\u0010\r\u001a\u00020\u0001H\u0000\u001a\u0010\u0010\u000e\u001a\u00020\u00012\u0006\u0010\r\u001a\u00020\u0001H\u0000\u001a\u0010\u0010\u000f\u001a\u00020\u00012\u0006\u0010\b\u001a\u00020\u0001H\u0000\u001a\u0010\u0010\u0010\u001a\u00020\u00112\u0006\u0010\b\u001a\u00020\u0012H\u0002\u001a\u0010\u0010\u0010\u001a\u00020\u00112\u0006\u0010\b\u001a\u00020\u0001H\u0000\"\u0019\u0010\u0000\u001a\u00020\u0001*\u0006\u0012\u0002\b\u00030\u00028F\u00a2\u0006\u0006\u001a\u0004\b\u0003\u0010\u0004\"\u0015\u0010\u0000\u001a\u00020\u0001*\u00020\u00058F\u00a2\u0006\u0006\u001a\u0004\b\u0003\u0010\u0006\u00a8\u0006\u0013"}, d2={"descriptor", "", "Ljava/lang/Class;", "getDescriptor", "(Ljava/lang/Class;)Ljava/lang/String;", "Ljava/lang/reflect/Executable;", "(Ljava/lang/reflect/Executable;)Ljava/lang/String;", "extractInternalClassName", "typeDescriptor", "extractNextTypeDescriptor", "input", "extractParameterTypeDescriptors", "", "methodDescriptor", "extractReturnTypeDescriptor", "getWrapperTypeDescriptor", "isPrimitiveType", "", "", "src_main_java_com_code_intelligence_jazzer_instrumentor-instrumentor"})
@SourceDebugExtension(value={"SMAP\nDescriptorUtils.kt\nKotlin\n*S Kotlin\n*F\n+ 1 DescriptorUtils.kt\ncom/code_intelligence/jazzer/instrumentor/DescriptorUtilsKt\n+ 2 fake.kt\nkotlin/jvm/internal/FakeKt\n+ 3 _Strings.kt\nkotlin/text/StringsKt___StringsKt\n*L\n1#1,108:1\n1#2:109\n151#3,6:110\n*S KotlinDebug\n*F\n+ 1 DescriptorUtils.kt\ncom/code_intelligence/jazzer/instrumentor/DescriptorUtilsKt\n*L\n88#1:110,6\n*E\n"})
public final class DescriptorUtilsKt {
    @NotNull
    public static final String getDescriptor(@NotNull Class<?> $this$descriptor) {
        Intrinsics.checkNotNullParameter($this$descriptor, "<this>");
        String string = Type.getDescriptor($this$descriptor);
        Intrinsics.checkNotNullExpressionValue(string, "getDescriptor(...)");
        return string;
    }

    @NotNull
    public static final String getDescriptor(@NotNull Executable $this$descriptor) {
        String string;
        Intrinsics.checkNotNullParameter($this$descriptor, "<this>");
        if ($this$descriptor instanceof Method) {
            String string2 = Type.getMethodDescriptor((Method)$this$descriptor);
            Intrinsics.checkNotNull(string2);
            string = string2;
        } else {
            String string3 = Type.getConstructorDescriptor((Constructor)$this$descriptor);
            Intrinsics.checkNotNull(string3);
            string = string3;
        }
        return string;
    }

    public static final boolean isPrimitiveType(@NotNull String typeDescriptor) {
        Intrinsics.checkNotNullParameter(typeDescriptor, "typeDescriptor");
        String[] stringArray = new String[]{"B", "C", "D", "F", "I", "J", "S", "V", "Z"};
        return ArraysKt.contains(stringArray, typeDescriptor);
    }

    private static final boolean isPrimitiveType(char typeDescriptor) {
        return DescriptorUtilsKt.isPrimitiveType(String.valueOf(typeDescriptor));
    }

    @NotNull
    public static final String getWrapperTypeDescriptor(@NotNull String typeDescriptor) {
        String string;
        Intrinsics.checkNotNullParameter(typeDescriptor, "typeDescriptor");
        switch (typeDescriptor) {
            case "B": {
                string = "Ljava/lang/Byte;";
                break;
            }
            case "C": {
                string = "Ljava/lang/Character;";
                break;
            }
            case "D": {
                string = "Ljava/lang/Double;";
                break;
            }
            case "F": {
                string = "Ljava/lang/Float;";
                break;
            }
            case "I": {
                string = "Ljava/lang/Integer;";
                break;
            }
            case "J": {
                string = "Ljava/lang/Long;";
                break;
            }
            case "S": {
                string = "Ljava/lang/Short;";
                break;
            }
            case "V": {
                string = "Ljava/lang/Void;";
                break;
            }
            case "Z": {
                string = "Ljava/lang/Boolean;";
                break;
            }
            default: {
                string = typeDescriptor;
            }
        }
        return string;
    }

    @NotNull
    public static final String extractInternalClassName(@NotNull String typeDescriptor) {
        String string;
        Intrinsics.checkNotNullParameter(typeDescriptor, "typeDescriptor");
        if (StringsKt.startsWith$default(typeDescriptor, "L", false, 2, null) && StringsKt.endsWith$default(typeDescriptor, ";", false, 2, null)) {
            String string2 = typeDescriptor.substring(1, typeDescriptor.length() - 1);
            string = string2;
            Intrinsics.checkNotNullExpressionValue(string2, "substring(...)");
        } else {
            string = typeDescriptor;
        }
        return string;
    }

    @NotNull
    public static final List<String> extractParameterTypeDescriptors(@NotNull String methodDescriptor) {
        Intrinsics.checkNotNullParameter(methodDescriptor, "methodDescriptor");
        if (!StringsKt.startsWith$default((CharSequence)methodDescriptor, '(', false, 2, null)) {
            boolean $i$a$-require-DescriptorUtilsKt$extractParameterTypeDescriptors$32 = false;
            String $i$a$-require-DescriptorUtilsKt$extractParameterTypeDescriptors$32 = "Method descriptor must start with '('";
            throw new IllegalArgumentException($i$a$-require-DescriptorUtilsKt$extractParameterTypeDescriptors$32.toString());
        }
        int endOfParameterPart = StringsKt.indexOf$default((CharSequence)methodDescriptor, ')', 0, false, 6, null) - 1;
        if (!(endOfParameterPart >= 0)) {
            boolean $i$a$-require-DescriptorUtilsKt$extractParameterTypeDescriptors$42 = false;
            String $i$a$-require-DescriptorUtilsKt$extractParameterTypeDescriptors$42 = "Method descriptor must contain ')'";
            throw new IllegalArgumentException($i$a$-require-DescriptorUtilsKt$extractParameterTypeDescriptors$42.toString());
        }
        String remainingDescriptorList = StringsKt.substring(methodDescriptor, new IntRange(1, endOfParameterPart));
        List parameterDescriptors = new ArrayList();
        while (((CharSequence)remainingDescriptorList).length() > 0) {
            String nextDescriptor = DescriptorUtilsKt.extractNextTypeDescriptor(remainingDescriptorList);
            parameterDescriptors.add(nextDescriptor);
            remainingDescriptorList = StringsKt.removePrefix(remainingDescriptorList, (CharSequence)nextDescriptor);
        }
        return parameterDescriptors;
    }

    @NotNull
    public static final String extractReturnTypeDescriptor(@NotNull String methodDescriptor) {
        Intrinsics.checkNotNullParameter(methodDescriptor, "methodDescriptor");
        if (!StringsKt.startsWith$default((CharSequence)methodDescriptor, '(', false, 2, null)) {
            boolean $i$a$-require-DescriptorUtilsKt$extractReturnTypeDescriptor$32 = false;
            String $i$a$-require-DescriptorUtilsKt$extractReturnTypeDescriptor$32 = "Method descriptor must start with '('";
            throw new IllegalArgumentException($i$a$-require-DescriptorUtilsKt$extractReturnTypeDescriptor$32.toString());
        }
        int endBracketPos = StringsKt.indexOf$default((CharSequence)methodDescriptor, ')', 0, false, 6, null);
        if (!(endBracketPos >= 0)) {
            boolean bl = false;
            String string = "Method descriptor must contain ')'";
            throw new IllegalArgumentException(string.toString());
        }
        int startOfReturnValue = endBracketPos + 1;
        String string = methodDescriptor.substring(startOfReturnValue);
        Intrinsics.checkNotNullExpressionValue(string, "substring(...)");
        return DescriptorUtilsKt.extractNextTypeDescriptor(string);
    }

    private static final String extractNextTypeDescriptor(String input) {
        String string;
        int firstNonArrayPrefixCharPos;
        block8: {
            int n;
            if (!(((CharSequence)input).length() > 0)) {
                boolean $i$a$-require-DescriptorUtilsKt$extractNextTypeDescriptor$42 = false;
                String $i$a$-require-DescriptorUtilsKt$extractNextTypeDescriptor$42 = "Type descriptor must not be empty";
                throw new IllegalArgumentException($i$a$-require-DescriptorUtilsKt$extractNextTypeDescriptor$42.toString());
            }
            CharSequence $this$indexOfFirst$iv = input;
            boolean $i$f$indexOfFirst = false;
            int n2 = $this$indexOfFirst$iv.length();
            for (int index$iv = 0; index$iv < n2; ++index$iv) {
                char it = $this$indexOfFirst$iv.charAt(index$iv);
                boolean bl = false;
                if (!(it != '[')) continue;
                n = index$iv;
                break block8;
            }
            n = firstNonArrayPrefixCharPos = -1;
        }
        if (!(firstNonArrayPrefixCharPos >= 0)) {
            boolean $i$a$-require-DescriptorUtilsKt$extractNextTypeDescriptor$52 = false;
            String $i$a$-require-DescriptorUtilsKt$extractNextTypeDescriptor$52 = "Array descriptor must contain type";
            throw new IllegalArgumentException($i$a$-require-DescriptorUtilsKt$extractNextTypeDescriptor$52.toString());
        }
        char firstTypeChar = input.charAt(firstNonArrayPrefixCharPos);
        if (DescriptorUtilsKt.isPrimitiveType(firstTypeChar)) {
            string = StringsKt.substring(input, new IntRange(0, firstNonArrayPrefixCharPos));
        } else if (firstTypeChar == 'L') {
            int endOfClassNamePos = StringsKt.indexOf$default((CharSequence)input, ';', 0, false, 6, null);
            if (!(endOfClassNamePos > 0)) {
                boolean bl = false;
                String string2 = "Class type indicated by L must end with ;";
                throw new IllegalArgumentException(string2.toString());
            }
            string = StringsKt.substring(input, new IntRange(0, endOfClassNamePos));
        } else {
            throw new IllegalArgumentException("Invalid type: " + firstTypeChar);
        }
        return string;
    }
}

