/*
 * Decompiled with CFR 0.152.
 */
package com.code_intelligence.jazzer.mutation.combinator;

import com.code_intelligence.jazzer.mutation.api.Debuggable;
import com.code_intelligence.jazzer.mutation.api.InPlaceMutator;
import com.code_intelligence.jazzer.mutation.api.MutatorBase;
import com.code_intelligence.jazzer.mutation.api.PseudoRandom;
import com.code_intelligence.jazzer.mutation.api.Serializer;
import com.code_intelligence.jazzer.mutation.api.SerializingInPlaceMutator;
import com.code_intelligence.jazzer.mutation.api.SerializingMutator;
import com.code_intelligence.jazzer.mutation.combinator.InPlaceProductMutator;
import com.code_intelligence.jazzer.mutation.combinator.PostComposedMutator;
import com.code_intelligence.jazzer.mutation.combinator.ProductMutator;
import com.code_intelligence.jazzer.mutation.support.Preconditions;
import com.code_intelligence.jazzer.third_party.net.jodah.typetools.TypeResolver;
import java.io.DataInputStream;
import java.io.DataOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.util.Arrays;
import java.util.Objects;
import java.util.function.BiConsumer;
import java.util.function.BiFunction;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.function.Predicate;
import java.util.function.Supplier;
import java.util.function.ToIntFunction;
import java.util.stream.Collectors;

public final class MutatorCombinators {
    private static final int INVERSE_PICK_VALUE_SUPPLIER_FREQUENCY = 100;

    private MutatorCombinators() {
    }

    public static <T, R> InPlaceMutator<T> mutateProperty(final Function<T, R> getter, final SerializingMutator<R> mutator, final BiConsumer<T, R> setter) {
        Objects.requireNonNull(getter);
        Objects.requireNonNull(mutator);
        Objects.requireNonNull(setter);
        return new InPlaceMutator<T>(){

            @Override
            public void initInPlace(T reference, PseudoRandom prng) {
                setter.accept(reference, mutator.init(prng));
            }

            @Override
            public void mutateInPlace(T reference, PseudoRandom prng) {
                setter.accept(reference, mutator.mutate(getter.apply(reference), prng));
            }

            @Override
            public void crossOverInPlace(T reference, T otherReference, PseudoRandom prng) {
                Object otherReferenceValue;
                Object referenceValue = getter.apply(reference);
                Object crossedOver = prng.pickValue(referenceValue, otherReferenceValue = getter.apply(otherReference), () -> mutator.crossOver(referenceValue, otherReferenceValue, prng), 100);
                if (crossedOver == otherReferenceValue) {
                    crossedOver = mutator.detach(crossedOver);
                }
                setter.accept(reference, crossedOver);
            }

            @Override
            public boolean hasFixedSize() {
                return mutator.hasFixedSize();
            }

            @Override
            public String toDebugString(Predicate<Debuggable> isInCycle) {
                Class<?> owningType = TypeResolver.resolveRawArguments(Function.class, getter.getClass())[0];
                return owningType.getSimpleName() + "." + mutator.toDebugString(isInCycle);
            }

            public String toString() {
                return Debuggable.getDebugString(this);
            }
        };
    }

    public static <T, R> InPlaceMutator<T> mutateViaView(final Function<T, R> map, final InPlaceMutator<R> mutator) {
        Objects.requireNonNull(map);
        Objects.requireNonNull(mutator);
        return new InPlaceMutator<T>(){

            @Override
            public void initInPlace(T reference, PseudoRandom prng) {
                mutator.initInPlace(map.apply(reference), prng);
            }

            @Override
            public void mutateInPlace(T reference, PseudoRandom prng) {
                mutator.mutateInPlace(map.apply(reference), prng);
            }

            @Override
            public void crossOverInPlace(T reference, T otherReference, PseudoRandom prng) {
                mutator.crossOverInPlace(map.apply(reference), map.apply(otherReference), prng);
            }

            @Override
            public boolean hasFixedSize() {
                return mutator.hasFixedSize();
            }

            @Override
            public String toDebugString(Predicate<Debuggable> isInCycle) {
                Class<?> owningType = TypeResolver.resolveRawArguments(Function.class, map.getClass())[0];
                return owningType.getSimpleName() + " via " + mutator.toDebugString(isInCycle);
            }

            public String toString() {
                return Debuggable.getDebugString(this);
            }
        };
    }

    @SafeVarargs
    public static <T> InPlaceMutator<T> combine(final InPlaceMutator<T> ... partialMutators) {
        Preconditions.requireNonNullElements(partialMutators);
        if (partialMutators.length == 0) {
            return new InPlaceMutator<T>(){

                @Override
                public void initInPlace(T reference, PseudoRandom prng) {
                }

                @Override
                public void mutateInPlace(T reference, PseudoRandom prng) {
                }

                @Override
                public void crossOverInPlace(T reference, T otherReference, PseudoRandom prng) {
                }

                @Override
                public boolean hasFixedSize() {
                    return true;
                }

                @Override
                public String toDebugString(Predicate<Debuggable> isInCycle) {
                    return "{<empty>}";
                }

                public String toString() {
                    return Debuggable.getDebugString(this);
                }
            };
        }
        final InPlaceMutator[] mutators = Arrays.copyOf(partialMutators, partialMutators.length);
        return new InPlaceMutator<T>(){
            private Boolean cachedHasFixedSize;

            @Override
            public void initInPlace(T reference, PseudoRandom prng) {
                for (InPlaceMutator mutator : mutators) {
                    mutator.initInPlace(reference, prng);
                }
            }

            @Override
            public void mutateInPlace(T reference, PseudoRandom prng) {
                mutators[prng.indexIn(mutators)].mutateInPlace(reference, prng);
            }

            @Override
            public void crossOverInPlace(T reference, T otherReference, PseudoRandom prng) {
                for (InPlaceMutator mutator : mutators) {
                    mutator.crossOverInPlace(reference, otherReference, prng);
                }
            }

            @Override
            public boolean hasFixedSize() {
                if (this.cachedHasFixedSize != null) {
                    return this.cachedHasFixedSize;
                }
                this.cachedHasFixedSize = false;
                this.cachedHasFixedSize = Arrays.stream(partialMutators).allMatch(MutatorBase::hasFixedSize);
                return this.cachedHasFixedSize;
            }

            @Override
            public String toDebugString(Predicate<Debuggable> isInCycle) {
                return Arrays.stream(mutators).map(mutator -> mutator.toDebugString(isInCycle)).collect(Collectors.joining(", ", "{", "}"));
            }

            public String toString() {
                return Debuggable.getDebugString(this);
            }
        };
    }

    public static <T, R> SerializingMutator<R> mutateThenMap(SerializingMutator<T> mutator, Function<T, R> map, Function<R, T> inverse) {
        return new PostComposedMutator<T, R>((SerializingMutator)mutator, (Function)map, (Function)inverse){};
    }

    public static <T, R> SerializingMutator<R> mutateThenMap(SerializingMutator<T> mutator, Function<T, R> map, Function<R, T> inverse, final Function<Predicate<Debuggable>, String> debug) {
        return new PostComposedMutator<T, R>(mutator, map, inverse){

            @Override
            public String toDebugString(Predicate<Debuggable> isInCycle) {
                return (String)debug.apply(isInCycle);
            }
        };
    }

    public static <T, R> SerializingMutator<R> mutateThenMap(Supplier<SerializingMutator<T>> mutator, Function<T, R> map, Function<R, T> inverse, final BiFunction<SerializingMutator<T>, Predicate<Debuggable>, String> debug, Consumer<SerializingMutator<R>> registerSelf) {
        return new PostComposedMutator<T, R>(mutator, map, inverse, registerSelf){

            @Override
            public String toDebugString(Predicate<Debuggable> isInCycle) {
                return (String)debug.apply(this.mutator, isInCycle);
            }
        };
    }

    public static <T, R> SerializingMutator<R> mutateThenMapToImmutable(SerializingMutator<T> mutator, Function<T, R> map, Function<R, T> inverse) {
        return new PostComposedMutator<T, R>((SerializingMutator)mutator, (Function)map, (Function)inverse){

            @Override
            public R detach(R value) {
                return value;
            }
        };
    }

    public static <T, R> SerializingMutator<R> mutateThenMapToImmutable(SerializingMutator<T> mutator, Function<T, R> map, Function<R, T> inverse, Function<Predicate<Debuggable>, String> debug) {
        return MutatorCombinators.mutateThenMapToImmutable(() -> mutator, map, inverse, (unused, isInCycle) -> (String)debug.apply((Predicate<Debuggable>)isInCycle), unused -> {});
    }

    public static <T, R> SerializingMutator<R> mutateThenMapToImmutable(Supplier<SerializingMutator<T>> mutator, Function<T, R> map, Function<R, T> inverse, final BiFunction<SerializingMutator<T>, Predicate<Debuggable>, String> debug, Consumer<SerializingMutator<R>> registerSelf) {
        return new PostComposedMutator<T, R>(mutator, map, inverse, registerSelf){

            @Override
            public R detach(R value) {
                return value;
            }

            @Override
            public String toDebugString(Predicate<Debuggable> isInCycle) {
                return (String)debug.apply(this.mutator, isInCycle);
            }
        };
    }

    public static SerializingMutator<Integer> mutateIndices(final int length) {
        Preconditions.require(length > 1, "There should be at least two indices to choose from");
        return new SerializingMutator<Integer>(){

            @Override
            public Integer read(DataInputStream in) throws IOException {
                return Math.floorMod(in.readInt(), length);
            }

            @Override
            public void write(Integer value, DataOutputStream out) throws IOException {
                out.writeInt(value);
            }

            @Override
            public Integer detach(Integer value) {
                return value;
            }

            @Override
            public Integer init(PseudoRandom prng) {
                return prng.closedRange(0, length - 1);
            }

            @Override
            public Integer mutate(Integer value, PseudoRandom prng) {
                return prng.otherIndexIn(length, (int)value);
            }

            @Override
            public Integer crossOver(Integer value, Integer otherValue, PseudoRandom prng) {
                return prng.choice() ? value : otherValue;
            }

            @Override
            public boolean hasFixedSize() {
                return true;
            }

            @Override
            public String toDebugString(Predicate<Debuggable> isInCycle) {
                return "mutateIndices(" + length + ")";
            }
        };
    }

    public static InPlaceProductMutator mutateProductInPlace(SerializingMutator ... mutators) {
        return new InPlaceProductMutator(mutators);
    }

    public static ProductMutator mutateProduct(SerializingMutator ... mutators) {
        return new ProductMutator(mutators);
    }

    @SafeVarargs
    public static <T> InPlaceMutator<T> mutateSumInPlace(final ToIntFunction<T> getState, InPlaceMutator<T> ... perStateMutators) {
        final boolean hasFixedSize = Arrays.stream(perStateMutators).allMatch(MutatorBase::hasFixedSize);
        final InPlaceMutator[] mutators = Arrays.copyOf(perStateMutators, perStateMutators.length);
        return new InPlaceMutator<T>(){

            @Override
            public void initInPlace(T reference, PseudoRandom prng) {
                mutators[prng.indexIn(mutators)].initInPlace(reference, prng);
            }

            @Override
            public void mutateInPlace(T reference, PseudoRandom prng) {
                int currentState = getState.applyAsInt(reference);
                if (currentState == -1) {
                    this.initInPlace(reference, prng);
                } else if (prng.trueInOneOutOf(100) && mutators.length > 1) {
                    mutators[prng.otherIndexIn(mutators, currentState)].initInPlace(reference, prng);
                } else {
                    mutators[currentState].mutateInPlace(reference, prng);
                }
            }

            @Override
            public void crossOverInPlace(T reference, T otherReference, PseudoRandom prng) {
                int currentState = getState.applyAsInt(reference);
                int otherState = getState.applyAsInt(otherReference);
                if (currentState == -1) {
                    if (otherState == -1) {
                        return;
                    }
                    mutators[otherState].initInPlace(reference, prng);
                } else if (currentState == otherState) {
                    mutators[currentState].crossOverInPlace(reference, otherReference, prng);
                }
            }

            @Override
            public boolean hasFixedSize() {
                return hasFixedSize;
            }

            @Override
            public String toDebugString(Predicate<Debuggable> isInCycle) {
                return Arrays.stream(mutators).map(mutator -> mutator.toDebugString(isInCycle)).collect(Collectors.joining(" | "));
            }
        };
    }

    public static <T> InPlaceMutator<T> withoutInit(final InPlaceMutator<T> mutator) {
        return new InPlaceMutator<T>(){

            @Override
            public void initInPlace(T reference, PseudoRandom prng) {
            }

            @Override
            public String toDebugString(Predicate<Debuggable> isInCycle) {
                return "WithoutInit(" + mutator.toDebugString(isInCycle) + ")";
            }

            @Override
            public void mutateInPlace(T reference, PseudoRandom prng) {
                mutator.mutateInPlace(reference, prng);
            }

            @Override
            public void crossOverInPlace(T reference, T otherReference, PseudoRandom prng) {
                mutator.crossOverInPlace(reference, otherReference, prng);
            }

            @Override
            public boolean hasFixedSize() {
                return mutator.hasFixedSize();
            }
        };
    }

    public static <T> SerializingMutator<T> markAsRequiringRecursionBreaking(final SerializingMutator<T> mutator) {
        return new SerializingMutator<T>(){

            @Override
            public boolean requiresRecursionBreaking() {
                return true;
            }

            @Override
            public T init(PseudoRandom prng) {
                return mutator.init(prng);
            }

            @Override
            public String toDebugString(Predicate<Debuggable> isInCycle) {
                return "RecursionBreaking(" + mutator.toDebugString(isInCycle) + ")";
            }

            @Override
            public T read(DataInputStream in) throws IOException {
                return mutator.read(in);
            }

            @Override
            public void write(T value, DataOutputStream out) throws IOException {
                mutator.write(value, out);
            }

            @Override
            public T detach(T value) {
                return mutator.detach(value);
            }

            @Override
            public T mutate(T value, PseudoRandom prng) {
                return mutator.mutate(value, prng);
            }

            @Override
            public T crossOver(T value, T otherValue, PseudoRandom prng) {
                return mutator.crossOver(value, otherValue, prng);
            }

            @Override
            protected boolean computeHasFixedSize() {
                return mutator.hasFixedSize();
            }
        };
    }

    public static <T> SerializingMutator<T> fixedValue(final T value) {
        return new SerializingMutator<T>(){

            @Override
            public String toDebugString(Predicate<Debuggable> isInCycle) {
                return "FixedValue(" + value + ")";
            }

            @Override
            public T read(DataInputStream in) {
                return value;
            }

            @Override
            public void write(T value2, DataOutputStream out) {
            }

            @Override
            public T detach(T value2) {
                return value2;
            }

            @Override
            public T init(PseudoRandom prng) {
                return value;
            }

            @Override
            public T mutate(T value2, PseudoRandom prng) {
                return value2;
            }

            @Override
            public T crossOver(T value2, T otherValue, PseudoRandom prng) {
                return value2;
            }

            @Override
            public boolean hasFixedSize() {
                return true;
            }
        };
    }

    public static <T> SerializingInPlaceMutator<T> assemble(Consumer<SerializingInPlaceMutator<T>> registerSelf, Supplier<T> makeDefaultInstance, Serializer<T> serializer, Supplier<InPlaceMutator<T>> lazyMutator) {
        return new DelegatingSerializingInPlaceMutator(registerSelf, makeDefaultInstance, serializer, lazyMutator);
    }

    private static final class DelegatingSerializingInPlaceMutator<T>
    extends SerializingInPlaceMutator<T> {
        private final Supplier<T> makeDefaultInstance;
        private final Serializer<T> serializer;
        private final InPlaceMutator<T> mutator;

        private DelegatingSerializingInPlaceMutator(Consumer<SerializingInPlaceMutator<T>> registerSelf, Supplier<T> makeDefaultInstance, Serializer<T> serializer, Supplier<InPlaceMutator<T>> lazyMutator) {
            Objects.requireNonNull(makeDefaultInstance);
            Objects.requireNonNull(serializer);
            registerSelf.accept(this);
            this.makeDefaultInstance = makeDefaultInstance;
            this.serializer = serializer;
            this.mutator = lazyMutator.get();
        }

        @Override
        public void initInPlace(T reference, PseudoRandom prng) {
            this.mutator.initInPlace(reference, prng);
        }

        @Override
        public void mutateInPlace(T reference, PseudoRandom prng) {
            this.mutator.mutateInPlace(reference, prng);
        }

        @Override
        public void crossOverInPlace(T reference, T otherReference, PseudoRandom prng) {
            this.mutator.crossOverInPlace(reference, otherReference, prng);
        }

        @Override
        protected boolean computeHasFixedSize() {
            return this.mutator.hasFixedSize();
        }

        @Override
        protected T makeDefaultInstance() {
            return this.makeDefaultInstance.get();
        }

        @Override
        public T read(DataInputStream in) throws IOException {
            return this.serializer.read(in);
        }

        @Override
        public void write(T value, DataOutputStream out) throws IOException {
            this.serializer.write(value, out);
        }

        @Override
        public T readExclusive(InputStream in) throws IOException {
            return this.serializer.readExclusive(in);
        }

        @Override
        public void writeExclusive(T value, OutputStream out) throws IOException {
            this.serializer.writeExclusive(value, out);
        }

        @Override
        public T detach(T value) {
            return this.serializer.detach(value);
        }

        @Override
        public String toDebugString(Predicate<Debuggable> isInCycle) {
            if (isInCycle.test(this)) {
                return "(cycle)";
            }
            return this.mutator.toDebugString(isInCycle);
        }
    }
}

