/*
 * Decompiled with CFR 0.152.
 */
package com.code_intelligence.jazzer.mutation.mutator.aggregate;

import com.code_intelligence.jazzer.mutation.api.MutatorFactory;
import com.code_intelligence.jazzer.mutation.mutator.aggregate.CachedConstructorMutatorFactory;
import com.code_intelligence.jazzer.mutation.mutator.aggregate.ConstructorBasedBeanMutatorFactory;
import com.code_intelligence.jazzer.mutation.mutator.aggregate.SetterBasedBeanMutatorFactory;
import java.lang.reflect.InvocationTargetException;
import java.util.stream.Stream;

public final class AggregateMutators {
    private AggregateMutators() {
    }

    public static Stream<MutatorFactory> newFactories() {
        return Stream.concat(AggregateMutators.newRecordMutatorFactoryIfSupported(), Stream.of(new SetterBasedBeanMutatorFactory(), new ConstructorBasedBeanMutatorFactory(), new CachedConstructorMutatorFactory()));
    }

    private static Stream<MutatorFactory> newRecordMutatorFactoryIfSupported() {
        if (!AggregateMutators.supportsRecords()) {
            return Stream.empty();
        }
        try {
            Class<MutatorFactory> recordMutatorFactory = Class.forName(AggregateMutators.class.getPackage().getName() + ".RecordMutatorFactory").asSubclass(MutatorFactory.class);
            return Stream.of(recordMutatorFactory.getDeclaredConstructor(new Class[0]).newInstance(new Object[0]));
        }
        catch (ClassNotFoundException | IllegalAccessException | InstantiationException | NoSuchMethodException | InvocationTargetException e) {
            throw new IllegalStateException(e);
        }
    }

    private static boolean supportsRecords() {
        try {
            Class.forName("java.lang.Record");
            return true;
        }
        catch (ClassNotFoundException ignored) {
            return false;
        }
    }
}

