/*
 * Decompiled with CFR 0.152.
 */
package com.code_intelligence.jazzer.mutation.mutator.lang;

import com.code_intelligence.jazzer.mutation.annotation.InRange;
import com.code_intelligence.jazzer.mutation.api.Debuggable;
import com.code_intelligence.jazzer.mutation.api.ExtendedMutatorFactory;
import com.code_intelligence.jazzer.mutation.api.MutatorFactory;
import com.code_intelligence.jazzer.mutation.api.PseudoRandom;
import com.code_intelligence.jazzer.mutation.api.SerializingMutator;
import com.code_intelligence.jazzer.mutation.mutator.libfuzzer.LibFuzzerMutate;
import com.code_intelligence.jazzer.mutation.support.Preconditions;
import com.google.errorprone.annotations.ForOverride;
import java.io.DataInputStream;
import java.io.DataOutputStream;
import java.io.IOException;
import java.lang.annotation.Annotation;
import java.lang.reflect.AnnotatedType;
import java.lang.reflect.ParameterizedType;
import java.util.Optional;
import java.util.function.Predicate;
import java.util.stream.LongStream;

final class IntegralMutatorFactory
implements MutatorFactory {
    IntegralMutatorFactory() {
    }

    @Override
    public Optional<SerializingMutator<?>> tryCreate(AnnotatedType type, ExtendedMutatorFactory factory) {
        if (!(type.getType() instanceof Class)) {
            return Optional.empty();
        }
        Class clazz = (Class)type.getType();
        if (clazz == Byte.TYPE || clazz == Byte.class) {
            return Optional.of(new AbstractIntegralMutator<Byte>(type, -128L, 127L){

                @Override
                protected long mutateWithLibFuzzer(long value) {
                    return LibFuzzerMutate.mutateDefault((byte)value, this, 0).byteValue();
                }

                @Override
                public Byte init(PseudoRandom prng) {
                    return (byte)this.initImpl(prng);
                }

                @Override
                public Byte mutate(Byte value, PseudoRandom prng) {
                    return (byte)this.mutateImpl(value.byteValue(), prng);
                }

                @Override
                public Byte crossOver(Byte value, Byte otherValue, PseudoRandom prng) {
                    return (byte)this.crossOverImpl(value.byteValue(), otherValue.byteValue(), prng);
                }

                @Override
                public Byte read(DataInputStream in) throws IOException {
                    return (byte)this.forceInRange(in.readByte());
                }

                @Override
                public void write(Byte value, DataOutputStream out) throws IOException {
                    out.writeByte(value.byteValue());
                }
            });
        }
        if (clazz == Short.TYPE || clazz == Short.class) {
            return Optional.of(new AbstractIntegralMutator<Short>(type, -32768L, 32767L){

                @Override
                protected long mutateWithLibFuzzer(long value) {
                    return LibFuzzerMutate.mutateDefault((short)value, this, 0).shortValue();
                }

                @Override
                public Short init(PseudoRandom prng) {
                    return (short)this.initImpl(prng);
                }

                @Override
                public Short mutate(Short value, PseudoRandom prng) {
                    return (short)this.mutateImpl(value.shortValue(), prng);
                }

                @Override
                public Short crossOver(Short value, Short otherValue, PseudoRandom prng) {
                    return (short)this.crossOverImpl(value.shortValue(), otherValue.shortValue(), prng);
                }

                @Override
                public Short read(DataInputStream in) throws IOException {
                    return (short)this.forceInRange(in.readShort());
                }

                @Override
                public void write(Short value, DataOutputStream out) throws IOException {
                    out.writeShort(value.shortValue());
                }
            });
        }
        if (clazz == Integer.TYPE || clazz == Integer.class) {
            return Optional.of(new AbstractIntegralMutator<Integer>(type, Integer.MIN_VALUE, Integer.MAX_VALUE){

                @Override
                protected long mutateWithLibFuzzer(long value) {
                    return LibFuzzerMutate.mutateDefault((int)value, this, 0).intValue();
                }

                @Override
                public Integer init(PseudoRandom prng) {
                    return (int)this.initImpl(prng);
                }

                @Override
                public Integer mutate(Integer value, PseudoRandom prng) {
                    return (int)this.mutateImpl(value.intValue(), prng);
                }

                @Override
                public Integer crossOver(Integer value, Integer otherValue, PseudoRandom prng) {
                    return (int)this.crossOverImpl(value.intValue(), otherValue.intValue(), prng);
                }

                @Override
                public Integer read(DataInputStream in) throws IOException {
                    return (int)this.forceInRange(in.readInt());
                }

                @Override
                public void write(Integer value, DataOutputStream out) throws IOException {
                    out.writeInt(value);
                }
            });
        }
        if (clazz == Long.TYPE || clazz == Long.class) {
            return Optional.of(new AbstractIntegralMutator<Long>(type, Long.MIN_VALUE, Long.MAX_VALUE){

                @Override
                protected long mutateWithLibFuzzer(long value) {
                    return LibFuzzerMutate.mutateDefault(value, this, 0);
                }

                @Override
                public Long init(PseudoRandom prng) {
                    return this.initImpl(prng);
                }

                @Override
                public Long mutate(Long value, PseudoRandom prng) {
                    return this.mutateImpl(value, prng);
                }

                @Override
                public Long crossOver(Long value, Long otherValue, PseudoRandom prng) {
                    return this.crossOverImpl(value, otherValue, prng);
                }

                @Override
                public Long read(DataInputStream in) throws IOException {
                    return this.forceInRange(in.readLong());
                }

                @Override
                public void write(Long value, DataOutputStream out) throws IOException {
                    out.writeLong(value);
                }
            });
        }
        return Optional.empty();
    }

    static abstract class AbstractIntegralMutator<T extends Number>
    extends SerializingMutator<T> {
        private static final long RANDOM_WALK_RANGE = 5L;
        private final long minValue;
        private final long maxValue;
        private final int largestMutableBitNegative;
        private final int largestMutableBitPositive;
        private final long[] specialValues;

        AbstractIntegralMutator(AnnotatedType type, long defaultMinValueForType, long defaultMaxValueForType) {
            long minValue = defaultMinValueForType;
            long maxValue = defaultMaxValueForType;
            for (Annotation annotation : type.getAnnotations()) {
                if (!(annotation instanceof InRange)) continue;
                InRange inRange = (InRange)annotation;
                if (inRange.min() != Long.MIN_VALUE) {
                    Preconditions.require(inRange.min() >= defaultMinValueForType, String.format("@InRange.min=%d is out of range: %s", inRange.min(), type.getType()));
                    minValue = inRange.min();
                }
                if (inRange.max() == Long.MAX_VALUE) continue;
                Preconditions.require(inRange.max() <= defaultMaxValueForType, String.format("@InRange.max=%d is out of range: %s", inRange.max(), type.getType()));
                maxValue = inRange.max();
            }
            Preconditions.require(minValue <= maxValue, String.format("[%d, %d] is not a valid interval: %s", minValue, maxValue, type));
            Preconditions.require(minValue != maxValue, String.format("[%d, %d] can not be mutated, use a constant instead: %s", minValue, maxValue, type));
            this.minValue = minValue;
            this.maxValue = maxValue;
            if (minValue >= 0L) {
                this.largestMutableBitNegative = 0;
                this.largestMutableBitPositive = AbstractIntegralMutator.bitWidth(minValue ^ maxValue);
            } else if (maxValue < 0L) {
                this.largestMutableBitNegative = AbstractIntegralMutator.bitWidth(minValue ^ maxValue);
                this.largestMutableBitPositive = 0;
            } else {
                this.largestMutableBitNegative = AbstractIntegralMutator.bitWidth(minValue ^ 0xFFFFFFFFFFFFFFFFL);
                this.largestMutableBitPositive = AbstractIntegralMutator.bitWidth(maxValue);
            }
            this.specialValues = AbstractIntegralMutator.collectSpecialValues(minValue, maxValue);
        }

        private static long[] collectSpecialValues(long minValue, long maxValue) {
            return LongStream.of(0L, 1L, minValue, maxValue).filter(value -> value >= minValue).filter(value -> value <= maxValue).distinct().sorted().toArray();
        }

        private static int bitWidth(long value) {
            return 64 - Long.numberOfLeadingZeros(value);
        }

        protected final long initImpl(PseudoRandom prng) {
            int sentinel = this.specialValues.length;
            int choice = prng.closedRange(0, sentinel);
            if (choice < sentinel) {
                return this.specialValues[choice];
            }
            return prng.closedRange(this.minValue, this.maxValue);
        }

        protected final long mutateImpl(long value, PseudoRandom prng) {
            long previousValue = value;
            do {
                switch (prng.indexIn(4)) {
                    case 0: {
                        value = this.bitFlip(value, prng);
                        break;
                    }
                    case 1: {
                        value = this.randomWalk(value, prng);
                        break;
                    }
                    case 2: {
                        value = prng.closedRange(this.minValue, this.maxValue);
                        break;
                    }
                    case 3: {
                        value = this.forceInRange(this.mutateWithLibFuzzer(value));
                    }
                }
            } while (value == previousValue);
            return value;
        }

        protected final long crossOverImpl(long x, long y, PseudoRandom prng) {
            switch (prng.indexIn(3)) {
                case 0: {
                    return AbstractIntegralMutator.mean(x, y);
                }
                case 1: {
                    return this.forceInRange(x ^ y);
                }
                case 2: {
                    return this.bitmask(x, y, prng);
                }
            }
            throw new AssertionError((Object)"Invalid cross over function.");
        }

        private long bitmask(long x, long y, PseudoRandom prng) {
            long mask = prng.nextLong();
            return this.forceInRange(x & mask | y & (mask ^ 0xFFFFFFFFFFFFFFFFL));
        }

        private static long mean(long x, long y) {
            long xor = x ^ y;
            long mean = (x & y) + (xor >> 1);
            return mean + (1L & xor & mean >>> 31);
        }

        @ForOverride
        protected abstract long mutateWithLibFuzzer(long var1);

        protected final long forceInRange(long value) {
            if (value >= this.minValue && value <= this.maxValue) {
                return value;
            }
            return AbstractIntegralMutator.forceInRange(value, this.minValue, this.maxValue);
        }

        static long forceInRange(long value, long minValue, long maxValue) {
            long range = maxValue - minValue + 1L;
            if (range > 0L) {
                return minValue + Math.abs((value - minValue) % range);
            }
            if (value >= minValue && value <= maxValue) {
                return value;
            }
            return value + range;
        }

        private long bitFlip(long value, PseudoRandom prng) {
            int range;
            int n = range = value >= 0L ? this.largestMutableBitPositive : this.largestMutableBitNegative;
            if ((value ^= 1L << prng.indexIn(range)) > this.maxValue || value < this.minValue) {
                value = prng.closedRange(this.minValue, this.maxValue);
            }
            return value;
        }

        private long randomWalk(long value, PseudoRandom prng) {
            if (this.maxValue / 2L - this.minValue / 2L <= 5L) {
                value = prng.closedRange(this.minValue, this.maxValue);
            } else {
                long upper;
                long lower = this.minValue;
                if (value > lower + 5L) {
                    lower = value - 5L;
                }
                if (value < (upper = this.maxValue) - 5L) {
                    upper = value + 5L;
                }
                value = prng.closedRange(lower, upper);
            }
            return value;
        }

        @Override
        public boolean hasFixedSize() {
            return true;
        }

        @Override
        public T detach(T value) {
            return value;
        }

        @Override
        public String toDebugString(Predicate<Debuggable> isInCycle) {
            return ((Class)((ParameterizedType)this.getClass().getGenericSuperclass()).getActualTypeArguments()[0]).getSimpleName();
        }
    }
}

