/*
 * Decompiled with CFR 0.152.
 */
package com.code_intelligence.jazzer.mutation.mutator.time;

import com.code_intelligence.jazzer.mutation.api.ExtendedMutatorFactory;
import com.code_intelligence.jazzer.mutation.api.MutatorFactory;
import com.code_intelligence.jazzer.mutation.api.SerializingMutator;
import com.code_intelligence.jazzer.mutation.combinator.MutatorCombinators;
import com.code_intelligence.jazzer.mutation.support.TypeHolder;
import com.code_intelligence.jazzer.mutation.support.TypeSupport;
import java.lang.reflect.AnnotatedType;
import java.time.LocalTime;
import java.util.Optional;

final class LocalTimeMutatorFactory
implements MutatorFactory {
    private static final AnnotatedType INNER_LONG_TYPE = TypeSupport.notNull(new TypeHolder<Long>(){}.annotatedType());

    LocalTimeMutatorFactory() {
    }

    @Override
    public Optional<SerializingMutator<?>> tryCreate(AnnotatedType type, ExtendedMutatorFactory factory) {
        return TypeSupport.asSubclassOrEmpty(type, LocalTime.class).flatMap(parent -> factory.tryCreate(INNER_LONG_TYPE)).map(longMutator -> MutatorCombinators.mutateThenMap(longMutator, LocalTimeMutatorFactory::toLocalTime, LocalTimeMutatorFactory::fromLocalTime, inCycle -> "LocalTime"));
    }

    public static LocalTime toLocalTime(long secondsOfDay) {
        return LocalTime.ofSecondOfDay(secondsOfDay);
    }

    public static long fromLocalTime(LocalTime localTime) {
        return localTime.toSecondOfDay();
    }
}

