/*
 * Decompiled with CFR 0.152.
 */
package com.code_intelligence.jazzer.mutation.mutator.time;

import com.code_intelligence.jazzer.mutation.api.ExtendedMutatorFactory;
import com.code_intelligence.jazzer.mutation.api.MutatorFactory;
import com.code_intelligence.jazzer.mutation.api.SerializingMutator;
import com.code_intelligence.jazzer.mutation.combinator.MutatorCombinators;
import com.code_intelligence.jazzer.mutation.support.TypeHolder;
import com.code_intelligence.jazzer.mutation.support.TypeSupport;
import java.lang.reflect.AnnotatedType;
import java.time.Instant;
import java.time.ZoneId;
import java.time.ZonedDateTime;
import java.util.List;
import java.util.Optional;
import java.util.stream.Collectors;

final class ZonedDateTimeMutatorFactory
implements MutatorFactory {
    private static final List<ZoneId> AVAILABLE_ZONE_IDS = ZoneId.getAvailableZoneIds().stream().map(ZoneId::of).collect(Collectors.toList());
    private static final AnnotatedType INNER_LONG_TYPE = TypeSupport.notNull(new TypeHolder<Long>(){}.annotatedType());

    ZonedDateTimeMutatorFactory() {
    }

    @Override
    public Optional<SerializingMutator<?>> tryCreate(AnnotatedType type, ExtendedMutatorFactory factory) {
        return TypeSupport.asSubclassOrEmpty(type, ZonedDateTime.class).flatMap(parent -> factory.tryCreate(INNER_LONG_TYPE)).map(longMutator -> MutatorCombinators.mutateThenMap(longMutator, ZonedDateTimeMutatorFactory::toZonedDateTime, ZonedDateTimeMutatorFactory::fromZonedDateTime, inCycle -> "ZonedDateTime"));
    }

    public static ZonedDateTime toZonedDateTime(long timestamp) {
        ZoneId zoneId = AVAILABLE_ZONE_IDS.get(Math.abs((int)(timestamp % (long)AVAILABLE_ZONE_IDS.size())));
        return ZonedDateTime.ofInstant(Instant.ofEpochMilli(timestamp), zoneId);
    }

    public static long fromZonedDateTime(ZonedDateTime zonedDateTime) {
        return zonedDateTime.toInstant().toEpochMilli();
    }
}

