/*
 * Decompiled with CFR 0.152.
 */
package com.code_intelligence.jazzer.mutation.support;

import java.util.AbstractMap;
import java.util.NoSuchElementException;
import java.util.Optional;
import java.util.function.IntFunction;
import java.util.function.Supplier;
import java.util.stream.Stream;

public final class StreamSupport {
    private StreamSupport() {
    }

    public static <T> Optional<T> findFirstPresent(Stream<Optional<T>> stream) {
        return stream.filter(Optional::isPresent).map(Optional::get).findFirst();
    }

    public static <T> Optional<T> suppliedOrEmpty(Supplier<T> supplier) {
        try {
            return Optional.of(supplier.get());
        }
        catch (Exception e) {
            return Optional.empty();
        }
    }

    public static <T> Optional<T[]> toArrayOrEmpty(Stream<Optional<T>> stream, IntFunction<T[]> newArray) {
        try {
            return Optional.of(stream.map(Optional::get).toArray(newArray));
        }
        catch (NoSuchElementException e) {
            return Optional.empty();
        }
    }

    public static <T> Stream<T> getOrEmpty(Optional<T> optional) {
        return optional.map(Stream::of).orElseGet(Stream::empty);
    }

    public static <K, V> AbstractMap.SimpleEntry<K, V> entry(K key, V value) {
        return new AbstractMap.SimpleEntry<K, V>(key, value);
    }
}

