/*
 * Decompiled with CFR 0.152.
 */
package com.code_intelligence.jazzer.mutation.support;

import com.code_intelligence.jazzer.mutation.annotation.NotNull;
import com.code_intelligence.jazzer.mutation.annotation.WithLength;
import com.code_intelligence.jazzer.mutation.support.AnnotationSupport;
import com.code_intelligence.jazzer.mutation.support.Preconditions;
import com.code_intelligence.jazzer.mutation.support.TypeHolder;
import java.lang.annotation.Annotation;
import java.lang.invoke.LambdaMetafactory;
import java.lang.reflect.AnnotatedArrayType;
import java.lang.reflect.AnnotatedElement;
import java.lang.reflect.AnnotatedParameterizedType;
import java.lang.reflect.AnnotatedType;
import java.lang.reflect.AnnotatedTypeVariable;
import java.lang.reflect.AnnotatedWildcardType;
import java.lang.reflect.Array;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.ParameterizedType;
import java.lang.reflect.Type;
import java.util.ArrayDeque;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashSet;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.Set;
import java.util.function.BiConsumer;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.IntStream;
import java.util.stream.Stream;

public final class TypeSupport {
    public static final Annotation NOT_NULL = new TypeHolder<String>(){}.annotatedType().getAnnotation(NotNull.class);
    private static final Annotation[] EMPTY_ANNOTATIONS = new Annotation[0];

    private TypeSupport() {
    }

    public static boolean isPrimitive(AnnotatedType type) {
        return TypeSupport.isPrimitive(type.getType());
    }

    public static boolean isPrimitive(Type type) {
        if (!(type instanceof Class)) {
            return false;
        }
        return ((Class)type).isPrimitive();
    }

    public static <T> Optional<Class<? extends T>> asSubclassOrEmpty(AnnotatedType annotatedType, Class<T> superclass) {
        Type type = annotatedType.getType();
        if (type instanceof ParameterizedType) {
            type = ((ParameterizedType)type).getRawType();
        }
        if (!(type instanceof Class)) {
            return Optional.empty();
        }
        Class actualClazz = (Class)type;
        if (!superclass.isAssignableFrom(actualClazz)) {
            return Optional.empty();
        }
        return Optional.of(actualClazz.asSubclass(superclass));
    }

    public static void visitAnnotatedType(AnnotatedType type, BiConsumer<Class<?>, Annotation[]> visitor) {
        TypeSupport.visitAnnotatedTypeInternal(type, visitor);
    }

    private static Class<?> visitAnnotatedTypeInternal(AnnotatedType type, BiConsumer<Class<?>, Annotation[]> visitor) {
        Class clazz;
        if (type instanceof AnnotatedWildcardType) {
            throw new IllegalArgumentException("Wildcard types are not supported: " + type);
        }
        if (type instanceof AnnotatedTypeVariable) {
            throw new IllegalArgumentException("Type variables are not supported: " + type);
        }
        if (type instanceof AnnotatedParameterizedType) {
            AnnotatedParameterizedType annotatedParameterizedType = (AnnotatedParameterizedType)type;
            Preconditions.check(annotatedParameterizedType.getType() instanceof ParameterizedType);
            Type rawType = ((ParameterizedType)annotatedParameterizedType.getType()).getRawType();
            Preconditions.check(rawType instanceof Class);
            clazz = (Class)rawType;
            visitor.accept(clazz, type.getDeclaredAnnotations());
            for (AnnotatedType typeArgument : annotatedParameterizedType.getAnnotatedActualTypeArguments()) {
                TypeSupport.visitAnnotatedTypeInternal(typeArgument, visitor);
            }
        } else if (type instanceof AnnotatedArrayType) {
            AnnotatedArrayType arrayType = (AnnotatedArrayType)type;
            Class<?> componentClass = TypeSupport.visitAnnotatedTypeInternal(arrayType.getAnnotatedGenericComponentType(), (c, a) -> {});
            clazz = Array.newInstance(componentClass, 0).getClass();
            visitor.accept(clazz, type.getDeclaredAnnotations());
            TypeSupport.visitAnnotatedTypeInternal(arrayType.getAnnotatedGenericComponentType(), visitor);
        } else {
            Preconditions.check(type.getType() instanceof Class);
            clazz = (Class)type.getType();
            visitor.accept(clazz, type.getDeclaredAnnotations());
        }
        return clazz;
    }

    public static AnnotatedType forwardAnnotations(AnnotatedType src, AnnotatedType target) {
        return TypeSupport.forwardAnnotations(src, target, EMPTY_ANNOTATIONS);
    }

    public static AnnotatedType forwardAnnotations(AnnotatedType src, AnnotatedType target, Annotation ... exclude) {
        Set excluded = Stream.concat(Arrays.stream(target.getAnnotations()), Arrays.stream(exclude)).map(Annotation::annotationType).collect(Collectors.toSet());
        AnnotatedType result = TypeSupport.withExtraAnnotations(target, (Annotation[])Arrays.stream(src.getAnnotations()).filter(annotation -> !excluded.contains(annotation.annotationType())).toArray(Annotation[]::new));
        AnnotationSupport.validateAnnotationUsage(result);
        return result;
    }

    public static AnnotatedType notNull(AnnotatedType type) {
        return TypeSupport.withExtraAnnotations(type, NOT_NULL);
    }

    public static AnnotatedType withLength(AnnotatedType type, int min, int max) {
        WithLength withLength = TypeSupport.withLengthImplementation(min, max);
        return TypeSupport.withExtraAnnotations(type, withLength);
    }

    private static WithLength withLengthImplementation(final int min, final int max) {
        return new WithLength(){

            @Override
            public int min() {
                return min;
            }

            @Override
            public int max() {
                return max;
            }

            @Override
            public String constraint() {
                return "JAZZER_PROPERTY_CONSTRAINT_DECLARATION";
            }

            @Override
            public Class<? extends Annotation> annotationType() {
                return WithLength.class;
            }

            @Override
            public boolean equals(Object o) {
                if (!(o instanceof WithLength)) {
                    return false;
                }
                WithLength other = (WithLength)o;
                return this.min() == other.min() && this.max() == other.max();
            }

            @Override
            public int hashCode() {
                int hash = 0;
                hash += "min".hashCode() * 127 ^ Integer.valueOf(this.min()).hashCode();
                return hash += "max".hashCode() * 127 ^ Integer.valueOf(this.max()).hashCode();
            }

            @Override
            public String toString() {
                return "@" + WithLength.class.getName() + "{min=" + this.min() + ", max=" + this.max() + ", constraint=" + this.constraint() + "}";
            }
        };
    }

    public static AnnotatedParameterizedType withTypeArguments(final AnnotatedType type, final AnnotatedType ... typeArguments) {
        Objects.requireNonNull(type);
        Preconditions.requireNonNullElements(typeArguments);
        Preconditions.require(typeArguments.length > 0);
        Preconditions.require(!(type instanceof AnnotatedParameterizedType) && !(type instanceof AnnotatedTypeVariable) && !(type instanceof AnnotatedWildcardType) && !(type instanceof AnnotatedArrayType), "only plain annotated types are supported");
        Preconditions.require(((Class)type.getType()).getEnclosingClass() == null, "nested classes aren't supported");
        final ParameterizedType filledRawType = new ParameterizedType(){

            @Override
            public Type[] getActualTypeArguments() {
                return (Type[])Arrays.stream(typeArguments).map(AnnotatedType::getType).toArray(Type[]::new);
            }

            @Override
            public Type getRawType() {
                return type.getType();
            }

            @Override
            public Type getOwnerType() {
                return null;
            }

            public String toString() {
                return this.getRawType() + Arrays.stream(this.getActualTypeArguments()).map((Function<Type, String>)LambdaMetafactory.metafactory(null, null, null, (Ljava/lang/Object;)Ljava/lang/Object;, toString(), (Ljava/lang/reflect/Type;)Ljava/lang/String;)()).collect(Collectors.joining(",", "<", ">"));
            }

            public boolean equals(Object obj) {
                if (!(obj instanceof ParameterizedType)) {
                    return false;
                }
                ParameterizedType other = (ParameterizedType)obj;
                return this.getRawType().equals(other.getRawType()) && null == other.getOwnerType() && Arrays.equals(this.getActualTypeArguments(), other.getActualTypeArguments());
            }

            public int hashCode() {
                throw new UnsupportedOperationException("hashCode() is not supported as its behavior isn't specified");
            }
        };
        return new AnnotatedParameterizedType(){

            @Override
            public AnnotatedType[] getAnnotatedActualTypeArguments() {
                return Arrays.copyOf(typeArguments, typeArguments.length);
            }

            @Override
            public AnnotatedType getAnnotatedOwnerType() {
                return null;
            }

            @Override
            public Type getType() {
                return filledRawType;
            }

            @Override
            public <T extends Annotation> T getAnnotation(Class<T> annotationClass) {
                return type.getAnnotation(annotationClass);
            }

            @Override
            public Annotation[] getAnnotations() {
                return type.getAnnotations();
            }

            @Override
            public Annotation[] getDeclaredAnnotations() {
                return type.getDeclaredAnnotations();
            }

            public String toString() {
                return TypeSupport.annotatedTypeToString(this);
            }

            public boolean equals(Object other) {
                if (other instanceof AnnotatedType) {
                    return TypeSupport.annotatedTypeEquals(this, (AnnotatedType)other);
                }
                return false;
            }

            public int hashCode() {
                throw new UnsupportedOperationException("hashCode() is not supported as its behavior isn't specified");
            }
        };
    }

    public static AnnotatedType withExtraAnnotations(AnnotatedType base, Annotation ... extraAnnotations) {
        Objects.requireNonNull(base);
        Preconditions.requireNonNullElements(extraAnnotations);
        if (extraAnnotations.length == 0) {
            return base;
        }
        Preconditions.require(!(base instanceof AnnotatedTypeVariable) && !(base instanceof AnnotatedWildcardType), "Adding annotations to AnnotatedTypeVariables or AnnotatedWildcardTypes is not supported");
        if (base instanceof AnnotatedArrayType) {
            return new AugmentedArrayType((AnnotatedArrayType)base, extraAnnotations);
        }
        if (base instanceof AnnotatedParameterizedType) {
            return new AugmentedParameterizedType((AnnotatedParameterizedType)base, extraAnnotations);
        }
        return new AugmentedAnnotatedType(base, extraAnnotations);
    }

    private static String annotatedTypeToString(AnnotatedType annotatedType) {
        String annotations = Arrays.stream(annotatedType.getAnnotations()).map(Annotation::toString).collect(Collectors.joining(" "));
        if (annotations.isEmpty()) {
            return annotatedType.getType().toString();
        }
        return annotations + " " + annotatedType.getType();
    }

    private static <T extends Annotation> T annotatedElementGetAnnotation(AnnotatedElement element, Class<T> annotationClass) {
        Objects.requireNonNull(annotationClass);
        return (T)((Annotation)Arrays.stream(element.getAnnotations()).filter(annotation -> annotationClass.equals(annotation.annotationType())).findFirst().map(annotationClass::cast).orElse(null));
    }

    public static Optional<Class<?>> findFirstParentIfClass(AnnotatedType type, Class<?> ... parents) {
        if (!(type.getType() instanceof Class)) {
            return Optional.empty();
        }
        Class clazz = (Class)type.getType();
        return Stream.of(parents).filter(parent -> parent.isAssignableFrom(clazz)).findFirst();
    }

    public static Optional<AnnotatedType> parameterTypeIfParameterized(AnnotatedType type, Class<?> expectedParent) {
        return TypeSupport.parameterTypesIfParameterized(type, expectedParent).flatMap(typeArguments -> {
            if (typeArguments.size() != 1) {
                return Optional.empty();
            }
            AnnotatedType elementType = (AnnotatedType)typeArguments.get(0);
            if (!(elementType.getType() instanceof ParameterizedType) && !(elementType.getType() instanceof Class)) {
                return Optional.empty();
            }
            return Optional.of(elementType);
        });
    }

    public static Optional<List<AnnotatedType>> parameterTypesIfParameterized(AnnotatedType type, Class<?> expectedParent) {
        if (!(type instanceof AnnotatedParameterizedType)) {
            return Optional.empty();
        }
        Class clazz = (Class)((ParameterizedType)type.getType()).getRawType();
        if (!expectedParent.isAssignableFrom(clazz)) {
            return Optional.empty();
        }
        AnnotatedType[] typeArguments = ((AnnotatedParameterizedType)type).getAnnotatedActualTypeArguments();
        if (typeArguments.length == 0) {
            return Optional.empty();
        }
        return Optional.of(Collections.unmodifiableList(Arrays.asList(typeArguments)));
    }

    public static <T> boolean containedInDirectedCycle(T root, Function<T, Stream<T>> successors) {
        Object currentNode;
        HashSet traversed = new HashSet();
        ArrayDeque<T> toTraverse = new ArrayDeque<T>();
        toTraverse.addLast(root);
        while ((currentNode = toTraverse.pollLast()) != null) {
            if (traversed.add(currentNode)) {
                successors.apply(currentNode).forEachOrdered(toTraverse::addLast);
                continue;
            }
            if (!currentNode.equals(root)) continue;
            return true;
        }
        return false;
    }

    public static boolean annotatedTypeEquals(AnnotatedType left, AnnotatedType right) {
        if (left instanceof AnnotatedParameterizedType) {
            AnnotatedType[] rightTypeArguments;
            if (!(right instanceof AnnotatedParameterizedType)) {
                return false;
            }
            AnnotatedType[] leftTypeArguments = ((AnnotatedParameterizedType)left).getAnnotatedActualTypeArguments();
            if (leftTypeArguments.length != (rightTypeArguments = ((AnnotatedParameterizedType)right).getAnnotatedActualTypeArguments()).length || !IntStream.range(0, leftTypeArguments.length).allMatch(i -> TypeSupport.annotatedTypeEquals(leftTypeArguments[i], rightTypeArguments[i]))) {
                return false;
            }
        } else if (left instanceof AnnotatedArrayType) {
            if (!(right instanceof AnnotatedArrayType)) {
                return false;
            }
            if (!TypeSupport.annotatedTypeEquals(((AnnotatedArrayType)left).getAnnotatedGenericComponentType(), ((AnnotatedArrayType)right).getAnnotatedGenericComponentType())) {
                return false;
            }
        } else {
            if (left instanceof AnnotatedWildcardType || left instanceof AnnotatedTypeVariable) {
                throw new UnsupportedOperationException("AnnotatedWildcardType and AnnotatedTypeVariable are not supported");
            }
            if (right instanceof AnnotatedArrayType || right instanceof AnnotatedParameterizedType || right instanceof AnnotatedTypeVariable || right instanceof AnnotatedWildcardType) {
                return false;
            }
        }
        return left.getType().equals(right.getType()) && Arrays.equals(left.getAnnotations(), right.getAnnotations());
    }

    private static class AugmentedArrayType
    extends AugmentedAnnotatedType
    implements AnnotatedArrayType {
        private AugmentedArrayType(AnnotatedArrayType base, Annotation[] extraAnnotations) {
            super(base, extraAnnotations);
        }

        @Override
        public AnnotatedType getAnnotatedGenericComponentType() {
            return ((AnnotatedArrayType)this.base).getAnnotatedGenericComponentType();
        }
    }

    private static class AugmentedParameterizedType
    extends AugmentedAnnotatedType
    implements AnnotatedParameterizedType {
        private AugmentedParameterizedType(AnnotatedParameterizedType base, Annotation[] extraAnnotations) {
            super(base, extraAnnotations);
        }

        @Override
        public AnnotatedType[] getAnnotatedActualTypeArguments() {
            return ((AnnotatedParameterizedType)this.base).getAnnotatedActualTypeArguments();
        }
    }

    private static class AugmentedAnnotatedType
    implements AnnotatedType {
        protected final AnnotatedType base;
        private final Annotation[] extraAnnotations;

        private AugmentedAnnotatedType(AnnotatedType base, Annotation[] extraAnnotations) {
            this.base = Objects.requireNonNull(base);
            this.extraAnnotations = AugmentedAnnotatedType.checkExtraAnnotations(base, extraAnnotations);
        }

        private static Annotation[] checkExtraAnnotations(AnnotatedElement base, Annotation[] extraAnnotations) {
            Preconditions.requireNonNullElements(extraAnnotations);
            Set existingAnnotationTypes = Arrays.stream(base.getDeclaredAnnotations()).map(Annotation::annotationType).collect(Collectors.toCollection(HashSet::new));
            for (Annotation annotation : extraAnnotations) {
                boolean added = existingAnnotationTypes.add(annotation.annotationType());
                Preconditions.require(added, annotation + " already directly present on " + base);
            }
            return extraAnnotations;
        }

        @Override
        public Type getType() {
            return this.base.getType();
        }

        @Override
        public <T extends Annotation> T getAnnotation(Class<T> annotationClass) {
            return (T)TypeSupport.annotatedElementGetAnnotation(this, annotationClass);
        }

        @Override
        public Annotation[] getAnnotations() {
            Set directlyPresentTypes = Arrays.stream(this.getDeclaredAnnotations()).map(Annotation::annotationType).collect(Collectors.toSet());
            return (Annotation[])Stream.concat(Arrays.stream(this.getDeclaredAnnotations()), Arrays.stream(this.base.getAnnotations()).filter(annotation -> !directlyPresentTypes.contains(annotation.annotationType()))).toArray(Annotation[]::new);
        }

        @Override
        public Annotation[] getDeclaredAnnotations() {
            return (Annotation[])Stream.concat(Arrays.stream(this.base.getDeclaredAnnotations()), Arrays.stream(this.extraAnnotations)).toArray(Annotation[]::new);
        }

        public String toString() {
            return TypeSupport.annotatedTypeToString(this);
        }

        public boolean equals(Object other) {
            if (other instanceof AnnotatedType) {
                return TypeSupport.annotatedTypeEquals(this, (AnnotatedType)other);
            }
            return false;
        }

        public int hashCode() {
            throw new UnsupportedOperationException("hashCode() is not supported as its behavior isn't specified");
        }

        @Override
        public AnnotatedType getAnnotatedOwnerType() {
            try {
                return (AnnotatedType)AnnotatedType.class.getMethod("getAnnotatedOwnerType", new Class[0]).invoke((Object)this.base, new Object[0]);
            }
            catch (IllegalAccessException | NoSuchMethodException | InvocationTargetException e) {
                throw new IllegalStateException(e);
            }
        }
    }
}

