/*
 * Decompiled with CFR 0.152.
 */
package com.code_intelligence.jazzer.mutation.support;

import java.lang.ref.Reference;
import java.lang.ref.ReferenceQueue;
import java.lang.ref.WeakReference;
import java.util.AbstractMap;
import java.util.Collection;
import java.util.HashMap;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import java.util.stream.Collectors;

public final class WeakIdentityHashMap<K, V>
implements Map<K, V> {
    private final HashMap<WeakReference<K>, V> map = new HashMap();
    private final ReferenceQueue<K> weaklyReachables = new ReferenceQueue();

    @Override
    public int size() {
        this.removeNewWeaklyReachables();
        return this.map.size();
    }

    @Override
    public boolean isEmpty() {
        this.removeNewWeaklyReachables();
        return this.map.isEmpty();
    }

    @Override
    public boolean containsKey(Object key) {
        this.removeNewWeaklyReachables();
        return this.map.containsKey(new IdentityWeakReference<Object>(key));
    }

    @Override
    public boolean containsValue(Object value) {
        this.removeNewWeaklyReachables();
        return this.map.containsValue(value);
    }

    @Override
    public V get(Object key) {
        this.removeNewWeaklyReachables();
        return this.map.get(new IdentityWeakReference<Object>(key));
    }

    @Override
    public V put(K key, V value) {
        this.removeNewWeaklyReachables();
        return this.map.put(new IdentityWeakReference<K>(key, this.weaklyReachables), value);
    }

    @Override
    public V remove(Object key) {
        this.removeNewWeaklyReachables();
        return this.map.remove(new IdentityWeakReference<Object>(key));
    }

    @Override
    public void putAll(Map<? extends K, ? extends V> otherMap) {
        this.removeNewWeaklyReachables();
        for (Map.Entry<K, V> entry : otherMap.entrySet()) {
            this.map.put(new IdentityWeakReference<K>(entry.getKey(), this.weaklyReachables), entry.getValue());
        }
    }

    @Override
    public void clear() {
        this.map.clear();
    }

    @Override
    public Set<K> keySet() {
        this.removeNewWeaklyReachables();
        return this.map.keySet().stream().map(Reference::get).filter(Objects::nonNull).collect(Collectors.toSet());
    }

    @Override
    public Collection<V> values() {
        this.removeNewWeaklyReachables();
        return this.map.values();
    }

    @Override
    public Set<Map.Entry<K, V>> entrySet() {
        this.removeNewWeaklyReachables();
        return this.map.entrySet().stream().map(e -> new AbstractMap.SimpleEntry(((WeakReference)e.getKey()).get(), e.getValue())).filter(e -> e.getKey() != null).collect(Collectors.toSet());
    }

    void collectKeysForTesting() {
        this.map.keySet().forEach((? super T ref) -> {
            ref.clear();
            ref.enqueue();
        });
    }

    private void removeNewWeaklyReachables() {
        Reference<K> referent;
        while ((referent = this.weaklyReachables.poll()) != null) {
            this.map.remove(referent);
        }
    }

    private static final class IdentityWeakReference<T>
    extends WeakReference<T> {
        private final int referentHashCode;

        public IdentityWeakReference(T referent) {
            super(referent);
            this.referentHashCode = System.identityHashCode(referent);
        }

        public IdentityWeakReference(T referent, ReferenceQueue<? super T> queue) {
            super(referent, queue);
            this.referentHashCode = System.identityHashCode(referent);
        }

        public boolean equals(Object other) {
            if (this == other) {
                return true;
            }
            if (!(other instanceof WeakReference)) {
                return false;
            }
            Object referent = this.get();
            if (referent == null) {
                return false;
            }
            return referent == ((WeakReference)other).get();
        }

        public int hashCode() {
            return this.referentHashCode;
        }
    }
}

