/*
 * Decompiled with CFR 0.152.
 */
package com.code_intelligence.jazzer.driver;

import com.code_intelligence.jazzer.driver.Opt;
import com.code_intelligence.jazzer.utils.Log;
import java.io.BufferedReader;
import java.io.IOException;
import java.io.InputStreamReader;
import java.nio.charset.StandardCharsets;
import java.nio.file.Files;
import java.nio.file.OpenOption;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.util.ArrayList;
import java.util.stream.Collectors;

final class ReproducerTemplate {
    private static final int DATA_CHUNK_MAX_LENGTH = 32766;
    private static final String RAW_BYTES_INPUT = "byte[] input = java.util.Base64.getDecoder().decode(base64Bytes);";
    private static final String FUZZED_DATA_PROVIDER_INPUT = "com.code_intelligence.jazzer.api.CannedFuzzedDataProvider input = new com.code_intelligence.jazzer.api.CannedFuzzedDataProvider(base64Bytes);";
    private final String targetClass;
    private final boolean useFuzzedDataProvider;

    public ReproducerTemplate(String targetClass, boolean useFuzzedDataProvider) {
        this.targetClass = targetClass;
        this.useFuzzedDataProvider = useFuzzedDataProvider;
    }

    public void dumpReproducer(String data, String sha) {
        String targetArg = this.useFuzzedDataProvider ? FUZZED_DATA_PROVIDER_INPUT : RAW_BYTES_INPUT;
        String template = new BufferedReader(new InputStreamReader(ReproducerTemplate.class.getResourceAsStream("Reproducer.java.tmpl"), StandardCharsets.UTF_8)).lines().collect(Collectors.joining("\n"));
        String chunkedData = this.chunkStringLiteral(data);
        String javaSource = String.format(template, sha, chunkedData, this.targetClass, targetArg);
        Path javaPath = Paths.get(Opt.reproducerPath.get(), String.format("Crash_%s.java", sha));
        try {
            Files.write(javaPath, javaSource.getBytes(StandardCharsets.UTF_8), new OpenOption[0]);
        }
        catch (IOException e) {
            Log.error(String.format("Failed to write Java reproducer to %s%n", javaPath));
            e.printStackTrace();
        }
        Log.println(String.format("reproducer_path='%s'; Java reproducer written to %s%n", Opt.reproducerPath.get(), javaPath));
    }

    private String chunkStringLiteral(String data) {
        ArrayList<String> chunks = new ArrayList<String>();
        for (int i = 0; i <= data.length() / 32766; ++i) {
            chunks.add(data.substring(i * 32766, Math.min((i + 1) * 32766, data.length())));
        }
        return String.join((CharSequence)"\", \"", chunks);
    }
}

