/*
 * Decompiled with CFR 0.152.
 */
package com.code_intelligence.jazzer.mutation;

import com.code_intelligence.jazzer.mutation.api.ExtendedMutatorFactory;
import com.code_intelligence.jazzer.mutation.api.PseudoRandom;
import com.code_intelligence.jazzer.mutation.api.SerializingMutator;
import com.code_intelligence.jazzer.mutation.combinator.InPlaceProductMutator;
import com.code_intelligence.jazzer.mutation.combinator.MutatorCombinators;
import com.code_intelligence.jazzer.mutation.engine.SeededPseudoRandom;
import com.code_intelligence.jazzer.mutation.mutator.Mutators;
import com.code_intelligence.jazzer.mutation.support.AnnotationSupport;
import com.code_intelligence.jazzer.mutation.support.Preconditions;
import com.code_intelligence.jazzer.mutation.support.StreamSupport;
import com.code_intelligence.jazzer.utils.Log;
import java.io.ByteArrayInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.io.UncheckedIOException;
import java.lang.reflect.AnnotatedType;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.util.Arrays;
import java.util.Optional;
import java.util.stream.Collectors;

public final class ArgumentsMutator {
    private final ExtendedMutatorFactory mutatorFactory;
    private final Method method;
    private final InPlaceProductMutator productMutator;
    private Object[] arguments;
    private boolean argumentsExposed;

    private ArgumentsMutator(ExtendedMutatorFactory mutatorFactory, Method method, InPlaceProductMutator productMutator) {
        this.mutatorFactory = mutatorFactory;
        this.method = method;
        this.productMutator = productMutator;
    }

    private static String prettyPrintMethod(Method method) {
        return String.format("%s.%s(%s)", method.getDeclaringClass().getName(), method.getName(), Arrays.stream(method.getAnnotatedParameterTypes()).map(Object::toString).collect(Collectors.joining(", ")));
    }

    public static ArgumentsMutator forMethodOrThrow(Method method) {
        return ArgumentsMutator.forMethod(Mutators.newFactory(), method).orElseThrow(() -> new IllegalArgumentException("Failed to construct mutator for " + ArgumentsMutator.prettyPrintMethod(method)));
    }

    public static Optional<ArgumentsMutator> forMethod(Method method) {
        return ArgumentsMutator.forMethod(Mutators.newFactory(), method);
    }

    public static Optional<ArgumentsMutator> forMethod(ExtendedMutatorFactory mutatorFactory, Method method) {
        Preconditions.require(method.getParameterCount() > 0, "Can't fuzz method without parameters: " + method);
        try {
            for (AnnotatedType parameter : method.getAnnotatedParameterTypes()) {
                AnnotationSupport.validateAnnotationUsage(parameter);
            }
        }
        catch (RuntimeException validationError) {
            Log.error(validationError.getMessage());
            throw validationError;
        }
        return StreamSupport.toArrayOrEmpty(Arrays.stream(method.getAnnotatedParameterTypes()).map(type -> {
            Optional<SerializingMutator<?>> mutator = mutatorFactory.tryCreate((AnnotatedType)type);
            if (!mutator.isPresent()) {
                Log.error(String.format("Unsupported fuzz test parameter type %s in %s", type.getType().getTypeName(), ArgumentsMutator.prettyPrintMethod(method)));
            }
            return mutator;
        }), SerializingMutator[]::new).map(MutatorCombinators::mutateProductInPlace).map(productMutator -> ArgumentsMutator.create(mutatorFactory, method, productMutator));
    }

    private static ArgumentsMutator create(ExtendedMutatorFactory mutatorFactory, Method method, InPlaceProductMutator productMutator) {
        method.setAccessible(true);
        return new ArgumentsMutator(mutatorFactory, method, productMutator);
    }

    public void crossOver(InputStream data1, InputStream data2, long seed) {
        try {
            Object[] objects1 = this.productMutator.readExclusive(data1);
            Object[] objects2 = this.productMutator.readExclusive(data2);
            SeededPseudoRandom prng = new SeededPseudoRandom(seed);
            this.arguments = this.productMutator.crossOver(objects1, objects2, prng);
            this.argumentsExposed = false;
        }
        catch (IOException e) {
            throw new UncheckedIOException(e);
        }
    }

    public void read(ByteArrayInputStream data) {
        try {
            this.arguments = this.productMutator.readExclusive(data);
            this.argumentsExposed = false;
        }
        catch (IOException e) {
            throw new UncheckedIOException(e);
        }
    }

    public void write(OutputStream data) {
        this.failIfArgumentsExposed();
        this.writeAny(data, this.arguments);
    }

    public void writeAny(OutputStream data, Object[] args2) throws UncheckedIOException {
        try {
            this.productMutator.writeExclusive(args2, data);
        }
        catch (IOException e) {
            throw new UncheckedIOException(e);
        }
    }

    public void init(long seed) {
        this.init(new SeededPseudoRandom(seed));
    }

    void init(PseudoRandom prng) {
        this.arguments = (Object[])this.productMutator.init(prng);
        this.argumentsExposed = false;
    }

    public void mutate(long seed) {
        this.mutate(new SeededPseudoRandom(seed));
    }

    void mutate(PseudoRandom prng) {
        this.failIfArgumentsExposed();
        this.productMutator.mutateInPlace(this.arguments, prng);
    }

    public void invoke(Object instance, boolean detach) throws Throwable {
        Object[] invokeArguments;
        if (detach) {
            invokeArguments = this.productMutator.detach(this.arguments);
        } else {
            invokeArguments = this.arguments;
            this.argumentsExposed = true;
        }
        try {
            this.method.invoke(instance, invokeArguments);
        }
        catch (IllegalAccessException e) {
            throw new IllegalStateException("method should have been made accessible", e);
        }
        catch (InvocationTargetException e) {
            throw e.getCause();
        }
    }

    public Object[] getArguments() {
        this.argumentsExposed = true;
        return this.arguments;
    }

    public void finishFuzzingIteration() {
        this.mutatorFactory.getCache().clear();
    }

    public String toString() {
        return "Arguments" + this.productMutator;
    }

    private void failIfArgumentsExposed() {
        Preconditions.check(!this.argumentsExposed, "Arguments have previously been exposed to user-provided code without calling #detach and may have been modified");
    }
}

