/*
 * Decompiled with CFR 0.152.
 */
package com.code_intelligence.jazzer.mutation.api;

import com.code_intelligence.jazzer.mutation.api.Cache;
import com.code_intelligence.jazzer.mutation.api.InPlaceMutator;
import com.code_intelligence.jazzer.mutation.api.MutatorFactory;
import com.code_intelligence.jazzer.mutation.api.SerializingInPlaceMutator;
import com.code_intelligence.jazzer.mutation.api.SerializingMutator;
import com.code_intelligence.jazzer.mutation.support.Preconditions;
import com.google.errorprone.annotations.CheckReturnValue;
import java.lang.reflect.AnnotatedType;
import java.util.Optional;

public abstract class ExtendedMutatorFactory
implements MutatorFactory {
    public final Cache cache;

    public ExtendedMutatorFactory(Cache cache) {
        this.cache = cache;
    }

    public Cache getCache() {
        return this.cache;
    }

    public final SerializingMutator<?> createOrThrow(AnnotatedType type) {
        Optional<SerializingMutator<?>> maybeMutator = this.tryCreate(type);
        Preconditions.require(maybeMutator.isPresent(), "Failed to create mutator for " + type);
        return maybeMutator.get();
    }

    public final SerializingInPlaceMutator<?> createInPlaceOrThrow(AnnotatedType type) {
        Optional<SerializingInPlaceMutator<?>> maybeMutator = this.tryCreateInPlace(type);
        Preconditions.require(maybeMutator.isPresent(), "Failed to create mutator for " + type);
        return maybeMutator.get();
    }

    public final Optional<SerializingInPlaceMutator<?>> tryCreateInPlace(AnnotatedType type) {
        return this.tryCreate(type).map(mutator -> {
            Preconditions.require(mutator instanceof InPlaceMutator, String.format("Mutator for %s is not in-place: %s", type, mutator.getClass()));
            return (SerializingInPlaceMutator)mutator;
        });
    }

    @CheckReturnValue
    public final Optional<SerializingMutator<?>> tryCreate(AnnotatedType type) {
        return this.tryCreate(type, this);
    }

    public abstract void internMutator(SerializingMutator<?> var1);
}

