/*
 * Decompiled with CFR 0.152.
 */
package com.code_intelligence.jazzer.mutation.combinator;

import com.code_intelligence.jazzer.mutation.api.Debuggable;
import com.code_intelligence.jazzer.mutation.api.PseudoRandom;
import com.code_intelligence.jazzer.mutation.api.SerializingMutator;
import com.code_intelligence.jazzer.third_party.net.jodah.typetools.TypeResolver;
import java.io.DataInputStream;
import java.io.DataOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.util.Objects;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.function.Predicate;
import java.util.function.Supplier;

abstract class PostComposedMutator<T, R>
extends SerializingMutator<R> {
    protected final SerializingMutator<T> mutator;
    private final Function<T, R> map;
    private final Function<R, T> inverse;

    PostComposedMutator(SerializingMutator<T> mutator, Function<T, R> map, Function<R, T> inverse) {
        this(() -> mutator, map, inverse, self -> {});
    }

    PostComposedMutator(Supplier<SerializingMutator<T>> mutator, Function<T, R> map, Function<R, T> inverse, Consumer<SerializingMutator<R>> registerSelf) {
        registerSelf.accept(this);
        this.mutator = Objects.requireNonNull(mutator).get();
        this.map = Objects.requireNonNull(map);
        this.inverse = Objects.requireNonNull(inverse);
    }

    @Override
    public R detach(R value) {
        return this.map.apply(this.mutator.detach(this.inverse.apply(value)));
    }

    @Override
    public final R init(PseudoRandom prng) {
        return this.map.apply(this.mutator.init(prng));
    }

    @Override
    public final R mutate(R value, PseudoRandom prng) {
        return this.map.apply(this.mutator.mutate(this.inverse.apply(value), prng));
    }

    @Override
    public R crossOver(R value, R otherValue, PseudoRandom prng) {
        return this.map.apply(this.mutator.crossOver(this.inverse.apply(value), this.inverse.apply(otherValue), prng));
    }

    @Override
    protected boolean computeHasFixedSize() {
        return this.mutator.hasFixedSize();
    }

    @Override
    public final R read(DataInputStream in) throws IOException {
        return this.map.apply(this.mutator.read(in));
    }

    @Override
    public final void write(R value, DataOutputStream out) throws IOException {
        this.mutator.write(this.inverse.apply(value), out);
    }

    @Override
    public final R readExclusive(InputStream in) throws IOException {
        return this.map.apply(this.mutator.readExclusive(in));
    }

    @Override
    public final void writeExclusive(R value, OutputStream out) throws IOException {
        this.mutator.writeExclusive(this.inverse.apply(value), out);
    }

    @Override
    public String toDebugString(Predicate<Debuggable> isInCycle) {
        Class<?> returnType = TypeResolver.resolveRawArguments(Function.class, this.map.getClass())[1];
        return this.mutator.toDebugString(isInCycle) + " -> " + returnType.getSimpleName();
    }
}

