/*
 * Decompiled with CFR 0.152.
 */
package com.code_intelligence.jazzer.mutation.combinator;

import com.code_intelligence.jazzer.mutation.api.Debuggable;
import com.code_intelligence.jazzer.mutation.api.PseudoRandom;
import com.code_intelligence.jazzer.mutation.api.SerializingMutator;
import com.code_intelligence.jazzer.mutation.combinator.InPlaceProductMutator;
import java.io.DataInputStream;
import java.io.DataOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.util.function.Predicate;

public final class ProductMutator
extends SerializingMutator<Object[]> {
    private final InPlaceProductMutator mutator;
    private final int length;

    ProductMutator(SerializingMutator[] mutators) {
        this.mutator = new InPlaceProductMutator(mutators);
        this.length = mutators.length;
    }

    @Override
    public Object[] read(DataInputStream in) throws IOException {
        return this.mutator.read(in);
    }

    @Override
    public Object[] readExclusive(InputStream in) throws IOException {
        return this.mutator.readExclusive(in);
    }

    @Override
    public void write(Object[] value, DataOutputStream out) throws IOException {
        this.mutator.write(value, out);
    }

    @Override
    public void writeExclusive(Object[] value, OutputStream out) throws IOException {
        this.mutator.writeExclusive(value, out);
    }

    @Override
    public Object[] init(PseudoRandom prng) {
        Object[] objects = new Object[this.length];
        this.mutator.initInPlace(objects, prng);
        return objects;
    }

    @Override
    public Object[] mutate(Object[] value, PseudoRandom prng) {
        Object[] references = this.detach(value);
        this.mutator.mutateInPlace(references, prng);
        return references;
    }

    @Override
    public Object[] crossOver(Object[] value, Object[] otherValue, PseudoRandom prng) {
        Object[] references = this.detach(value);
        this.mutator.crossOverInPlace(references, otherValue, prng);
        return references;
    }

    @Override
    protected boolean computeHasFixedSize() {
        return this.mutator.hasFixedSize();
    }

    @Override
    public Object[] detach(Object[] value) {
        return this.mutator.detach(value);
    }

    @Override
    public String toDebugString(Predicate<Debuggable> isInCycle) {
        return this.mutator.toDebugString(isInCycle);
    }
}

