/*
 * Decompiled with CFR 0.152.
 */
package com.code_intelligence.jazzer.mutation.engine;

import com.code_intelligence.jazzer.mutation.annotation.NotNull;
import com.code_intelligence.jazzer.mutation.api.Cache;
import com.code_intelligence.jazzer.mutation.api.ExtendedMutatorFactory;
import com.code_intelligence.jazzer.mutation.api.MutatorFactory;
import com.code_intelligence.jazzer.mutation.api.SerializingMutator;
import com.code_intelligence.jazzer.mutation.combinator.MutatorCombinators;
import com.code_intelligence.jazzer.mutation.engine.IdentityCache;
import com.code_intelligence.jazzer.mutation.support.StreamSupport;
import com.code_intelligence.jazzer.mutation.support.TypeSupport;
import com.code_intelligence.jazzer.utils.Log;
import com.google.errorprone.annotations.CheckReturnValue;
import java.lang.reflect.AnnotatedType;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Optional;
import java.util.function.Function;
import java.util.stream.IntStream;
import java.util.stream.Stream;

public final class ChainedMutatorFactory
extends ExtendedMutatorFactory {
    private final List<MutatorFactory> fixedFactories;
    private final List<MutatorFactory> prependedFactories;
    private List<String> logs;
    private boolean currentSuppressLog;
    private AnnotatedType innerFailedType;
    private AnnotatedType currentType;
    private int level = -1;

    private ChainedMutatorFactory(Cache cache, MutatorFactory ... factories) {
        super(cache);
        this.fixedFactories = Collections.unmodifiableList(Arrays.asList(factories));
        this.prependedFactories = new ArrayList<MutatorFactory>();
        this.logs = new ArrayList<String>();
    }

    @SafeVarargs
    public static ChainedMutatorFactory of(Stream<MutatorFactory> ... factories) {
        return ChainedMutatorFactory.of(new IdentityCache(), factories);
    }

    @SafeVarargs
    public static ChainedMutatorFactory of(Cache cache, Stream<MutatorFactory> ... factories) {
        return new ChainedMutatorFactory(cache, (MutatorFactory[])Arrays.stream(factories).flatMap(Function.identity()).toArray(MutatorFactory[]::new));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    @CheckReturnValue
    public Optional<SerializingMutator<?>> tryCreate(AnnotatedType type, ExtendedMutatorFactory parent) {
        Optional<SerializingMutator<?>> optional;
        block6: {
            block7: {
                AnnotatedType previousType = this.currentType;
                int currentPrependedFactoriesSize = this.prependedFactories.size();
                Optional<SerializingMutator<?>> result = Optional.empty();
                this.currentType = type;
                ++this.level;
                boolean previousSuppressPrint = this.currentSuppressLog;
                this.currentSuppressLog = this.currentSuppressLog || this.currentType.getAnnotation(NotNull.class) == TypeSupport.NOT_NULL;
                try {
                    result = StreamSupport.findFirstPresent(Stream.concat(IntStream.range(0, currentPrependedFactoriesSize).mapToObj(this.prependedFactories::get), this.fixedFactories.stream()).map(factory -> factory.tryCreate(type, parent)));
                    if (!result.isPresent() && !this.currentSuppressLog) {
                        String indent = String.join((CharSequence)"", Collections.nCopies(this.level, "    "));
                        String typeName = this.currentType.getType().getTypeName();
                        String errorIndicator = this.innerFailedType == null ? " <<< ERROR" : "";
                        this.logs.add(String.format("%s%s%s%n", indent, typeName, errorIndicator));
                        if (this.innerFailedType == null) {
                            this.innerFailedType = this.currentType;
                        }
                    }
                    optional = result;
                    --this.level;
                    this.currentType = previousType;
                    this.prependedFactories.subList(currentPrependedFactoriesSize, this.prependedFactories.size()).clear();
                    this.currentSuppressLog = previousSuppressPrint;
                    if (this.level != -1) break block6;
                    if (result.isPresent() || this.currentSuppressLog) break block7;
                }
                catch (Throwable throwable) {
                    --this.level;
                    this.currentType = previousType;
                    this.prependedFactories.subList(currentPrependedFactoriesSize, this.prependedFactories.size()).clear();
                    this.currentSuppressLog = previousSuppressPrint;
                    if (this.level == -1) {
                        if (!result.isPresent() && !this.currentSuppressLog) {
                            Collections.reverse(this.logs);
                            String tree = String.join((CharSequence)"", this.logs);
                            String typeName = this.innerFailedType == null ? type.getType().getTypeName() : this.innerFailedType.getType().getTypeName();
                            Log.error(String.format("Could not find suitable mutator for type: %s%n%s", typeName, tree));
                        }
                        this.logs = new ArrayList<String>();
                    }
                    throw throwable;
                }
                Collections.reverse(this.logs);
                String tree = String.join((CharSequence)"", this.logs);
                String typeName = this.innerFailedType == null ? type.getType().getTypeName() : this.innerFailedType.getType().getTypeName();
                Log.error(String.format("Could not find suitable mutator for type: %s%n%s", typeName, tree));
            }
            this.logs = new ArrayList<String>();
        }
        return optional;
    }

    @Override
    public void internMutator(SerializingMutator<?> mutator) {
        AnnotatedType localCurrentType = this.currentType;
        this.prependedFactories.add((type, factory) -> {
            if (TypeSupport.annotatedTypeEquals(type, localCurrentType)) {
                return Optional.of(MutatorCombinators.markAsRequiringRecursionBreaking(mutator));
            }
            return Optional.empty();
        });
    }
}

