/*
 * Decompiled with CFR 0.152.
 */
package com.code_intelligence.jazzer.mutation.mutator.aggregate;

import com.code_intelligence.jazzer.mutation.support.StreamSupport;
import java.beans.Introspector;
import java.lang.reflect.Constructor;
import java.lang.reflect.Method;
import java.lang.reflect.Modifier;
import java.lang.reflect.Type;
import java.util.Arrays;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.function.Predicate;
import java.util.stream.Collectors;
import java.util.stream.Stream;

class BeanSupport {
    private static final Comparator<Constructor<?>> byDescParameterCountAndTypes = Comparator.comparingInt(c -> c.getParameterCount()).reversed().thenComparing(c -> Arrays.toString(c.getParameterTypes()));

    static Optional<Class<?>> optionalClassForName(String targetClassName) {
        try {
            return Optional.of(Class.forName(targetClassName));
        }
        catch (ClassNotFoundException ignored) {
            return Optional.empty();
        }
    }

    static boolean isConcreteClass(Class<?> clazz) {
        return !Modifier.isAbstract(clazz.getModifiers());
    }

    static Stream<Constructor<?>> findConstructorsByParameterCount(Class<?> clazz) {
        return Arrays.stream(clazz.getDeclaredConstructors()).filter(constructor -> !Modifier.isPrivate(constructor.getModifiers())).sorted(byDescParameterCountAndTypes);
    }

    static Optional<Constructor<?>> findDefaultConstructor(Class<?> clazz) {
        try {
            Constructor<?> constructor = clazz.getDeclaredConstructor(new Class[0]);
            if (Modifier.isPrivate(constructor.getModifiers())) {
                return Optional.empty();
            }
            return Optional.of(constructor);
        }
        catch (NoSuchMethodException e) {
            return Optional.empty();
        }
    }

    static Optional<Method[]> findGettersByPropertyNames(Class<?> clazz, Stream<String> propertyNames) {
        Map<String, Method> gettersByPropertyName = BeanSupport.findMethods(clazz, BeanSupport::isGetter).collect(Collectors.toMap(BeanSupport::toPropertyName, method -> method, (a, b) -> a));
        return StreamSupport.toArrayOrEmpty(propertyNames.map(gettersByPropertyName::get).map(Optional::ofNullable), Method[]::new);
    }

    static Optional<Method[]> findGettersByPropertyTypes(Class<?> clazz, Stream<Class<?>> types) {
        Map<Class, List<Method>> gettersByType = BeanSupport.findMethods(clazz, BeanSupport::isGetter).collect(Collectors.groupingBy(Method::getReturnType));
        return StreamSupport.toArrayOrEmpty(types.map(type -> {
            List getters = gettersByType.getOrDefault(type, Collections.emptyList());
            if (getters.size() == 1) {
                return Optional.of((Method)getters.get(0));
            }
            return Optional.empty();
        }), Method[]::new);
    }

    static String toPropertyName(Method method) {
        return Stream.of("get", "set", "is", "with").flatMap(prefix -> StreamSupport.getOrEmpty(BeanSupport.trimPrefix(method.getName(), prefix))).map(Introspector::decapitalize).findFirst().orElseThrow(() -> new AssertionError((Object)("Unexpected method name: " + method.getName())));
    }

    private static Optional<String> trimPrefix(String name, String prefix) {
        if (name.startsWith(prefix)) {
            return Optional.of(name.substring(prefix.length()));
        }
        return Optional.empty();
    }

    static boolean matchingReturnTypes(Method[] methods, Type[] types) {
        for (int i = 0; i < methods.length; ++i) {
            if (methods[i].getAnnotatedReturnType().getType().equals(types[i])) continue;
            return false;
        }
        return true;
    }

    static Stream<Method> allMethods(Class<?> clazz) {
        return BeanSupport.allMethods(clazz, new HashMap<String, Method>());
    }

    private static Stream<Method> allMethods(Class<?> clazz, Map<String, Method> methods) {
        if (clazz == null) {
            return methods.values().stream();
        }
        for (Method declaredMethod : clazz.getDeclaredMethods()) {
            methods.putIfAbsent(declaredMethod.toString(), declaredMethod);
        }
        return BeanSupport.allMethods(clazz.getSuperclass(), methods);
    }

    static Stream<Method> findMethods(Class<?> clazz, Predicate<Method> check) {
        return BeanSupport.allMethods(clazz).filter(check).sorted(Comparator.comparing(Method::getName));
    }

    static boolean isGetter(Method method) {
        return method.getParameterCount() == 0 && !method.getReturnType().equals(Void.TYPE) && !Modifier.isPrivate(method.getModifiers()) && !method.getName().equals("getClass") && (method.getName().startsWith("get") || method.getName().startsWith("is") && (method.getReturnType().equals(Boolean.TYPE) || method.getReturnType().equals(Boolean.class)));
    }

    static boolean isSetter(Method method) {
        return !(method.getParameterCount() != 1 || Modifier.isPrivate(method.getModifiers()) || !method.getReturnType().equals(Void.TYPE) && !method.getReturnType().isAssignableFrom(method.getDeclaringClass()) || !method.getName().startsWith("set") && !method.getName().startsWith("with"));
    }

    private BeanSupport() {
    }
}

