/*
 * Decompiled with CFR 0.152.
 */
package com.code_intelligence.jazzer.mutation.mutator.aggregate;

import com.code_intelligence.jazzer.mutation.api.ExtendedMutatorFactory;
import com.code_intelligence.jazzer.mutation.api.MutatorFactory;
import com.code_intelligence.jazzer.mutation.api.SerializingMutator;
import com.code_intelligence.jazzer.mutation.mutator.aggregate.AggregatesHelper;
import com.code_intelligence.jazzer.mutation.mutator.aggregate.BeanSupport;
import com.code_intelligence.jazzer.mutation.support.StreamSupport;
import com.code_intelligence.jazzer.mutation.support.TypeSupport;
import java.lang.invoke.MethodHandles;
import java.lang.reflect.AnnotatedType;
import java.lang.reflect.Constructor;
import java.util.Optional;
import java.util.function.Function;

final class CachedConstructorMutatorFactory
implements MutatorFactory {
    CachedConstructorMutatorFactory() {
    }

    @Override
    public Optional<SerializingMutator<?>> tryCreate(AnnotatedType type, ExtendedMutatorFactory factory) {
        return TypeSupport.asSubclassOrEmpty(type, Object.class).filter(BeanSupport::isConcreteClass).flatMap(clazz -> StreamSupport.findFirstPresent(BeanSupport.findConstructorsByParameterCount(clazz).map(constructor -> CachedConstructorMutatorFactory.buildMutator(constructor, type, factory))));
    }

    private static Optional<SerializingMutator<?>> buildMutator(Constructor<?> constructor, AnnotatedType initialType, ExtendedMutatorFactory factory) {
        Function<Object[], Object> instantiator = AggregatesHelper.asInstantiationFunction(MethodHandles.lookup(), constructor);
        Function<Object[], Object> fromParametersToObject = parameters -> {
            Object instance = instantiator.apply((Object[])parameters);
            factory.getCache().put(instance, parameters);
            return instance;
        };
        Function<Object, Object[]> fromObjectToParameters = instance -> (Object[])factory.getCache().get(instance);
        return AggregatesHelper.createMutator(factory, constructor.getDeclaringClass(), constructor.getAnnotatedParameterTypes(), fromParametersToObject, fromObjectToParameters, initialType, false);
    }
}

