/*
 * Decompiled with CFR 0.152.
 */
package com.code_intelligence.jazzer.mutation.mutator.aggregate;

import com.code_intelligence.jazzer.mutation.api.ExtendedMutatorFactory;
import com.code_intelligence.jazzer.mutation.api.MutatorFactory;
import com.code_intelligence.jazzer.mutation.api.SerializingMutator;
import com.code_intelligence.jazzer.mutation.mutator.aggregate.AggregatesHelper;
import com.code_intelligence.jazzer.mutation.mutator.aggregate.BeanSupport;
import com.code_intelligence.jazzer.mutation.support.StreamSupport;
import com.code_intelligence.jazzer.mutation.support.TypeSupport;
import java.beans.ConstructorProperties;
import java.lang.reflect.AnnotatedType;
import java.lang.reflect.Constructor;
import java.lang.reflect.Executable;
import java.lang.reflect.Method;
import java.lang.reflect.Parameter;
import java.util.Arrays;
import java.util.Optional;

final class ConstructorBasedBeanMutatorFactory
implements MutatorFactory {
    ConstructorBasedBeanMutatorFactory() {
    }

    @Override
    public Optional<SerializingMutator<?>> tryCreate(AnnotatedType type, ExtendedMutatorFactory factory) {
        return TypeSupport.asSubclassOrEmpty(type, Object.class).filter(BeanSupport::isConcreteClass).flatMap(clazz -> StreamSupport.findFirstPresent(BeanSupport.findConstructorsByParameterCount(clazz).filter(constructor -> constructor.getParameterCount() > 0).map(constructor -> this.findParameterGetters((Class<?>)clazz, (Constructor<?>)constructor).filter(getters -> BeanSupport.matchingReturnTypes(getters, constructor.getParameterTypes())).flatMap(getters -> AggregatesHelper.createMutator(factory, type, (Executable)constructor, getters, false)))));
    }

    private Optional<Method[]> findParameterGetters(Class<?> clazz, Constructor<?> constructor) {
        ConstructorProperties parameterNames = constructor.getAnnotation(ConstructorProperties.class);
        if (parameterNames != null && parameterNames.value().length == constructor.getParameterCount()) {
            return BeanSupport.findGettersByPropertyNames(clazz, Arrays.stream(parameterNames.value()));
        }
        Parameter[] parameters = constructor.getParameters();
        if (parameters[0].isNamePresent()) {
            return BeanSupport.findGettersByPropertyNames(clazz, Arrays.stream(parameters).map(Parameter::getName));
        }
        return BeanSupport.findGettersByPropertyTypes(clazz, Arrays.stream(parameters).map(Parameter::getType));
    }
}

