/*
 * Decompiled with CFR 0.152.
 */
package com.code_intelligence.jazzer.mutation.mutator.aggregate;

import com.code_intelligence.jazzer.mutation.api.ExtendedMutatorFactory;
import com.code_intelligence.jazzer.mutation.api.MutatorFactory;
import com.code_intelligence.jazzer.mutation.api.SerializingMutator;
import com.code_intelligence.jazzer.mutation.mutator.aggregate.AggregatesHelper;
import com.code_intelligence.jazzer.mutation.mutator.aggregate.BeanSupport;
import com.code_intelligence.jazzer.mutation.support.TypeSupport;
import java.lang.invoke.MethodHandles;
import java.lang.reflect.AnnotatedType;
import java.lang.reflect.Method;
import java.util.List;
import java.util.Optional;
import java.util.function.Function;
import java.util.stream.Collectors;

public final class SuperBuilderMutatorFactory
implements MutatorFactory {
    @Override
    public Optional<SerializingMutator<?>> tryCreate(AnnotatedType type, ExtendedMutatorFactory factory) {
        return TypeSupport.asSubclassOrEmpty(type, Object.class).filter(this::isBuilderType).flatMap(clazz -> {
            Method[] builderSetters = this.getBuilderSetters((Class<?>)clazz);
            return this.getBuilderMethod((Class<?>)clazz).map(method -> AggregatesHelper.asInstantiationFunction(MethodHandles.lookup(), method, builderSetters)).flatMap(instantiator -> {
                Function<Object[], Object> fromParametersToObject = parameters -> {
                    Object instance = instantiator.apply(parameters);
                    factory.getCache().put(instance, parameters);
                    return instance;
                };
                Function<Object, Object[]> fromObjectToParameters = instance -> (Object[])factory.getCache().get(instance);
                return AggregatesHelper.createMutator(factory, clazz, AggregatesHelper.parameterTypes(builderSetters), fromParametersToObject, fromObjectToParameters, type, false);
            });
        });
    }

    private boolean isBuilderType(Class<?> clazz) {
        return clazz.getSimpleName().endsWith("Builder");
    }

    private Method[] getBuilderSetters(Class<?> clazz) {
        return (Method[])BeanSupport.findMethods(clazz, method -> method.getParameterCount() > 0 && method.getReturnType().isAssignableFrom(clazz)).toArray(Method[]::new);
    }

    private Optional<Method> getBuilderMethod(Class<?> builderClass) {
        String builderClassName = builderClass.getName();
        int indexInnerClassName = builderClassName.lastIndexOf("$");
        if (indexInnerClassName == -1) {
            return Optional.empty();
        }
        String targetClassName = builderClassName.substring(0, indexInnerClassName);
        return BeanSupport.optionalClassForName(targetClassName).flatMap(targetClass -> {
            List builderMethods = BeanSupport.findMethods(targetClass, method -> method.getReturnType().equals(builderClass)).collect(Collectors.toList());
            if (builderMethods.size() == 1) {
                return Optional.of((Method)builderMethods.get(0));
            }
            return Optional.empty();
        });
    }
}

