/*
 * Decompiled with CFR 0.152.
 */
package com.code_intelligence.jazzer.mutation.mutator.collection;

import com.code_intelligence.jazzer.mutation.annotation.WithLength;
import com.code_intelligence.jazzer.mutation.api.Debuggable;
import com.code_intelligence.jazzer.mutation.api.ExtendedMutatorFactory;
import com.code_intelligence.jazzer.mutation.api.MutatorFactory;
import com.code_intelligence.jazzer.mutation.api.PseudoRandom;
import com.code_intelligence.jazzer.mutation.api.SerializingMutator;
import com.code_intelligence.jazzer.mutation.mutator.collection.ChunkMutations;
import com.code_intelligence.jazzer.mutation.support.Preconditions;
import com.code_intelligence.jazzer.mutation.support.PropertyConstraintSupport;
import com.code_intelligence.jazzer.mutation.support.RandomSupport;
import java.io.DataInputStream;
import java.io.DataOutputStream;
import java.io.IOException;
import java.lang.reflect.AnnotatedArrayType;
import java.lang.reflect.AnnotatedType;
import java.lang.reflect.Array;
import java.util.Arrays;
import java.util.Optional;
import java.util.function.Predicate;

final class ArrayMutatorFactory
implements MutatorFactory {
    ArrayMutatorFactory() {
    }

    @Override
    public Optional<SerializingMutator<?>> tryCreate(AnnotatedType type, ExtendedMutatorFactory factory) {
        if (!(type instanceof AnnotatedArrayType)) {
            return Optional.empty();
        }
        Optional<WithLength> withLength = Optional.ofNullable(type.getAnnotation(WithLength.class));
        int minLength = withLength.map(WithLength::min).orElse(0);
        int maxLength = withLength.map(WithLength::max).orElse(1000);
        AnnotatedType elementType = ((AnnotatedArrayType)type).getAnnotatedGenericComponentType();
        AnnotatedType propagatedElementType = PropertyConstraintSupport.propagatePropertyConstraints(type, elementType);
        Class propagatedElementClazz = (Class)propagatedElementType.getType();
        return Optional.of(propagatedElementType).flatMap(factory::tryCreate).map(elementMutator -> new ArrayMutator(elementMutator, propagatedElementClazz, minLength, maxLength));
    }

    private static final class ArrayMutator<T>
    extends SerializingMutator<T[]> {
        private static final int DEFAULT_MIN_LENGTH = 0;
        private static final int DEFAULT_MAX_LENGTH = 1000;
        private final SerializingMutator<T> elementMutator;
        private final Class<?> elementClazz;
        private final int minLength;
        private final int maxLength;

        ArrayMutator(SerializingMutator<T> elementMutator, Class<?> elementClazz, int minLength, int maxLength) {
            this.elementMutator = elementMutator;
            this.elementClazz = elementClazz;
            this.minLength = minLength;
            this.maxLength = maxLength;
            Preconditions.require(maxLength >= 1, String.format("WithLength#max=%d needs to be greater than 0", maxLength));
            Preconditions.require(minLength >= 0, String.format("WithLength#min=%d needs to be greater than or equal to 0", minLength));
        }

        @Override
        public T[] read(DataInputStream in) throws IOException {
            int size = RandomSupport.clamp(in.readInt(), this.minLength, this.maxLength);
            Object[] array = (Object[])Array.newInstance(this.elementClazz, size);
            for (int i = 0; i < size; ++i) {
                array[i] = this.elementMutator.read(in);
            }
            return array;
        }

        @Override
        public void write(T[] data, DataOutputStream out) throws IOException {
            out.writeInt(data.length);
            for (T element : data) {
                this.elementMutator.write(element, out);
            }
        }

        @Override
        public boolean hasFixedSize() {
            return false;
        }

        @Override
        public String toDebugString(Predicate<Debuggable> isInCycle) {
            return this.elementMutator.toDebugString(isInCycle) + "[]";
        }

        private int minInitialSize() {
            return this.minLength;
        }

        private int maxInitialSize() {
            if (this.elementMutator.requiresRecursionBreaking()) {
                return this.minInitialSize();
            }
            return Math.min(this.maxLength, this.minLength + 1);
        }

        @Override
        public T[] detach(T[] value) {
            return Arrays.stream(value).map(this.elementMutator::detach).toArray(len -> (Object[])Array.newInstance(this.elementClazz, len));
        }

        @Override
        public T[] init(PseudoRandom prng) {
            int len = prng.closedRange(this.minInitialSize(), this.maxInitialSize());
            Object[] array = (Object[])Array.newInstance(this.elementClazz, len);
            for (int i = 0; i < len; ++i) {
                array[i] = this.elementMutator.init(prng);
            }
            return array;
        }

        @Override
        public T[] mutate(T[] value, PseudoRandom prng) {
            switch (ChunkMutations.MutationAction.pickRandomMutationAction(Arrays.asList(value), this.minLength, this.maxLength, prng)) {
                case DELETE_CHUNK: {
                    return this.eraseRandomChunk(value, prng);
                }
                case INSERT_CHUNK: {
                    return this.insertRandomChunk(value, prng);
                }
                case MUTATE_CHUNK: {
                    return this.mutateAtRandom(value, prng);
                }
            }
            throw new IllegalStateException("unsupported action");
        }

        @Override
        public T[] crossOver(T[] arr, T[] otherArr, PseudoRandom prng) {
            switch (this.pickRandomCrossOverAction(arr, otherArr, prng).ordinal()) {
                case 0: {
                    return this.crossOverMix(arr, otherArr, prng);
                }
                case 1: {
                    this.crossOverPropagate(arr, otherArr, this.elementMutator, prng);
                    return arr;
                }
                case 2: {
                    return this.mutate(arr, prng);
                }
            }
            throw new IllegalStateException("unsupported action");
        }

        private T[] eraseRandomChunk(T[] value, PseudoRandom prng) {
            int valuesToErase = prng.closedRange(1, value.length - this.minLength);
            int newSize = value.length - valuesToErase;
            int from = prng.indexIn(newSize + 1);
            Object[] out = (Object[])Array.newInstance(this.elementClazz, newSize);
            System.arraycopy(value, 0, out, 0, from);
            System.arraycopy(value, from + valuesToErase, out, from, newSize - from);
            return out;
        }

        private T[] insertRandomChunk(T[] value, PseudoRandom prng) {
            int valuesToInsert = prng.closedRange(1, this.maxLength - value.length);
            int newSize = value.length + valuesToInsert;
            int from = prng.indexIn(value.length + 1);
            Object[] out = (Object[])Array.newInstance(this.elementClazz, newSize);
            System.arraycopy(value, 0, out, 0, from);
            for (int i = 0; i < valuesToInsert; ++i) {
                out[from + i] = this.elementMutator.init(prng);
            }
            System.arraycopy(value, from, out, from + valuesToInsert, value.length - from);
            return out;
        }

        private T[] mutateAtRandom(T[] value, PseudoRandom prng) {
            int i = prng.indexIn(value.length);
            return this.mutateAtRandom(value, i, prng);
        }

        private T[] mutateAtRandom(T[] value, int idx, PseudoRandom prng) {
            value[idx] = this.elementMutator.mutate(value[idx], prng);
            return value;
        }

        private int copyChunk(T[] in, int inPos, T[] out, int outPos, PseudoRandom prng) {
            if (inPos >= in.length) {
                return 0;
            }
            int extraLength = prng.closedRange(1, Math.min(in.length - inPos, out.length - outPos));
            System.arraycopy(in, inPos, out, outPos, extraLength);
            return extraLength;
        }

        private int copyRemainingChunk(T[] in, int inPos, T[] out, int outPos) {
            if (inPos >= in.length) {
                return 0;
            }
            int extraLength = Math.min(in.length - inPos, out.length - outPos);
            System.arraycopy(in, inPos, out, outPos, extraLength);
            return extraLength;
        }

        private T[] crossOverMix(T[] arr, T[] otherArr, PseudoRandom prng) {
            int minOutLength = Math.min(arr.length, otherArr.length);
            int maxOutLength = arr.length + otherArr.length;
            int newLength = RandomSupport.clamp(prng.closedRange(minOutLength, maxOutLength), this.minLength, this.maxLength);
            Object[] out = (Object[])Array.newInstance(this.elementClazz, newLength);
            int outPos = 0;
            int arrPos = 0;
            int otherArrPos = 0;
            while (newLength > 0) {
                int extraLength;
                if (arrPos < arr.length && otherArrPos < otherArr.length) {
                    if (prng.choice()) {
                        extraLength = this.copyChunk(arr, arrPos, out, outPos, prng);
                        arrPos += extraLength;
                        outPos += extraLength;
                        newLength -= extraLength;
                        continue;
                    }
                    extraLength = this.copyChunk(otherArr, otherArrPos, out, outPos, prng);
                    otherArrPos += extraLength;
                    outPos += extraLength;
                    newLength -= extraLength;
                    continue;
                }
                if (arrPos < arr.length) {
                    extraLength = this.copyChunk(arr, arrPos, out, outPos, prng);
                    arrPos += extraLength;
                    outPos += extraLength;
                    newLength -= extraLength;
                    continue;
                }
                if (otherArrPos >= otherArr.length) continue;
                extraLength = this.copyRemainingChunk(otherArr, otherArrPos, out, outPos);
                otherArrPos += extraLength;
                outPos += extraLength;
                newLength -= extraLength;
            }
            return out;
        }

        private void crossOverPropagate(T[] value, T[] otherValue, SerializingMutator<T> elementMutator, PseudoRandom prng) {
            int i = prng.indexIn(value.length);
            int j = prng.indexIn(otherValue.length);
            value[i] = elementMutator.crossOver(value[i], otherValue[j], prng);
        }

        private CrossOverAction pickRandomCrossOverAction(T[] arr, T[] otherArr, PseudoRandom prng) {
            if (arr.length > 0 && otherArr.length > 0) {
                return prng.indexIn(10) < 7 ? CrossOverAction.PROPAGATE : CrossOverAction.MIX;
            }
            return CrossOverAction.MUTATE;
        }
    }

    static enum CrossOverAction {
        MIX,
        PROPAGATE,
        MUTATE;

    }
}

