/*
 * Decompiled with CFR 0.152.
 */
package com.code_intelligence.jazzer.mutation.mutator.lang;

import com.code_intelligence.jazzer.mutation.api.Debuggable;
import com.code_intelligence.jazzer.mutation.api.ExtendedMutatorFactory;
import com.code_intelligence.jazzer.mutation.api.MutatorFactory;
import com.code_intelligence.jazzer.mutation.api.PseudoRandom;
import com.code_intelligence.jazzer.mutation.api.SerializingMutator;
import com.code_intelligence.jazzer.mutation.support.TypeSupport;
import com.google.errorprone.annotations.Immutable;
import java.io.DataInputStream;
import java.io.DataOutputStream;
import java.io.IOException;
import java.lang.reflect.AnnotatedType;
import java.util.Optional;
import java.util.function.Predicate;

final class BooleanMutatorFactory
implements MutatorFactory {
    BooleanMutatorFactory() {
    }

    @Override
    public Optional<SerializingMutator<?>> tryCreate(AnnotatedType type, ExtendedMutatorFactory factory) {
        return TypeSupport.findFirstParentIfClass(type, Boolean.TYPE, Boolean.class).map(parent -> BooleanMutator.INSTANCE);
    }

    @Immutable
    private static final class BooleanMutator
    extends SerializingMutator<Boolean> {
        private static final BooleanMutator INSTANCE = new BooleanMutator();

        private BooleanMutator() {
        }

        @Override
        public Boolean read(DataInputStream in) throws IOException {
            return in.readBoolean();
        }

        @Override
        public void write(Boolean value, DataOutputStream out) throws IOException {
            out.writeBoolean(value);
        }

        @Override
        public Boolean init(PseudoRandom prng) {
            return prng.choice();
        }

        @Override
        public Boolean mutate(Boolean value, PseudoRandom prng) {
            return value == false;
        }

        @Override
        public Boolean crossOver(Boolean value, Boolean otherValue, PseudoRandom prng) {
            return prng.choice() ? value : otherValue;
        }

        @Override
        public boolean hasFixedSize() {
            return true;
        }

        @Override
        public String toDebugString(Predicate<Debuggable> isInLoop) {
            return "Boolean";
        }

        @Override
        public Boolean detach(Boolean value) {
            return value;
        }
    }
}

