/*
 * Decompiled with CFR 0.152.
 */
package com.code_intelligence.jazzer.mutation.mutator.lang;

import com.code_intelligence.jazzer.mutation.api.ExtendedMutatorFactory;
import com.code_intelligence.jazzer.mutation.api.MutatorFactory;
import com.code_intelligence.jazzer.mutation.api.SerializingMutator;
import com.code_intelligence.jazzer.mutation.combinator.MutatorCombinators;
import com.code_intelligence.jazzer.mutation.support.Preconditions;
import com.code_intelligence.jazzer.mutation.support.TypeSupport;
import java.lang.reflect.AnnotatedType;
import java.util.Optional;

final class EnumMutatorFactory
implements MutatorFactory {
    EnumMutatorFactory() {
    }

    @Override
    public Optional<SerializingMutator<?>> tryCreate(AnnotatedType type, ExtendedMutatorFactory factory) {
        return TypeSupport.asSubclassOrEmpty(type, Enum.class).map(parent -> {
            Preconditions.require(((Enum[])((Class)type.getType()).getEnumConstants()).length > 1, String.format("%s defines less than two enum constants and can't be mutated. Use a constant instead.", parent));
            Enum[] values2 = (Enum[])((Class)type.getType()).getEnumConstants();
            return MutatorCombinators.mutateThenMap(MutatorCombinators.mutateIndices(values2.length), index -> values2[index], Enum::ordinal, inCycle -> "Enum<" + parent.getSimpleName() + ">");
        });
    }
}

