/*
 * Decompiled with CFR 0.152.
 */
package com.code_intelligence.jazzer.mutation.mutator.lang;

import com.code_intelligence.jazzer.mutation.annotation.DoubleInRange;
import com.code_intelligence.jazzer.mutation.annotation.FloatInRange;
import com.code_intelligence.jazzer.mutation.api.Debuggable;
import com.code_intelligence.jazzer.mutation.api.ExtendedMutatorFactory;
import com.code_intelligence.jazzer.mutation.api.MutatorFactory;
import com.code_intelligence.jazzer.mutation.api.PseudoRandom;
import com.code_intelligence.jazzer.mutation.api.SerializingMutator;
import com.code_intelligence.jazzer.mutation.mutator.libfuzzer.LibFuzzerMutate;
import com.code_intelligence.jazzer.mutation.support.Preconditions;
import java.io.DataInputStream;
import java.io.DataOutputStream;
import java.io.IOException;
import java.lang.annotation.Annotation;
import java.lang.reflect.AnnotatedType;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.Optional;
import java.util.function.DoubleFunction;
import java.util.function.Predicate;
import java.util.stream.DoubleStream;

final class FloatingPointMutatorFactory
implements MutatorFactory {
    private static final DoubleFunction<Double>[] mathFunctions = new DoubleFunction[]{Math::acos, Math::asin, Math::atan, Math::cbrt, Math::ceil, Math::cos, Math::cosh, Math::exp, Math::expm1, Math::floor, Math::log, Math::log10, Math::log1p, Math::rint, Math::sin, Math::sinh, Math::sqrt, Math::tan, Math::tanh, Math::toDegrees, Math::toRadians, n -> n * 0.5, n -> n * 2.0, n -> n * 0.333333333333333, n -> n * 3.0};

    FloatingPointMutatorFactory() {
    }

    @Override
    public Optional<SerializingMutator<?>> tryCreate(AnnotatedType type, ExtendedMutatorFactory factory) {
        if (!(type.getType() instanceof Class)) {
            return Optional.empty();
        }
        Class clazz = (Class)type.getType();
        if (clazz == Float.TYPE || clazz == Float.class) {
            return Optional.of(new FloatMutator(type, Float.NEGATIVE_INFINITY, Float.POSITIVE_INFINITY, true));
        }
        if (clazz == Double.TYPE || clazz == Double.class) {
            return Optional.of(new DoubleMutator(type, Double.NEGATIVE_INFINITY, Double.POSITIVE_INFINITY, true));
        }
        return Optional.empty();
    }

    static final class FloatMutator
    extends SerializingMutator<Float> {
        private static final int EXPONENT_INITIAL_BIT = 23;
        private static final int MANTISSA_MASK = 0x7FFFFF;
        private static final int EXPONENT_MASK = 255;
        private static final int MANTISSA_RANDOM_WALK_RANGE = 1000;
        private static final int EXPONENT_RANDOM_WALK_RANGE = 127;
        private static final int INVERSE_FREQUENCY_SPECIAL_VALUE = 1000;
        final float minValue;
        final float maxValue;
        final boolean allowNaN;
        private final float[] specialValues;

        FloatMutator(AnnotatedType type, float defaultMinValueForType, float defaultMaxValueForType, boolean defaultAllowNaN) {
            float minValue = defaultMinValueForType;
            float maxValue = defaultMaxValueForType;
            boolean allowNaN = defaultAllowNaN;
            for (Annotation annotation : type.getAnnotations()) {
                if (!(annotation instanceof FloatInRange)) continue;
                FloatInRange floatInRange = (FloatInRange)annotation;
                minValue = floatInRange.min();
                maxValue = floatInRange.max();
                allowNaN = floatInRange.allowNaN();
            }
            Preconditions.require(minValue <= maxValue, String.format("[%f, %f] is not a valid interval: %s", Float.valueOf(minValue), Float.valueOf(maxValue), type));
            Preconditions.require(minValue != maxValue, String.format("[%f, %f] can not be mutated, use a constant instead: %s", Float.valueOf(minValue), Float.valueOf(maxValue), type));
            this.minValue = minValue;
            this.maxValue = maxValue;
            this.allowNaN = allowNaN;
            this.specialValues = this.collectSpecialValues(minValue, maxValue);
        }

        private float[] collectSpecialValues(float minValue, float maxValue) {
            List specialValues = DoubleStream.of(Double.NEGATIVE_INFINITY, Double.POSITIVE_INFINITY, 0.0, -0.0, Double.NaN, 3.4028234663852886E38, 1.4E-45f, -3.4028234663852886E38, -1.4E-45f, this.minValue, this.maxValue).filter(n -> n >= (double)minValue && n <= (double)maxValue || this.allowNaN && Double.isNaN(n)).distinct().sorted().collect(ArrayList::new, ArrayList::add, ArrayList::addAll);
            float[] specialValuesArray = new float[specialValues.size()];
            for (int i = 0; i < specialValues.size(); ++i) {
                specialValuesArray[i] = (float)((Double)specialValues.get(i)).doubleValue();
            }
            return specialValuesArray;
        }

        public float mutateWithLibFuzzer(float value) {
            return LibFuzzerMutate.mutateDefault(Float.valueOf(value), this, 0).floatValue();
        }

        @Override
        public Float init(PseudoRandom prng) {
            if (prng.choice()) {
                return Float.valueOf(this.specialValues[prng.closedRange(0, this.specialValues.length - 1)]);
            }
            return Float.valueOf(prng.closedRange(this.minValue, this.maxValue));
        }

        @Override
        public Float mutate(Float value, PseudoRandom prng) {
            float result;
            if (prng.trueInOneOutOf(1000)) {
                result = this.specialValues[prng.closedRange(0, this.specialValues.length - 1)];
            } else {
                switch (prng.closedRange(0, 5)) {
                    case 0: {
                        result = this.mutateWithBitFlip(value.floatValue(), prng);
                        break;
                    }
                    case 1: {
                        result = this.mutateExponent(value.floatValue(), prng);
                        break;
                    }
                    case 2: {
                        result = this.mutateMantissa(value.floatValue(), prng);
                        break;
                    }
                    case 3: {
                        result = this.mutateWithMathematicalFn(value.floatValue(), prng);
                        break;
                    }
                    case 4: {
                        result = this.mutateWithLibFuzzer(value.floatValue());
                        break;
                    }
                    case 5: {
                        result = prng.closedRange(this.minValue, this.maxValue);
                        break;
                    }
                    default: {
                        throw new IllegalStateException("Unknown mutation case");
                    }
                }
            }
            result = FloatMutator.forceInRange(result, this.minValue, this.maxValue, this.allowNaN);
            if (Float.compare(result, value.floatValue()) == 0) {
                if (Float.isNaN(result)) {
                    return Float.valueOf(prng.closedRange(this.minValue, this.maxValue));
                }
                if (result > this.minValue && result < this.maxValue) {
                    return Float.valueOf(prng.choice() ? Math.nextAfter(result, Double.NEGATIVE_INFINITY) : Math.nextAfter(result, Double.POSITIVE_INFINITY));
                }
                if (result > this.minValue) {
                    return Float.valueOf(Math.nextAfter(result, Double.NEGATIVE_INFINITY));
                }
                return Float.valueOf(Math.nextAfter(result, Double.POSITIVE_INFINITY));
            }
            return Float.valueOf(result);
        }

        static float forceInRange(float value, float minValue, float maxValue, boolean allowNaN) {
            if (value >= minValue && value <= maxValue || Float.isNaN(value) && allowNaN) {
                return value;
            }
            if (value == Float.POSITIVE_INFINITY) {
                return maxValue;
            }
            if (value == Float.NEGATIVE_INFINITY) {
                return minValue;
            }
            float finiteMax = Math.min(Float.MAX_VALUE, maxValue);
            float finiteMin = Math.max(-3.4028235E38f, minValue);
            if (Float.isNaN(value)) {
                return finiteMin * 0.5f + finiteMax * 0.5f;
            }
            float range = finiteMax - finiteMin;
            if (range == 0.0f) {
                return finiteMin;
            }
            float diff = value - finiteMin;
            if (Float.isFinite(diff) && Float.isFinite(range)) {
                return finiteMin + Math.abs(diff % range);
            }
            float halfDiff = value * 0.5f - finiteMin * 0.5f;
            return finiteMin + Math.abs(halfDiff % (finiteMax * 0.5f - finiteMin * 0.5f)) * 2.0f;
        }

        public float mutateWithMathematicalFn(float value, PseudoRandom prng) {
            double result = (Double)prng.pickIn(mathFunctions).apply(value);
            return (float)result;
        }

        private float mutateWithBitFlip(float value, PseudoRandom prng) {
            int bits = Float.floatToRawIntBits(value);
            int bitToFlip = prng.closedRange(0, 31);
            bits = (int)((long)bits ^ 1L << bitToFlip);
            return Float.intBitsToFloat(bits);
        }

        private float mutateExponent(float value, PseudoRandom prng) {
            int bits = Float.floatToRawIntBits(value);
            int exponent = (bits >> 23 & 0xFF) + prng.closedRange(0, 127);
            bits = bits & 0x807FFFFF | exponent % 255 << 23;
            return Float.intBitsToFloat(bits);
        }

        private float mutateMantissa(float value, PseudoRandom prng) {
            int bits = Float.floatToRawIntBits(value);
            int mantissa = bits & 0x7FFFFF;
            switch (prng.closedRange(0, 2)) {
                case 0: {
                    mantissa = (mantissa + prng.closedRange(-1000, 1000)) % 0x7FFFFF;
                    break;
                }
                case 1: {
                    mantissa = mantissa * prng.closedRange(-1000, 1000) % 0x7FFFFF;
                    break;
                }
                case 2: {
                    int divisor = prng.closedRange(2, 1000);
                    if (prng.choice()) {
                        divisor = -divisor;
                    }
                    mantissa /= divisor;
                    break;
                }
                default: {
                    throw new IllegalStateException("Unknown mutation case for mantissa");
                }
            }
            bits = bits & 0xFF800000 | mantissa;
            return Float.intBitsToFloat(bits);
        }

        @Override
        public Float crossOver(Float value, Float otherValue, PseudoRandom prng) {
            float result;
            switch (prng.closedRange(0, 2)) {
                case 0: {
                    result = this.crossOverMean(value.floatValue(), otherValue.floatValue());
                    break;
                }
                case 1: {
                    result = this.crossOverExponent(value.floatValue(), otherValue.floatValue());
                    break;
                }
                case 2: {
                    result = this.crossOverMantissa(value.floatValue(), otherValue.floatValue());
                    break;
                }
                default: {
                    throw new IllegalStateException("Unknown mutation case");
                }
            }
            return Float.valueOf(FloatMutator.forceInRange(result, this.minValue, this.maxValue, this.allowNaN));
        }

        private float crossOverMean(float value, float otherValue) {
            return (float)(((double)value + (double)otherValue) / 2.0);
        }

        private float crossOverExponent(float value, float otherValue) {
            int bits = Float.floatToRawIntBits(value);
            int otherExponent = Float.floatToRawIntBits(otherValue) & 0x7F800000;
            int bitsWithOtherExponent = bits & 0x807FFFFF | otherExponent;
            return Float.intBitsToFloat(bitsWithOtherExponent);
        }

        private float crossOverMantissa(float value, float otherValue) {
            int bits = Float.floatToRawIntBits(value);
            int otherMantissa = Float.floatToRawIntBits(otherValue) & 0x7FFFFF;
            int bitsWithOtherMantissa = bits & 0xFF800000 | otherMantissa;
            return Float.intBitsToFloat(bitsWithOtherMantissa);
        }

        @Override
        public Float read(DataInputStream in) throws IOException {
            return Float.valueOf(FloatMutator.forceInRange(in.readFloat(), this.minValue, this.maxValue, this.allowNaN));
        }

        @Override
        public void write(Float value, DataOutputStream out) throws IOException {
            out.writeFloat(value.floatValue());
        }

        @Override
        public Float detach(Float value) {
            return value;
        }

        @Override
        public String toDebugString(Predicate<Debuggable> isInCycle) {
            return "Float";
        }

        @Override
        public boolean hasFixedSize() {
            return true;
        }
    }

    static final class DoubleMutator
    extends SerializingMutator<Double> {
        private static final long MANTISSA_RANDOM_WALK_RANGE = 1000L;
        private static final int EXPONENT_RANDOM_WALK_RANGE = 1023;
        private static final int INVERSE_FREQUENCY_SPECIAL_VALUE = 1000;
        private static final long MANTISSA_MASK = 0xFFFFFFFFFFFFFL;
        private static final long EXPONENT_MASK = 2047L;
        private static final int EXPONENT_INITIAL_BIT = 52;
        final double minValue;
        final double maxValue;
        final boolean allowNaN;
        private final double[] specialValues;

        DoubleMutator(AnnotatedType type, double defaultMinValueForType, double defaultMaxValueForType, boolean defaultAllowNaN) {
            double minValue = defaultMinValueForType;
            double maxValue = defaultMaxValueForType;
            boolean allowNaN = defaultAllowNaN;
            for (Annotation annotation : type.getAnnotations()) {
                if (!(annotation instanceof DoubleInRange)) continue;
                DoubleInRange doubleInRange = (DoubleInRange)annotation;
                minValue = doubleInRange.min();
                maxValue = doubleInRange.max();
                allowNaN = doubleInRange.allowNaN();
            }
            Preconditions.require(!Double.isNaN(minValue) && !Double.isNaN(maxValue), String.format("[%f, %f] is not a valid interval: %s", minValue, maxValue, type));
            Preconditions.require(minValue <= maxValue, String.format("[%f, %f] is not a valid interval: %s", minValue, maxValue, type));
            Preconditions.require(minValue != maxValue, String.format("[%f, %f] can not be mutated, use a constant instead: %s", minValue, maxValue, type));
            this.minValue = minValue;
            this.maxValue = maxValue;
            this.allowNaN = allowNaN;
            this.specialValues = this.collectSpecialValues(minValue, maxValue);
        }

        private double[] collectSpecialValues(double minValue, double maxValue) {
            double[] specialValues = new double[]{Double.NEGATIVE_INFINITY, Double.POSITIVE_INFINITY, 0.0, -0.0, Double.NaN, Double.MAX_VALUE, Double.MIN_VALUE, -1.7976931348623157E308, -4.9E-324, this.minValue, this.maxValue};
            return Arrays.stream(specialValues).boxed().filter(value -> this.allowNaN && value.isNaN() || value >= minValue && value <= maxValue).distinct().sorted().mapToDouble(Double::doubleValue).toArray();
        }

        public double mutateWithLibFuzzer(double value) {
            return LibFuzzerMutate.mutateDefault(value, this, 0);
        }

        @Override
        public Double init(PseudoRandom prng) {
            if (prng.choice()) {
                return this.specialValues[prng.closedRange(0, this.specialValues.length - 1)];
            }
            return prng.closedRange(this.minValue, this.maxValue);
        }

        @Override
        public Double mutate(Double value, PseudoRandom prng) {
            double result;
            if (prng.trueInOneOutOf(1000)) {
                result = this.specialValues[prng.closedRange(0, this.specialValues.length - 1)];
            } else {
                switch (prng.closedRange(0, 5)) {
                    case 0: {
                        result = DoubleMutator.mutateWithBitFlip(value, prng);
                        break;
                    }
                    case 1: {
                        result = DoubleMutator.mutateExponent(value, prng);
                        break;
                    }
                    case 2: {
                        result = DoubleMutator.mutateMantissa(value, prng);
                        break;
                    }
                    case 3: {
                        result = this.mutateWithMathematicalFn(value, prng);
                        break;
                    }
                    case 4: {
                        result = this.mutateWithLibFuzzer(value);
                        break;
                    }
                    case 5: {
                        result = prng.closedRange(this.minValue, this.maxValue);
                        break;
                    }
                    default: {
                        throw new IllegalStateException("Unknown mutation case");
                    }
                }
            }
            result = DoubleMutator.forceInRange(result, this.minValue, this.maxValue, this.allowNaN);
            if (Double.compare(result, value) == 0) {
                if (Double.isNaN(result)) {
                    return prng.closedRange(this.minValue, this.maxValue);
                }
                if (result > this.minValue && result < this.maxValue) {
                    return prng.choice() ? Math.nextAfter(result, Double.NEGATIVE_INFINITY) : Math.nextAfter(result, Double.POSITIVE_INFINITY);
                }
                if (result > this.minValue) {
                    return Math.nextAfter(result, Double.NEGATIVE_INFINITY);
                }
                return Math.nextAfter(result, Double.POSITIVE_INFINITY);
            }
            return result;
        }

        static double forceInRange(double value, double minValue, double maxValue, boolean allowNaN) {
            if (value >= minValue && value <= maxValue || Double.isNaN(value) && allowNaN) {
                return value;
            }
            if (value == Double.POSITIVE_INFINITY) {
                return maxValue;
            }
            if (value == Double.NEGATIVE_INFINITY) {
                return minValue;
            }
            double finiteMax = Math.min(Double.MAX_VALUE, maxValue);
            double finiteMin = Math.max(-1.7976931348623157E308, minValue);
            if (Double.isNaN(value)) {
                return minValue + (Math.min(Double.MAX_VALUE, maxValue) * 0.5 - Math.max(-1.7976931348623157E308, minValue) * 0.5);
            }
            double range = finiteMax - finiteMin;
            if (range == 0.0) {
                return finiteMin;
            }
            double diff = value - finiteMin;
            if (Double.isFinite(diff) && Double.isFinite(range)) {
                return finiteMin + Math.abs(diff % range);
            }
            double halfDiff = value * 0.5 - finiteMin * 0.5;
            return finiteMin + Math.abs(halfDiff % (finiteMax * 0.5 - finiteMin * 0.5)) * 2.0;
        }

        public double mutateWithMathematicalFn(double value, PseudoRandom prng) {
            return (Double)prng.pickIn(mathFunctions).apply(value);
        }

        public static double mutateWithBitFlip(double value, PseudoRandom prng) {
            long bits = Double.doubleToRawLongBits(value);
            int bitToFlip = prng.closedRange(0, 63);
            return Double.longBitsToDouble(bits ^= 1L << bitToFlip);
        }

        private static double mutateExponent(double value, PseudoRandom prng) {
            long bits = Double.doubleToRawLongBits(value);
            long exponent = (bits >> 52 & 0x7FFL) + (long)prng.closedRange(0, 1023);
            bits = bits & 0x800FFFFFFFFFFFFFL | exponent % 2047L << 52;
            return Double.longBitsToDouble(bits);
        }

        public static double mutateMantissa(double value, PseudoRandom prng) {
            long bits = Double.doubleToRawLongBits(value);
            long mantissa = bits & 0xFFFFFFFFFFFFFL;
            switch (prng.closedRange(0, 2)) {
                case 0: {
                    mantissa = (mantissa + prng.closedRange(-1000L, 1000L)) % 0xFFFFFFFFFFFFFL;
                    break;
                }
                case 1: {
                    mantissa = mantissa * prng.closedRange(-1000L, 1000L) % 0xFFFFFFFFFFFFFL;
                    break;
                }
                case 2: {
                    long divisor = prng.closedRange(2L, 1000L);
                    if (prng.choice()) {
                        divisor = -divisor;
                    }
                    mantissa /= divisor;
                    break;
                }
                default: {
                    throw new IllegalStateException("Unknown mutation case for mantissa");
                }
            }
            bits = bits & 0xFFF0000000000000L | mantissa;
            return Double.longBitsToDouble(bits);
        }

        @Override
        public Double crossOver(Double value, Double otherValue, PseudoRandom prng) {
            double result;
            switch (prng.closedRange(0, 2)) {
                case 0: {
                    result = this.crossOverMean(value, otherValue);
                    break;
                }
                case 1: {
                    result = this.crossOverExponent(value, otherValue);
                    break;
                }
                case 2: {
                    result = this.crossOverMantissa(value, otherValue);
                    break;
                }
                default: {
                    throw new IllegalStateException("Unknown mutation case");
                }
            }
            return DoubleMutator.forceInRange(result, this.minValue, this.maxValue, this.allowNaN);
        }

        private double crossOverMean(double value, double otherValue) {
            return value * 0.5 + otherValue * 0.5;
        }

        private double crossOverExponent(double value, double otherValue) {
            long bits = Double.doubleToRawLongBits(value);
            long otherExponent = Double.doubleToRawLongBits(otherValue) & 0x7FF0000000000000L;
            long bitsWithOtherExponent = bits & 0x800FFFFFFFFFFFFFL | otherExponent;
            return Double.longBitsToDouble(bitsWithOtherExponent);
        }

        private double crossOverMantissa(double value, double otherValue) {
            long bits = Double.doubleToRawLongBits(value);
            long otherMantissa = Double.doubleToRawLongBits(otherValue) & 0xFFFFFFFFFFFFFL;
            long bitsWithOtherMantissa = bits & 0xFFF0000000000000L | otherMantissa;
            return Double.longBitsToDouble(bitsWithOtherMantissa);
        }

        @Override
        public boolean hasFixedSize() {
            return true;
        }

        @Override
        public Double read(DataInputStream in) throws IOException {
            return DoubleMutator.forceInRange(in.readDouble(), this.minValue, this.maxValue, this.allowNaN);
        }

        @Override
        public void write(Double value, DataOutputStream out) throws IOException {
            out.writeDouble(value);
        }

        @Override
        public Double detach(Double value) {
            return value;
        }

        @Override
        public String toDebugString(Predicate<Debuggable> isInCycle) {
            return "Double";
        }
    }
}

