/*
 * Decompiled with CFR 0.152.
 */
package com.code_intelligence.jazzer.mutation.mutator.lang;

import com.code_intelligence.jazzer.mutation.api.Debuggable;
import com.code_intelligence.jazzer.mutation.api.ExtendedMutatorFactory;
import com.code_intelligence.jazzer.mutation.api.MutatorFactory;
import com.code_intelligence.jazzer.mutation.api.PseudoRandom;
import com.code_intelligence.jazzer.mutation.api.SerializingMutator;
import com.code_intelligence.jazzer.mutation.support.TypeSupport;
import java.io.DataInputStream;
import java.io.DataOutputStream;
import java.io.IOException;
import java.lang.annotation.Annotation;
import java.lang.reflect.AnnotatedType;
import java.util.Arrays;
import java.util.Optional;
import java.util.function.Predicate;

final class NullableMutatorFactory
implements MutatorFactory {
    NullableMutatorFactory() {
    }

    private static boolean isNotNullAnnotation(Annotation annotation) {
        return annotation.annotationType().getSimpleName().equals("NotNull");
    }

    @Override
    public Optional<SerializingMutator<?>> tryCreate(AnnotatedType type, ExtendedMutatorFactory factory) {
        if (TypeSupport.isPrimitive(type) || Arrays.stream(type.getAnnotations()).anyMatch(NullableMutatorFactory::isNotNullAnnotation)) {
            return Optional.empty();
        }
        return factory.tryCreate(TypeSupport.notNull(type)).map(NullableMutator::new);
    }

    private static final class NullableMutator<T>
    extends SerializingMutator<T> {
        private static final int INVERSE_FREQUENCY_NULL = 100;
        private final SerializingMutator<T> mutator;

        NullableMutator(SerializingMutator<T> mutator) {
            this.mutator = mutator;
        }

        @Override
        public T read(DataInputStream in) throws IOException {
            if (in.readBoolean()) {
                return this.mutator.read(in);
            }
            return null;
        }

        @Override
        public void write(T value, DataOutputStream out) throws IOException {
            out.writeBoolean(value != null);
            if (value != null) {
                this.mutator.write(value, out);
            }
        }

        @Override
        public T init(PseudoRandom prng) {
            if (this.mutator.requiresRecursionBreaking() || prng.trueInOneOutOf(100)) {
                return null;
            }
            return this.mutator.init(prng);
        }

        @Override
        public T mutate(T value, PseudoRandom prng) {
            if (value == null) {
                return this.mutator.init(prng);
            }
            if (prng.trueInOneOutOf(100)) {
                return null;
            }
            return this.mutator.mutate(value, prng);
        }

        @Override
        public T crossOver(T value, T otherValue, PseudoRandom prng) {
            if (value != null && otherValue != null) {
                return this.mutator.crossOver(value, otherValue, prng);
            }
            if (value == null && otherValue == null) {
                return null;
            }
            if (prng.trueInOneOutOf(100)) {
                return null;
            }
            return value != null ? value : otherValue;
        }

        @Override
        protected boolean computeHasFixedSize() {
            return this.mutator.hasFixedSize();
        }

        @Override
        public T detach(T value) {
            if (value == null) {
                return null;
            }
            return this.mutator.detach(value);
        }

        @Override
        public String toDebugString(Predicate<Debuggable> isInCycle) {
            return "Nullable<" + this.mutator.toDebugString(isInCycle) + ">";
        }
    }
}

