/*
 * Decompiled with CFR 0.152.
 */
package com.code_intelligence.jazzer.mutation.mutator.libfuzzer;

import com.code_intelligence.jazzer.mutation.api.Serializer;
import com.code_intelligence.jazzer.mutation.support.Preconditions;
import com.code_intelligence.jazzer.runtime.Mutator;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.util.Arrays;

public final class LibFuzzerMutate {
    public static final String MOCK_SIZE_KEY = "libfuzzermutator.mock.newsize";

    public static byte[] mutateDefault(byte[] data, int maxSizeIncrease) {
        byte[] mutatedBytes = maxSizeIncrease == 0 ? data : Arrays.copyOf(data, data.length + maxSizeIncrease);
        int newSize = LibFuzzerMutate.defaultMutate(mutatedBytes, data.length);
        if (newSize == 0) {
            return data;
        }
        return Arrays.copyOf(mutatedBytes, newSize);
    }

    public static <T> T mutateDefault(T value, Serializer<T> serializer, int maxSizeIncrease) {
        Preconditions.require(maxSizeIncrease >= 0);
        ByteArrayOutputStream out = new ByteArrayOutputStream();
        try {
            serializer.writeExclusive(value, out);
        }
        catch (IOException e) {
            throw new IllegalStateException("writeExclusive is not expected to throw if the underlying stream doesn't", e);
        }
        byte[] mutatedBytes = LibFuzzerMutate.mutateDefault(out.toByteArray(), maxSizeIncrease);
        try {
            return serializer.readExclusive(new ByteArrayInputStream(mutatedBytes));
        }
        catch (IOException e) {
            throw new IllegalStateException("readExclusive is not expected to throw if the underlying stream doesn't", e);
        }
    }

    private static int defaultMutate(byte[] buffer, int size) {
        if (Mutator.SHOULD_MOCK) {
            return LibFuzzerMutate.defaultMutateMock(buffer, size);
        }
        return Mutator.defaultMutateNative(buffer, size);
    }

    private static int defaultMutateMock(byte[] buffer, int size) {
        String newSizeProp = System.getProperty(MOCK_SIZE_KEY);
        int newSize = Math.min(buffer.length, size + 1);
        if (newSizeProp != null) {
            newSize = Integer.parseUnsignedInt(newSizeProp);
        }
        for (int i = 0; i < newSize; ++i) {
            int n = i;
            buffer[n] = (byte)(buffer[n] + (byte)(i + 1));
        }
        return newSize;
    }

    private LibFuzzerMutate() {
    }
}

