/*
 * Decompiled with CFR 0.152.
 */
package com.code_intelligence.jazzer.mutation.mutator.proto;

import com.code_intelligence.jazzer.mutation.annotation.proto.AnySource;
import com.code_intelligence.jazzer.mutation.annotation.proto.WithDefaultInstance;
import com.code_intelligence.jazzer.mutation.api.ExtendedMutatorFactory;
import com.code_intelligence.jazzer.mutation.api.InPlaceMutator;
import com.code_intelligence.jazzer.mutation.api.MutatorFactory;
import com.code_intelligence.jazzer.mutation.api.Serializer;
import com.code_intelligence.jazzer.mutation.api.SerializingInPlaceMutator;
import com.code_intelligence.jazzer.mutation.api.SerializingMutator;
import com.code_intelligence.jazzer.mutation.combinator.MutatorCombinators;
import com.code_intelligence.jazzer.mutation.engine.ChainedMutatorFactory;
import com.code_intelligence.jazzer.mutation.mutator.proto.BuilderAdapters;
import com.code_intelligence.jazzer.mutation.mutator.proto.TypeLibrary;
import com.code_intelligence.jazzer.mutation.support.InputStreamSupport;
import com.code_intelligence.jazzer.mutation.support.Preconditions;
import com.code_intelligence.jazzer.mutation.support.PropertyConstraintSupport;
import com.code_intelligence.jazzer.mutation.support.TypeSupport;
import com.google.protobuf.Any;
import com.google.protobuf.Descriptors;
import com.google.protobuf.DynamicMessage;
import com.google.protobuf.InvalidProtocolBufferException;
import com.google.protobuf.Message;
import com.google.protobuf.UnknownFieldSet;
import java.io.DataInputStream;
import java.io.DataOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.lang.annotation.Annotation;
import java.lang.reflect.AnnotatedType;
import java.util.Arrays;
import java.util.HashMap;
import java.util.IdentityHashMap;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.UnaryOperator;
import java.util.stream.Collectors;
import java.util.stream.IntStream;
import java.util.stream.Stream;

public final class BuilderMutatorFactory
implements MutatorFactory {
    private final HashMap<CacheKey, SerializingMutator<? extends Message.Builder>> internedMutators = new HashMap();

    private <T extends Message.Builder, U> InPlaceMutator<T> mutatorForField(AnnotatedType initialType, Descriptors.FieldDescriptor field, Annotation[] annotations, ExtendedMutatorFactory factory) {
        InPlaceMutator<Message.Builder> mutator;
        factory = this.withDescriptorDependentMutatorFactoryIfNeeded(factory, field, annotations);
        AnnotatedType typeToMutate = TypeLibrary.getTypeToMutate(field);
        Objects.requireNonNull(typeToMutate, () -> "Java class not specified for " + field);
        typeToMutate = PropertyConstraintSupport.propagatePropertyConstraints(initialType, typeToMutate);
        if (field.isMapField()) {
            SerializingInPlaceMutator<?> underlyingMutator = factory.createInPlaceOrThrow(typeToMutate);
            mutator = MutatorCombinators.mutateProperty(builder -> BuilderAdapters.getMapField(builder, field), underlyingMutator, (builder, value) -> BuilderAdapters.setMapField(builder, field, value));
        } else if (field.isRepeated()) {
            SerializingInPlaceMutator<?> underlyingMutator = factory.createInPlaceOrThrow(typeToMutate);
            mutator = MutatorCombinators.mutateViaView(builder -> BuilderAdapters.makeMutableRepeatedFieldView(builder, field), underlyingMutator);
        } else if (field.hasPresence()) {
            SerializingMutator<?> underlyingMutator = factory.createOrThrow(typeToMutate);
            mutator = MutatorCombinators.mutateProperty(builder -> BuilderAdapters.getPresentFieldOrNull(builder, field), underlyingMutator, (builder, value) -> BuilderAdapters.setFieldWithPresence(builder, field, value));
        } else {
            SerializingMutator<?> underlyingMutator = factory.createOrThrow(typeToMutate);
            mutator = MutatorCombinators.mutateProperty(builder -> builder.getField(field), underlyingMutator, (builder, value) -> builder.setField(field, value));
        }
        return TypeLibrary.withoutInitIfRecursive(mutator, field);
    }

    private ExtendedMutatorFactory withDescriptorDependentMutatorFactoryIfNeeded(ExtendedMutatorFactory originalFactory, Descriptors.FieldDescriptor field, Annotation[] annotations) {
        if (field.getJavaType() == Descriptors.FieldDescriptor.JavaType.ENUM) {
            return ChainedMutatorFactory.of(originalFactory.getCache(), Stream.of(originalFactory, (type, factory) -> TypeSupport.asSubclassOrEmpty(type, Descriptors.EnumValueDescriptor.class).map(unused -> {
                Descriptors.EnumDescriptor enumType = field.getEnumType();
                List values2 = enumType.getValues();
                String name = enumType.getName();
                if (values2.size() == 1) {
                    return MutatorCombinators.fixedValue((Descriptors.EnumValueDescriptor)values2.get(0));
                }
                return MutatorCombinators.mutateThenMapToImmutable(MutatorCombinators.mutateIndices(values2.size()), values2::get, Descriptors.EnumValueDescriptor::getIndex, unused2 -> "Enum<" + name + ">");
            })));
        }
        if (field.getJavaType() == Descriptors.FieldDescriptor.JavaType.MESSAGE) {
            Descriptors.Descriptor messageDescriptor;
            if (field.isMapField()) {
                Descriptors.FieldDescriptor valueField = (Descriptors.FieldDescriptor)field.getMessageType().getFields().get(1);
                if (valueField.getJavaType() != Descriptors.FieldDescriptor.JavaType.MESSAGE) {
                    return originalFactory;
                }
                messageDescriptor = valueField.getMessageType();
            } else {
                messageDescriptor = field.getMessageType();
            }
            return ChainedMutatorFactory.of(originalFactory.getCache(), Stream.of(originalFactory, (type, factory) -> TypeSupport.asSubclassOrEmpty(type, Message.Builder.class).flatMap(clazz -> {
                if (clazz != Message.Builder.class) {
                    return Optional.empty();
                }
                return Optional.of(this.makeBuilderMutator(type, originalFactory, (Message)DynamicMessage.getDefaultInstance((Descriptors.Descriptor)messageDescriptor), annotations));
            })));
        }
        return originalFactory;
    }

    private <T extends Message.Builder> Stream<InPlaceMutator<T>> mutatorsForFields(AnnotatedType initialType, Optional<Descriptors.OneofDescriptor> oneofField, List<Descriptors.FieldDescriptor> fields, Annotation[] annotations, ExtendedMutatorFactory factory) {
        if (oneofField.isPresent()) {
            Descriptors.OneofDescriptor oneofDescriptor = oneofField.get();
            IdentityHashMap<Descriptors.FieldDescriptor, Integer> indexInOneof = new IdentityHashMap<Descriptors.FieldDescriptor, Integer>(oneofDescriptor.getFieldCount());
            for (int i = 0; i < oneofDescriptor.getFieldCount(); ++i) {
                indexInOneof.put(oneofDescriptor.getField(i), i);
            }
            return Stream.of(MutatorCombinators.mutateSumInPlace(builder -> {
                Descriptors.FieldDescriptor setField = builder.getOneofFieldDescriptor(oneofDescriptor);
                if (setField == null) {
                    return -1;
                }
                return (Integer)indexInOneof.get(setField);
            }, (InPlaceMutator[])fields.stream().map(field -> this.mutatorForField(initialType, (Descriptors.FieldDescriptor)field, annotations, factory)).toArray(InPlaceMutator[]::new)));
        }
        return fields.stream().map(field -> this.mutatorForField(initialType, (Descriptors.FieldDescriptor)field, annotations, factory));
    }

    private static <M extends Message, B extends Message.Builder> Serializer<B> makeBuilderSerializer(final M defaultInstance) {
        return new Serializer<B>(){

            @Override
            public B read(DataInputStream in) throws IOException {
                int length = Math.max(in.readInt(), 0);
                return this.parseLeniently(InputStreamSupport.cap(in, length));
            }

            @Override
            public B readExclusive(InputStream in) throws IOException {
                return this.parseLeniently(in);
            }

            private Message.Builder parseLeniently(InputStream in) throws IOException {
                Message.Builder builder = defaultInstance.toBuilder();
                try {
                    builder.mergeFrom(in);
                }
                catch (InvalidProtocolBufferException invalidProtocolBufferException) {
                    // empty catch block
                }
                builder.setUnknownFields(UnknownFieldSet.getDefaultInstance());
                this.forceInitialized(builder);
                return builder;
            }

            private void forceInitialized(Message.Builder builder) {
                if (builder.isInitialized()) {
                    return;
                }
                for (Descriptors.FieldDescriptor field : builder.getDescriptorForType().getFields()) {
                    if (!field.isRequired()) continue;
                    if (field.getJavaType() == Descriptors.FieldDescriptor.JavaType.MESSAGE) {
                        this.forceInitialized(builder.getFieldBuilder(field));
                        continue;
                    }
                    if (builder.hasField(field)) continue;
                    builder.setField(field, field.getDefaultValue());
                }
            }

            @Override
            public void write(Message.Builder builder, DataOutputStream out) throws IOException {
                Message message = builder.build();
                out.writeInt(message.getSerializedSize());
                message.writeTo((OutputStream)out);
            }

            @Override
            public void writeExclusive(Message.Builder builder, OutputStream out) throws IOException {
                builder.build().writeTo(out);
            }

            @Override
            public B detach(Message.Builder builder) {
                return builder.build().toBuilder();
            }
        };
    }

    private SerializingMutator<Any.Builder> mutatorForAny(AnySource anySource, ExtendedMutatorFactory factory) {
        Map typeUrlToIndex = IntStream.range(0, anySource.value().length).boxed().collect(Collectors.toMap(i -> BuilderMutatorFactory.getTypeUrl(TypeLibrary.getDefaultInstance(anySource.value()[i])), UnaryOperator.identity()));
        return MutatorCombinators.assemble(mutator -> this.internedMutators.put(new CacheKey(Any.getDescriptor(), anySource), (SerializingMutator<? extends Message.Builder>)mutator), () -> ((Any)Any.getDefaultInstance()).toBuilder(), BuilderMutatorFactory.makeBuilderSerializer(Any.getDefaultInstance()), () -> MutatorCombinators.mutateSumInPlace(builder -> typeUrlToIndex.getOrDefault(builder.getTypeUrl(), 0), (InPlaceMutator[])Arrays.stream(anySource.value()).map(messageClass -> {
            SerializingMutator<?> messageMutator = factory.createOrThrow(TypeSupport.notNull(TypeSupport.withExtraAnnotations(TypeLibrary.getMessageType(messageClass), new Annotation[]{anySource})));
            return MutatorCombinators.mutateProperty(anyBuilder -> {
                try {
                    return anyBuilder.build().unpack(messageClass);
                }
                catch (InvalidProtocolBufferException e) {
                    return TypeLibrary.getDefaultInstance(messageClass);
                }
            }, messageMutator, (any, message) -> {
                any.setTypeUrl(BuilderMutatorFactory.getTypeUrl(message));
                any.setValue(message.toByteString());
            });
        }).toArray(InPlaceMutator[]::new)));
    }

    private static String getTypeUrl(Message message) {
        return "type.googleapis.com/" + message.getDescriptorForType().getFullName();
    }

    @Override
    public Optional<SerializingMutator<?>> tryCreate(AnnotatedType type, ExtendedMutatorFactory factory) {
        return TypeSupport.asSubclassOrEmpty(type, Message.Builder.class).flatMap(builderClass -> {
            Message defaultInstance;
            WithDefaultInstance withDefaultInstance = type.getAnnotation(WithDefaultInstance.class);
            if (withDefaultInstance != null) {
                defaultInstance = TypeLibrary.getDefaultInstance(withDefaultInstance);
            } else {
                if (builderClass == DynamicMessage.Builder.class) {
                    throw new IllegalArgumentException("To mutate a dynamic message, add a @WithDefaultInstance annotation specifying the fully qualified method name of a static method returning a default instance");
                }
                if (builderClass == Message.Builder.class) {
                    return Optional.empty();
                }
                defaultInstance = TypeLibrary.getDefaultInstance(builderClass.getEnclosingClass());
            }
            return Optional.of(this.makeBuilderMutator(type, factory, defaultInstance, type.getDeclaredAnnotations()));
        });
    }

    private SerializingMutator<?> makeBuilderMutator(AnnotatedType initialType, ExtendedMutatorFactory factory, Message defaultInstance, Annotation[] annotations) {
        AnySource anySource = Arrays.stream(annotations).filter(annotation -> annotation.annotationType() == AnySource.class).findFirst().orElse(null);
        Preconditions.require(anySource == null || anySource.value().length > 0, "@AnySource must list a non-empty list of classes");
        Descriptors.Descriptor descriptor = defaultInstance.getDescriptorForType();
        CacheKey cacheKey = new CacheKey(descriptor, anySource);
        if (this.internedMutators.containsKey(cacheKey)) {
            return this.internedMutators.get(cacheKey);
        }
        if (descriptor.equals(Any.getDescriptor()) && anySource != null) {
            return this.mutatorForAny(anySource, factory);
        }
        return MutatorCombinators.assemble(mutator -> this.internedMutators.put(cacheKey, (SerializingMutator<? extends Message.Builder>)mutator), () -> ((Message)defaultInstance).toBuilder(), BuilderMutatorFactory.makeBuilderSerializer(defaultInstance), () -> MutatorCombinators.combine((InPlaceMutator[])descriptor.getFields().stream().collect(Collectors.groupingBy(fieldDescriptor -> Optional.ofNullable(fieldDescriptor.getRealContainingOneof()), LinkedHashMap::new, Collectors.toList())).entrySet().stream().flatMap(entry -> {
            Annotation[] annotationArray;
            Optional optional = (Optional)entry.getKey();
            List list = (List)entry.getValue();
            if (anySource == null) {
                annotationArray = new Annotation[]{};
            } else {
                Annotation[] annotationArray2 = new Annotation[1];
                annotationArray = annotationArray2;
                annotationArray2[0] = anySource;
            }
            return this.mutatorsForFields(initialType, optional, list, annotationArray, factory);
        }).toArray(InPlaceMutator[]::new)));
    }

    private static final class CacheKey {
        private final Descriptors.Descriptor descriptor;
        private final AnySource anySource;

        private CacheKey(Descriptors.Descriptor descriptor, AnySource anySource) {
            this.descriptor = descriptor;
            this.anySource = anySource;
        }

        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (o == null || this.getClass() != o.getClass()) {
                return false;
            }
            CacheKey cacheKey = (CacheKey)o;
            return this.descriptor == cacheKey.descriptor && Objects.equals(this.anySource, cacheKey.anySource);
        }

        public int hashCode() {
            return 31 * System.identityHashCode(this.descriptor) + Objects.hashCode(this.anySource);
        }
    }
}

