/*
 * Decompiled with CFR 0.152.
 */
package com.code_intelligence.jazzer.mutation.mutator.time;

import com.code_intelligence.jazzer.mutation.api.ExtendedMutatorFactory;
import com.code_intelligence.jazzer.mutation.api.MutatorFactory;
import com.code_intelligence.jazzer.mutation.api.SerializingMutator;
import com.code_intelligence.jazzer.mutation.combinator.MutatorCombinators;
import com.code_intelligence.jazzer.mutation.support.TypeHolder;
import com.code_intelligence.jazzer.mutation.support.TypeSupport;
import java.lang.reflect.AnnotatedType;
import java.time.Instant;
import java.time.LocalDateTime;
import java.util.Optional;
import java.util.TimeZone;

final class LocalDateTimeMutatorFactory
implements MutatorFactory {
    private static final AnnotatedType INNER_LONG_TYPE = TypeSupport.notNull(new TypeHolder<Long>(){}.annotatedType());

    LocalDateTimeMutatorFactory() {
    }

    @Override
    public Optional<SerializingMutator<?>> tryCreate(AnnotatedType type, ExtendedMutatorFactory factory) {
        return TypeSupport.asSubclassOrEmpty(type, LocalDateTime.class).flatMap(parent -> factory.tryCreate(INNER_LONG_TYPE)).map(longMutator -> MutatorCombinators.mutateThenMap(longMutator, LocalDateTimeMutatorFactory::toLocalDateTime, LocalDateTimeMutatorFactory::fromLocalDateTime, inCycle -> "LocalDateTime"));
    }

    public static LocalDateTime toLocalDateTime(long timestamp) {
        return LocalDateTime.ofInstant(Instant.ofEpochMilli(timestamp), TimeZone.getDefault().toZoneId());
    }

    public static long fromLocalDateTime(LocalDateTime localDateTime) {
        return localDateTime.atZone(TimeZone.getDefault().toZoneId()).toInstant().toEpochMilli();
    }
}

