/*
 * Decompiled with CFR 0.152.
 */
package com.code_intelligence.jazzer.mutation.support;

import com.code_intelligence.jazzer.mutation.support.Preconditions;
import com.code_intelligence.jazzer.mutation.support.PropertyConstraintSupport;
import com.code_intelligence.jazzer.mutation.support.TypeSupport;
import com.code_intelligence.jazzer.mutation.utils.AppliesTo;
import com.code_intelligence.jazzer.mutation.utils.ValidateContainerDimensions;
import com.code_intelligence.jazzer.mutation.utils.ValidateMinMax;
import com.code_intelligence.jazzer.utils.Log;
import java.lang.annotation.Annotation;
import java.lang.reflect.AnnotatedType;
import java.lang.reflect.InvocationTargetException;
import java.util.Arrays;
import java.util.stream.Collectors;

public class AnnotationSupport {
    public static void validateAnnotationUsage(AnnotatedType type) {
        TypeSupport.visitAnnotatedType(type, (clazz, annotations) -> {
            for (Annotation annotation : annotations) {
                AnnotationSupport.ensureDeepAppliesTo(annotation, clazz);
                AnnotationSupport.ensureMinLessThanOrEqualsMax(annotation);
                AnnotationSupport.validateContainerDimensions(annotation);
            }
        });
    }

    private static void ensureDeepAppliesTo(Annotation annotation, Class<?> clazz) {
        AppliesTo appliesTo = annotation.annotationType().getAnnotation(AppliesTo.class);
        if (appliesTo == null) {
            return;
        }
        if (PropertyConstraintSupport.isRecursiveConstraintAnnotation(annotation)) {
            return;
        }
        for (Class allowedClass : appliesTo.value()) {
            if (allowedClass != clazz) continue;
            return;
        }
        for (Class allowedSuperClass : appliesTo.subClassesOf()) {
            if (!allowedSuperClass.isAssignableFrom(clazz)) continue;
            return;
        }
        String helpText = "";
        if (appliesTo.value().length != 0) {
            helpText = Arrays.stream(appliesTo.value()).map(Class::getName).collect(Collectors.joining(", "));
        }
        if (appliesTo.subClassesOf().length != 0) {
            if (!helpText.isEmpty()) {
                helpText = helpText + "as well as ";
            }
            helpText = helpText + "subclasses of ";
            helpText = helpText + Arrays.stream(appliesTo.subClassesOf()).map(Class::getName).collect(Collectors.joining(", "));
        }
        throw new IllegalArgumentException(String.format("@%s does not apply to %s, only applies to %s", annotation.annotationType().getSimpleName(), clazz.getName(), helpText));
    }

    private static void ensureMinLessThanOrEqualsMax(Annotation annotation) {
        block8: {
            String name = annotation.annotationType().getSimpleName();
            if (annotation.annotationType().getAnnotation(ValidateMinMax.class) != null) {
                try {
                    Class<?> returnType = annotation.annotationType().getMethod("min", new Class[0]).getReturnType();
                    Object min = annotation.annotationType().getMethod("min", new Class[0]).invoke((Object)annotation, new Object[0]);
                    Object max = annotation.annotationType().getMethod("max", new Class[0]).invoke((Object)annotation, new Object[0]);
                    if (returnType == Integer.TYPE || returnType == Integer.class) {
                        Preconditions.require((Integer)min <= (Integer)max, String.format("@%s(min=%d, max=%d): min must be less than or equal to max.", name, (Integer)min, (Integer)max));
                        break block8;
                    }
                    if (returnType == Long.TYPE || returnType == Long.class) {
                        Preconditions.require((Long)min <= (Long)max, String.format("@%s(min=%d, max=%d): min must be less than or equal to max.", name, (Long)min, (Long)max));
                        break block8;
                    }
                    if (returnType == Float.TYPE || returnType == Float.class) {
                        Preconditions.require(((Float)min).floatValue() <= ((Float)max).floatValue(), String.format("@%s(min=%f, max=%f): min must be less than or equal to max.", name, (Float)min, (Float)max));
                        break block8;
                    }
                    if (returnType == Double.TYPE || returnType == Double.class) {
                        Preconditions.require((Double)min <= (Double)max, String.format("@%s(min=%f, max=%f): min must be less than or equal to max.", name, (Double)min, (Double)max));
                        break block8;
                    }
                    throw new IllegalArgumentException("Unsupported type for min/max: " + returnType);
                }
                catch (NoSuchMethodException e) {
                    throw new RuntimeException("Failed to access min/max fields of annotation", e);
                }
                catch (IllegalAccessException | InvocationTargetException e) {
                    throw new RuntimeException(e);
                }
            }
        }
    }

    private static void validateContainerDimensions(Annotation annotation) {
        if (annotation.annotationType().getAnnotation(ValidateContainerDimensions.class) != null) {
            try {
                String name = annotation.annotationType().getSimpleName();
                Integer min = (Integer)annotation.annotationType().getMethod("min", new Class[0]).invoke((Object)annotation, new Object[0]);
                Integer max = (Integer)annotation.annotationType().getMethod("max", new Class[0]).invoke((Object)annotation, new Object[0]);
                Preconditions.require(min >= 0 && max >= 0, String.format("@%s(min=%d, max=%d): min and max must be greater than or equal to 0.", name, min, max));
                Preconditions.require(min <= max, String.format("@%s(min=%d, max=%d): min must be less than or equal to max.", name, min, max));
                if (min == 0 && max == 0) {
                    Log.info(String.format("@%s(min=0, max=0): min and max are both zero. Consider using a constant instead! %n", name));
                }
            }
            catch (NoSuchMethodException e) {
                throw new RuntimeException("Failed to access min/max fields of annotation", e);
            }
            catch (IllegalAccessException | InvocationTargetException e) {
                throw new RuntimeException(e);
            }
        }
    }
}

