/*
 * Decompiled with CFR 0.152.
 */
package com.code_intelligence.jazzer.mutation.support;

import com.code_intelligence.jazzer.mutation.support.TypeSupport;
import com.code_intelligence.jazzer.mutation.utils.PropertyConstraint;
import java.lang.annotation.Annotation;
import java.lang.reflect.AnnotatedType;
import java.util.Arrays;

public final class PropertyConstraintSupport {
    public static AnnotatedType propagatePropertyConstraints(AnnotatedType src, AnnotatedType target) {
        Annotation[] annotationsToPropagate = (Annotation[])Arrays.stream(src.getAnnotations()).filter(annotation -> PropertyConstraintSupport.isRecursiveConstraintAnnotation(annotation) && !PropertyConstraintSupport.hasConstraint(target, annotation)).toArray(Annotation[]::new);
        return TypeSupport.withExtraAnnotations(target, annotationsToPropagate);
    }

    public static boolean isRecursiveConstraintAnnotation(Annotation annotation) {
        return "JAZZER_PROPERTY_CONSTRAINT_RECURSIVE".equals(PropertyConstraintSupport.constraintFrom(annotation));
    }

    private static boolean isConstraintAnnotation(Annotation annotation) {
        return annotation.annotationType().getAnnotation(PropertyConstraint.class) != null;
    }

    private static String constraintFrom(Annotation constraint) {
        if (!PropertyConstraintSupport.isConstraintAnnotation(constraint)) {
            return null;
        }
        try {
            return (String)constraint.annotationType().getDeclaredMethod("constraint", new Class[0]).invoke((Object)constraint, new Object[0]);
        }
        catch (Exception ignored) {
            return "";
        }
    }

    private static boolean hasConstraint(AnnotatedType target, Annotation constraint) {
        return target.getAnnotation(constraint.annotationType()) != null;
    }

    private PropertyConstraintSupport() {
    }
}

