/*
 * Decompiled with CFR 0.152.
 */
package com.code_intelligence.jazzer.driver.junit;

import java.io.File;
import java.io.IOException;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Optional;
import java.util.jar.JarFile;
import java.util.logging.ConsoleHandler;
import java.util.logging.Level;
import java.util.logging.Logger;
import java.util.regex.Pattern;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import org.junit.platform.engine.DiscoverySelector;
import org.junit.platform.engine.Filter;
import org.junit.platform.engine.UniqueId;
import org.junit.platform.engine.discovery.DiscoverySelectors;
import org.junit.platform.launcher.EngineFilter;
import org.junit.platform.launcher.LauncherDiscoveryRequest;
import org.junit.platform.launcher.TagFilter;
import org.junit.platform.launcher.TestIdentifier;
import org.junit.platform.launcher.TestPlan;
import org.junit.platform.launcher.core.LauncherDiscoveryRequestBuilder;
import org.junit.platform.launcher.core.LauncherFactory;

public final class FuzzTestLister {
    private static final Pattern CLASSPATH_SPLITTER = Pattern.compile(Pattern.quote(File.pathSeparator));
    private static final List<String> EXPECTED_SEGMENT_TYPES = Collections.unmodifiableList(Arrays.asList("engine", "class", "test-template"));
    private static final Pattern MANIFEST_PATH_SPLITTER = Pattern.compile(Pattern.quote(" "));

    public static List<String> listFuzzTests(List<String> classes) {
        if (System.getenv("JAZZER_DEBUG") != null) {
            Logger logger = Logger.getLogger("org.junit");
            logger.setLevel(Level.FINE);
            ConsoleHandler consoleHandler = new ConsoleHandler();
            consoleHandler.setLevel(Level.FINE);
            logger.addHandler(consoleHandler);
        }
        LauncherDiscoveryRequest request = LauncherDiscoveryRequestBuilder.request().selectors(FuzzTestLister.selectorsFor(classes)).filters(new Filter[]{EngineFilter.includeEngines((String[])new String[]{"junit-jupiter"}), TagFilter.includeTags((String[])new String[]{"jazzer"})}).build();
        TestPlan testPlan = LauncherFactory.create().discover(request);
        return testPlan.getRoots().stream().flatMap(engineTestIdentifier -> testPlan.getDescendants(engineTestIdentifier).stream()).flatMap(classTestIdentifier -> testPlan.getDescendants(classTestIdentifier).stream()).map(FuzzTestLister::toMethodReference).filter(Optional::isPresent).map(Optional::get).sorted().distinct().collect(Collectors.toList());
    }

    private static List<? extends DiscoverySelector> selectorsFor(List<String> classes) {
        if (classes.isEmpty()) {
            return DiscoverySelectors.selectClasspathRoots(CLASSPATH_SPLITTER.splitAsStream(System.getProperty("java.class.path")).map(x$0 -> Paths.get(x$0, new String[0])).flatMap(path -> FuzzTestLister.isCifuzzClasspathCompressionJar(path) ? FuzzTestLister.extractClasspathFromCifuzzManifest(path) : Stream.of(path)).filter(x$0 -> Files.isDirectory(x$0, new LinkOption[0])).collect(Collectors.toSet()));
        }
        return classes.stream().map(DiscoverySelectors::selectClass).collect(Collectors.toList());
    }

    private static Optional<String> toMethodReference(TestIdentifier testIdentifier) {
        List segments = testIdentifier.getUniqueIdObject().getSegments();
        if (!segments.stream().map(UniqueId.Segment::getType).collect(Collectors.toList()).equals(EXPECTED_SEGMENT_TYPES)) {
            return Optional.empty();
        }
        String className = ((UniqueId.Segment)segments.get(1)).getValue();
        String methodNameAndArgs = ((UniqueId.Segment)segments.get(2)).getValue();
        String methodName = methodNameAndArgs.substring(0, methodNameAndArgs.indexOf(40));
        return Optional.of(String.format("%s::%s", className, methodName));
    }

    private static boolean isCifuzzClasspathCompressionJar(Path jarPath) {
        return jarPath.toString().contains("cifuzz-classpath-compression") && jarPath.toString().endsWith("manifest.jar");
    }

    private static Stream<Path> extractClasspathFromCifuzzManifest(Path path) {
        Stream<Path> stream;
        JarFile jarFile = new JarFile(path.toFile());
        try {
            String jarClassPath = jarFile.getManifest().getMainAttributes().getValue("Class-Path");
            stream = FuzzTestLister.jarClassPathToPaths(jarClassPath, path);
        }
        catch (Throwable throwable) {
            try {
                try {
                    jarFile.close();
                }
                catch (Throwable throwable2) {
                    throwable.addSuppressed(throwable2);
                }
                throw throwable;
            }
            catch (IOException | NullPointerException e) {
                throw new RuntimeException("Failed to extract class path from path-compressing manifest: " + path, e);
            }
        }
        jarFile.close();
        return stream;
    }

    public static Stream<Path> jarClassPathToPaths(String jarClassPath, Path jarPath) {
        return MANIFEST_PATH_SPLITTER.splitAsStream(jarClassPath).map(p -> p.matches("^[\\\\/][A-Za-z]:.*") ? p.substring(1) : p).map(x$0 -> Paths.get(x$0, new String[0])).map(p -> jarPath.getParent().resolve((Path)p).normalize()).collect(Collectors.toSet()).stream();
    }

    private FuzzTestLister() {
    }
}

