/*
 * Decompiled with CFR 0.152.
 */
package com.code_intelligence.jazzer.mutation.combinator;

import com.code_intelligence.jazzer.mutation.api.Debuggable;
import com.code_intelligence.jazzer.mutation.api.MutatorBase;
import com.code_intelligence.jazzer.mutation.api.PseudoRandom;
import com.code_intelligence.jazzer.mutation.api.SerializingInPlaceMutator;
import com.code_intelligence.jazzer.mutation.api.SerializingMutator;
import com.code_intelligence.jazzer.mutation.support.InputStreamSupport;
import com.code_intelligence.jazzer.mutation.support.Preconditions;
import java.io.DataInputStream;
import java.io.DataOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.util.Arrays;
import java.util.function.Predicate;
import java.util.stream.Collectors;

public final class InPlaceProductMutator
extends SerializingInPlaceMutator<Object[]> {
    private static final int INVERSE_PICK_VALUE_SUPPLIER_FREQUENCY = 100;
    private final SerializingMutator[] mutators;

    InPlaceProductMutator(SerializingMutator[] mutators) {
        Preconditions.requireNonNullElements(mutators);
        this.mutators = Arrays.copyOf(mutators, mutators.length);
    }

    @Override
    public Object[] read(DataInputStream in) throws IOException {
        Object[] value = new Object[this.mutators.length];
        for (int i = 0; i < this.mutators.length; ++i) {
            value[i] = this.mutators[i].read(in);
        }
        return value;
    }

    @Override
    public Object[] readExclusive(InputStream in) throws IOException {
        Object[] value = new Object[this.mutators.length];
        if (this.mutators.length == 0) {
            return value;
        }
        int lastIndex = this.mutators.length - 1;
        DataInputStream endlessData = new DataInputStream(InputStreamSupport.extendWithZeros(in));
        for (int i = 0; i < lastIndex; ++i) {
            value[i] = this.mutators[i].read(endlessData);
        }
        value[lastIndex] = this.mutators[lastIndex].readExclusive(in);
        return value;
    }

    @Override
    public void write(Object[] value, DataOutputStream out) throws IOException {
        for (int i = 0; i < this.mutators.length; ++i) {
            this.mutators[i].write(value[i], out);
        }
    }

    @Override
    public void writeExclusive(Object[] value, OutputStream out) throws IOException {
        DataOutputStream dataOut = new DataOutputStream(out);
        int lastIndex = this.mutators.length - 1;
        for (int i = 0; i < lastIndex; ++i) {
            this.mutators[i].write(value[i], dataOut);
        }
        this.mutators[lastIndex].writeExclusive(value[lastIndex], out);
    }

    @Override
    protected Object[] makeDefaultInstance() {
        return new Object[this.mutators.length];
    }

    @Override
    public void initInPlace(Object[] reference, PseudoRandom prng) {
        for (int i = 0; i < this.mutators.length; ++i) {
            reference[i] = this.mutators[i].init(prng);
        }
    }

    @Override
    public void mutateInPlace(Object[] reference, PseudoRandom prng) {
        if (this.mutators.length == 0) {
            return;
        }
        int i = prng.indexIn(this.mutators);
        reference[i] = this.mutators[i].mutate(reference[i], prng);
    }

    @Override
    public void crossOverInPlace(Object[] reference, Object[] otherReference, PseudoRandom prng) {
        for (int i = 0; i < this.mutators.length; ++i) {
            Object value = reference[i];
            Object otherValue = otherReference[i];
            SerializingMutator mutator = this.mutators[i];
            Object crossedOver = prng.pickValue(value, otherValue, () -> mutator.crossOver(value, otherValue, prng), 100);
            if (crossedOver == otherReference) {
                crossedOver = mutator.detach(crossedOver);
            }
            reference[i] = crossedOver;
        }
    }

    @Override
    protected boolean computeHasFixedSize() {
        return Arrays.stream(this.mutators).allMatch(MutatorBase::hasFixedSize);
    }

    @Override
    public Object[] detach(Object[] value) {
        Object[] clone = new Object[this.mutators.length];
        for (int i = 0; i < this.mutators.length; ++i) {
            clone[i] = this.mutators[i].detach(value[i]);
        }
        return clone;
    }

    @Override
    public String toDebugString(Predicate<Debuggable> isInCycle) {
        if (isInCycle.test(this)) {
            return "(cycle)";
        }
        return Arrays.stream(this.mutators).map(mutator -> mutator.toDebugString(isInCycle)).collect(Collectors.joining(", ", "[", "]"));
    }
}

