/*
 * Decompiled with CFR 0.152.
 */
package com.code_intelligence.jazzer.mutation.mutator.aggregate;

import com.code_intelligence.jazzer.mutation.api.MutatorFactory;
import com.code_intelligence.jazzer.mutation.mutator.aggregate.CachedConstructorMutatorFactory;
import com.code_intelligence.jazzer.mutation.mutator.aggregate.ConstructorBasedBeanMutatorFactory;
import com.code_intelligence.jazzer.mutation.mutator.aggregate.SetterBasedBeanMutatorFactory;
import java.lang.reflect.InvocationTargetException;
import java.util.stream.Stream;

public final class AggregateMutators {
    private AggregateMutators() {
    }

    public static Stream<MutatorFactory> newFactories() {
        return Stream.of(AggregateMutators.newRecordMutatorFactoryIfSupported(), AggregateMutators.newSealedClassMutatorFactoryIfSupported(), Stream.of(new SetterBasedBeanMutatorFactory(), new ConstructorBasedBeanMutatorFactory(), new CachedConstructorMutatorFactory())).flatMap(s -> s);
    }

    private static Stream<MutatorFactory> newRecordMutatorFactoryIfSupported() {
        try {
            Class.forName("java.lang.Record");
            return Stream.of(AggregateMutators.instantiateMutatorFactory("RecordMutatorFactory"));
        }
        catch (ClassNotFoundException ignored) {
            return Stream.empty();
        }
    }

    private static Stream<MutatorFactory> newSealedClassMutatorFactoryIfSupported() {
        try {
            Class.class.getMethod("getPermittedSubclasses", new Class[0]);
            return Stream.of(AggregateMutators.instantiateMutatorFactory("SealedClassMutatorFactory"));
        }
        catch (NoSuchMethodException e) {
            return Stream.empty();
        }
    }

    private static MutatorFactory instantiateMutatorFactory(String simpleClassName) {
        try {
            Class<MutatorFactory> factory = Class.forName(AggregateMutators.class.getPackage().getName() + "." + simpleClassName).asSubclass(MutatorFactory.class);
            return factory.getDeclaredConstructor(new Class[0]).newInstance(new Object[0]);
        }
        catch (ClassNotFoundException | IllegalAccessException | InstantiationException | NoSuchMethodException | InvocationTargetException e) {
            throw new IllegalStateException(e);
        }
    }
}

