/*
 * Decompiled with CFR 0.152.
 */
package com.code_intelligence.jazzer.mutation.mutator.aggregate;

import com.code_intelligence.jazzer.mutation.api.Debuggable;
import com.code_intelligence.jazzer.mutation.api.ExtendedMutatorFactory;
import com.code_intelligence.jazzer.mutation.api.MutatorFactory;
import com.code_intelligence.jazzer.mutation.api.SerializingMutator;
import com.code_intelligence.jazzer.mutation.combinator.MutatorCombinators;
import com.code_intelligence.jazzer.mutation.support.Preconditions;
import com.code_intelligence.jazzer.mutation.support.PropertyConstraintSupport;
import com.code_intelligence.jazzer.mutation.support.ReflectionSupport;
import com.code_intelligence.jazzer.mutation.support.StreamSupport;
import java.lang.invoke.MethodHandle;
import java.lang.invoke.MethodHandles;
import java.lang.invoke.MethodType;
import java.lang.reflect.AnnotatedType;
import java.lang.reflect.Executable;
import java.lang.reflect.Method;
import java.util.Arrays;
import java.util.Optional;
import java.util.function.BiFunction;
import java.util.function.Function;
import java.util.function.Predicate;
import java.util.function.Supplier;

final class AggregatesHelper {
    static Optional<SerializingMutator<?>> createMutator(ExtendedMutatorFactory factory, AnnotatedType initialType, Executable instantiator, Method[] getters, boolean isImmutable) {
        Preconditions.check(getters.length == instantiator.getParameterCount(), String.format("Number of getters (%d) does not match number of parameters of %s", getters.length, instantiator));
        for (int i = 0; i < getters.length; ++i) {
            Preconditions.check(getters[i].getAnnotatedReturnType().getType().equals(instantiator.getAnnotatedParameterTypes()[i].getType()), String.format("Parameter %d of %s does not match return type of %s", i, instantiator, getters[i]));
        }
        MethodHandles.Lookup lookup = MethodHandles.lookup();
        return AggregatesHelper.createMutator(factory, instantiator.getDeclaringClass(), instantiator.getAnnotatedParameterTypes(), AggregatesHelper.asInstantiationFunction(lookup, instantiator), AggregatesHelper.makeSingleGetter(ReflectionSupport.unreflectMethods(lookup, getters)), initialType, isImmutable).map(m -> m);
    }

    static Optional<SerializingMutator<?>> createMutator(ExtendedMutatorFactory factory, AnnotatedType initialType, Executable newInstance, Method[] getters, Method[] setters) {
        Preconditions.check(getters.length == setters.length, String.format("Number of getters (%d) does not match number of setters (%d)", getters.length, setters.length));
        for (int i = 0; i < getters.length; ++i) {
            Preconditions.check(getters[i].getAnnotatedReturnType().getType().equals(setters[i].getAnnotatedParameterTypes()[0].getType()), String.format("Parameter of %s does not match return type of %s", setters[i], getters[i]));
        }
        MethodHandles.Lookup lookup = MethodHandles.lookup();
        return AggregatesHelper.createMutator(factory, newInstance.getDeclaringClass(), AggregatesHelper.parameterTypes(setters), AggregatesHelper.asInstantiationFunction(lookup, newInstance, setters), AggregatesHelper.makeSingleGetter(ReflectionSupport.unreflectMethods(lookup, getters)), initialType, false).map(m -> m);
    }

    static <R> Optional<SerializingMutator<?>> createMutator(ExtendedMutatorFactory factory, Class<?> instantiatedClass, AnnotatedType[] instantiatorParameterTypes, Function<Object[], R> map, Function<R, Object[]> inverse, AnnotatedType initialType, boolean isImmutable) {
        Supplier<SerializingMutator> mutator = () -> StreamSupport.toArrayOrEmpty(Arrays.stream(instantiatorParameterTypes).map(type -> PropertyConstraintSupport.propagatePropertyConstraints(initialType, type)).map(factory::tryCreate), SerializingMutator[]::new).map(MutatorCombinators::mutateProduct).orElseThrow(MutatorFactory.FailedToConstructChildMutatorException::new);
        BiFunction<SerializingMutator, Predicate, String> debug = (productMutator, inCycle) -> productMutator.toDebugString((Predicate<Debuggable>)inCycle) + " -> " + instantiatedClass.getSimpleName();
        return StreamSupport.suppliedOrEmpty(() -> {
            if (isImmutable) {
                return MutatorCombinators.mutateThenMapToImmutable(mutator, map, inverse, debug, factory::internMutator);
            }
            return MutatorCombinators.mutateThenMap(mutator, map, inverse, debug, factory::internMutator);
        });
    }

    private static <R> Function<R, Object[]> makeSingleGetter(MethodHandle[] getters) {
        return object -> {
            Object[] objects = new Object[getters.length];
            for (int i = 0; i < getters.length; ++i) {
                try {
                    objects[i] = getters[i].invoke(object);
                    continue;
                }
                catch (Throwable e) {
                    throw new RuntimeException(e);
                }
            }
            return objects;
        };
    }

    static Function<Object[], Object> asInstantiationFunction(MethodHandles.Lookup lookup, Executable instantiator) {
        MethodHandle instantiatorHandle = ReflectionSupport.unreflectNewInstance(lookup, instantiator);
        return components -> {
            try {
                return instantiatorHandle.invokeWithArguments(components);
            }
            catch (Throwable e) {
                throw new RuntimeException(e);
            }
        };
    }

    static Function<Object[], Object> asInstantiationFunction(MethodHandles.Lookup lookup, Executable instantiator, Method[] setters) {
        return AggregatesHelper.asInstantiatorFunction(ReflectionSupport.unreflectNewInstance(lookup, instantiator), ReflectionSupport.unreflectMethods(lookup, setters));
    }

    static Function<Object[], Object> asInstantiationFunction(MethodHandles.Lookup lookup, Method instantiator, Method[] setters) {
        return AggregatesHelper.asInstantiatorFunction(ReflectionSupport.unreflectMethod(lookup, instantiator), ReflectionSupport.unreflectMethods(lookup, setters));
    }

    private static <R> Function<Object[], R> asInstantiatorFunction(MethodHandle newInstance, MethodHandle ... setters) {
        boolean settersAreChainable = Arrays.stream(setters).map(MethodHandle::type).map(MethodType::returnType).allMatch(returnType -> returnType.equals(newInstance.type().returnType()));
        if (settersAreChainable) {
            return objects -> {
                try {
                    Object instance = newInstance.invoke();
                    for (int i = 0; i < setters.length; ++i) {
                        instance = setters[i].invoke(instance, objects[i]);
                    }
                    return instance;
                }
                catch (Throwable e) {
                    throw new RuntimeException(e);
                }
            };
        }
        return objects -> {
            try {
                Object instance = newInstance.invoke();
                for (int i = 0; i < setters.length; ++i) {
                    setters[i].invoke(instance, objects[i]);
                }
                return instance;
            }
            catch (Throwable e) {
                throw new RuntimeException(e);
            }
        };
    }

    static AnnotatedType[] parameterTypes(Method[] methods) {
        return (AnnotatedType[])Arrays.stream(methods).map(Executable::getAnnotatedParameterTypes).flatMap(Arrays::stream).toArray(AnnotatedType[]::new);
    }

    private AggregatesHelper() {
    }
}

